/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ycIz
 */

// forked from ProjectNya's Tween24 [Hello!]
// forked from a_24's New tween library Tween24 on wonderfl
////////////////////////////////////////////////////////////////////////////////
// Tween24 [Hello!]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import a24.tween.Tween24;
    import a24.tween.Tween24Event;
    import a24.tween.EventTween24;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var fontloader:FontLoader;
        //private static var basePath:String = "";
        private static var basePath:String = "http://www.project-nya.jp/images/wonderfl/";
        private static var fontPath:String = "MyriadProSemibold.swf";
        private static var className:String = "MyriadProSemibold";
        private var label:Label;
        private var background:Sprite;

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            draw();
            //
            fontloader = new FontLoader();
            fontloader.addEventListener(FontLoader.COMPLETE, initialize, false, 0, true);
            fontloader.load(basePath + fontPath, className);
        }
        private function initialize(evt:Event):void {
            fontloader.removeEventListener(FontLoader.COMPLETE, initialize);
            //
            start();
        }
        //////////////////////////////////////////////////
        // Tween24
        //////////////////////////////////////////////////
        private function start():void {
            var label1:Label = getLabel(40, "more Easily");
            var label2:Label = getLabel(40, "more Speedy");
            var label3:Label = getLabel(40, "and more Powerful");
            var label4:Label = getLabel(32, "New tween library Tween24");
            var label5:Label = getLabel(16, "more comfortable your flash development.");
            //
            var tween1:Tween24 = Tween24.serial(
                Tween24.prop(label1).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.addChild(this, label1),
                Tween24.tween(label1, 0.1).fadeIn(),
                Tween24.tween(label1, 0.1).$x(0),
                Tween24.prop(label1).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                Tween24.wait(1.5),
                Tween24.prop(label1).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.tween(label1, 0.1).$x(200).andRemove(),
                Tween24.wait(0.5)
            );
            var tween2:Tween24 = Tween24.serial(
                Tween24.prop(label2).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.addChild(this, label2),
                Tween24.tween(label2, 0.1).fadeIn(),
                Tween24.tween(label2, 0.1).$x(0),
                Tween24.prop(label2).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                Tween24.wait(1.5),
                Tween24.prop(label2).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.tween(label2, 0.1).$x(200).andRemove(),
                Tween24.wait(0.5)
            );
            var tween3:Tween24 = Tween24.serial(
                Tween24.prop(label3).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.addChild(this, label3),
                Tween24.tween(label3, 0.1).fadeIn(),
                Tween24.tween(label3, 0.1).$x(0),
                Tween24.prop(label3).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                Tween24.wait(1.5),
                Tween24.prop(label3).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                Tween24.tween(label3, 0.1).$x(200).andRemove(),
                Tween24.wait(0.5)
            );
            var tween4:Tween24 = Tween24.serial(
                Tween24.prop(label4).$y(-20).fadeOut().glow(0xFFFFFF, 0.6, 12, 12, 2, 2),
                Tween24.addChild(this, label4),
                Tween24.tween(label4, 0.6).fadeIn(),
                Tween24.wait(0.4),
                Tween24.tween(label4, 0.4).glow(0xFFFFFF, 1, 24, 24, 8),
                Tween24.tween(label4, 0.6).glow(0xFFFFFF, 0.6, 12, 12, 2)
            );
            var tween5:Tween24 = Tween24.serial(
                Tween24.prop(label5).$y(20).alpha(0),
                Tween24.addChild(this, label5),
                Tween24.tween(label5, 1).alpha(0.6)
            );
            var aween:Tween24 = Tween24.serial(
                Tween24.func(EventTween24.enabled, false, background),
                Tween24.wait(0.5),
                tween1, tween2, tween3, tween4, tween5, 
                Tween24.func(EventTween24.enabled, true, background)
            );
            aween.play();
        }
        private function getLabel(w:uint, str:String):Label {
            var label:Label = new Label(464, 40, w, Label.CENTER);
            //addChild(label);
            label.x = 0;
            label.y = 212;
            label.textColor = 0xFFFFFF;
            label.alpha = 0.6;
            label.text = str;
            return label;
        }
        private function draw():void {
            background = new Sprite();
            background.graphics.beginFill(0x000000);
            background.graphics.drawRect(0, 0, 465, 465);
            addChild(background);
            //
            EventTween24.onRollOver(background,
                Tween24.tween(background, 0.05).bright(1),
                Tween24.tween(background, 0.2).bright(0.4)
            );

            EventTween24.onRollOut(background, 
                Tween24.tween(background, 0.4).bright(0)
            );
            
            EventTween24.onClick(background, 
                Tween24.getURL("http://code.google.com/p/tween24/", "_blank")
            );
        }
        
    }

}


//////////////////////////////////////////////////
// FontLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.text.Font;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.LoaderContext;
import flash.utils.getDefinitionByName;

class FontLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    private var _className:String;
    private var _font:Font;
    private var _fontName:String;
    private var embeded:Boolean = false;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FontLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, name:String, e:Boolean = false):void {
        _className = name;
        embeded = e;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            var context:LoaderContext = new LoaderContext();
            context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
            loader.load(new URLRequest(file), context);
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(FontLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(FontLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(FontLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        dispatchEvent(new Event(FontLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        var FontClass:Class = Class(ApplicationDomain.currentDomain.getDefinition(className));
        if (!embeded) {
            Font.registerFont(FontClass);
            _font = Font(new FontClass());
        } else {
            var document:Object = new FontClass();
            _font = document.font;
        }
        _fontName = _font.fontName;
        dispatchEvent(new Event(FontLoader.COMPLETE));
    }
    public function get className():String {
        return _className;
    }
    public function get font():Font {
        return _font;
    }
    public function get fontName():String {
        return _fontName;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "Myriad Pro Semibold";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(value:String):void {
        txt.text = value;
    }
    public function set textColor(value:uint):void {
        txt.textColor = value;
    }

}
