/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ycFh
 */

package {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * More fun with webcam and random typo...
     * @author Devon O.
     */
    [SWF(width='465', height='465', backgroundColor='#000000', frameRate='31')]
    public class Main extends Sprite {
        
        private var _blur:BlurFilter = new BlurFilter(2, 2);
        private var _darken:ColorTransform = new ColorTransform(1, 1, 1, .95);
        private var _pt:Point = new Point();
        private var _original:BitmapData;
        private var _display:BitmapData;
        private var _video:Video;
        private var _mat:Matrix;
        private var _xstep:int;
        private var _ystep:int;
        
        private var _txt:TextField;
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _original = new BitmapData(465, 465, false, 0x000000);
            _display = _original.clone();
            addChild(new Bitmap(_display));
            _mat = new Matrix();
            _xstep = 465 / 31;
            _ystep = 465 / 31;
            
            var fmt:TextFormat = new TextFormat("_serif", 20, 0x000000, true);
            _txt = new TextField();
            _txt.autoSize = TextFieldAutoSize.LEFT;
            _txt.defaultTextFormat = fmt;
            
            if (initVideo())
                addEventListener(Event.ENTER_FRAME, drawImage);
        }
        
        private function initVideo():Boolean {
            _video = new Video(465, 465);
            
            var camIndex:int = 0;
            for ( var i : int = 0 ; i < Camera.names.length ; i++ ) {
                if ( Camera.names[ i ] == "USB Video Class Video" ) {
                    camIndex = i;
                    break;
                }
            }
            var cam:Camera = Camera.getCamera(String(camIndex));
            
            if (cam != null) {
                cam.setMode(465, 465, 15);
                _video.attachCamera(cam);
                return true;
            }
            
            return false;
        }
        
        private function drawImage(event:Event):void {
            _original.draw(_video);
            _display.lock();
            _display.applyFilter(_display, _display.rect, _pt, _blur);
            _display.colorTransform(_display.rect, _darken);
            for (var xx:int = 0; xx < 465; xx += _xstep ) {
                for (var yy:int = 0; yy < 465; yy += _ystep) {
                    _txt.textColor = _original.getPixel(xx, yy);
                    _txt.text = String.fromCharCode(randRange(90, 65));
                    _mat.identity();
                    _mat.translate(xx, yy);
                    _display.draw(_txt, _mat);
                }
            }
            
            _display.unlock();
        }
        
        private function randRange(max:Number, min:Number = 0, decimals:int = 0):Number {
            if (min > max) return NaN;
            var rand:Number = Math.random() * (max - min) + min;
            var d:Number = Math.pow(10, decimals);
            return ~~((d * rand) + 0.5) / d;
        }
    }
}