/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ybYd
 */

package {
    
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    import net.hires.debug.Stats;
    
    public class Twist extends Sprite {

        private static const RADIUS:Number = 120;
        private static const THICK:Number = 31;
        
        private var vertices:Vector.<Vertex>;
        private var size:Number;
        private var yc:Number;
        private var bmpData:BitmapData;
        private var time:uint;
                
        public function Twist() {
//          addChild(new Stats());
            vertices = Vector.<Vertex>([
                new Vertex(0, 0xff0000),
                new Vertex(0, 0xff9900),
                new Vertex(0, 0x009900),
                new Vertex(0, 0x0099ff),
                new Vertex(0, 0xffffff)
            ]);
            size = 2 * RADIUS * Math.sin(Math.PI / vertices.length);
            yc = stage.stageHeight / 2;
            time = 0;
            bmpData = new BitmapData(1, 1);
            addEventListener(
                Event.ENTER_FRAME,
                function (e:Event):void {
                    ++time;
                    bmpData.perlinNoise(3, 0, 1, 108, false, true, 4, false, [new Point(time / 17.0, 0)]);
                    draw((bmpData.getPixel(0, 0) - 128.0) / 128.0 * 2 * Math.PI, (time / 41.0) * Math.PI);
                }
            );
        }
        
        private function draw(tx:Number, ty:Number):void {
            var g:Graphics = graphics;
            var n:uint = stage.stageWidth - 1;
            var i:uint;
            g.clear();
            g.beginFill(0x000033);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            g.endFill();
            for (var px:uint = 0; px <= n; px += THICK) {
                var fi:Number = tx * px / n + ty;
                for (i = 0; i < vertices.length; ++i) {
                    vertices[i].coord = RADIUS * Math.cos(2 * Math.PI * i / vertices.length + fi);
                }
                for (i = 0; i < vertices.length; ++i) {
                    var y1:Number = vertices[i].coord;
                    var y2:Number = vertices[(i + 1) % vertices.length].coord;
                    if (y1 < y2) {
                        g.beginFill(color(vertices[i].color, (y2 - y1) / size));
                        g.drawRect(px, yc + y1, THICK, y2 - y1);
                        g.endFill();
                    }
                }
            }
        }
        
        private function color(c:uint, q:Number):uint {
            var r:uint = c >> 16;
            var g:uint = (c >> 8) & 0xff;
            var b:uint = c & 0xff;
            return ((r * q) >> 0) << 16 | ((g * q) >> 0) << 8 | (b * q) >> 0;
        }
    }
}

class Vertex {
    
    public var coord:Number;
    public var color:uint;
    
    public function Vertex(y:Number, c:uint) {
        coord = y;
        color = c;
    }
}
