/**
 * Copyright kinoppy ( http://wonderfl.net/user/kinoppy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yavY
 */

// forked from ProjectNya's ひよこちゃんをドラッグしてスライドさせる
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃんをドラッグしてスライドさせる
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.system.LoaderContext;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var sunshinePath:String = "9/9b/9bbe/9bbec77d53bddc5e7a5f2c00abbade6bd641c549";
        private var loader:Loader;
        private static var piyoPath:String = "http://www.project-nya.jp/images/flash/piyo2d.swf";
        private var Piyo:Class;
        private var piyo:MovieClip;
        private var position:Number = 0;
        private var clickPos:Number = 0;
        private static var deceleration:Number = 0.2;

        public function Main() {
            //Wonderfl.disable_capture();
            Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            draw();
            Security.allowDomain("www.project-nya.jp");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(piyoPath), new LoaderContext(true));
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(Event.COMPLETE, complete);
            var content:MovieClip = MovieClip(evt.target.content);
            //Piyoクラス
            Piyo = MovieClip(content.piyo).constructor;
            setup();
            loader = null;
        }
        private function setup():void {
            //Piyoインスタンス
            piyo = new Piyo();
            addChild(piyo);
            piyo.x = 232;
            piyo.y = 380;
            piyo.scale = 2;
            //ドラッグできるようにする
            piyo.mouseChildren = false;
            piyo.buttonMode = true;
            piyo.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        }
        //マウスダウンでドラッグ開始
        private function press(evt:MouseEvent):void {
            piyo.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
            stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
            clickPos = piyo.mouseX;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
        }
        //マウスアップでドラッグ停止
        private function release(evt:MouseEvent):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        }
        //ドラッグ停止
        private function releaseOutside(evt:MouseEvent):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        }
        private function leave(evt:Event):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        }
        //ドラッグ
        private function drag(evt:MouseEvent):void {
            position = stage.mouseX - clickPos;
            if (position < 60) position = 60;
            if (position > 405) position = 405;
            if (!hasEventListener(Event.ENTER_FRAME)) addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
        }
        private function slide(evt:Event):void {
            piyo.x += (position - piyo.x)*deceleration;
            if (Math.abs(position - piyo.x) < 0.5) {
                piyo.x = position;
                removeEventListener(Event.ENTER_FRAME, slide);
            }
        }
        /////////////////////////////////////////////
        //背景
        /////////////////////////////////////////////
        private function draw():void {
            drawSky();
            drawGround();
            drawSun();
        }
        private function drawSky():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 350, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x3F68AB, 0x77B2EE], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 350);
            graphics.endFill();
        }
        private function drawGround():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 150, 0.5*Math.PI, 0, 350);
            graphics.beginGradientFill(GradientType.LINEAR, [0x99CC33, 0x7EB133], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 350, 465, 150);
            graphics.endFill();
        }
        private function drawSun():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(200, 200, 0, -90, -90);
            graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xFFFFFF, 0xFFFFFF], [1, 0.3, 0], [25, 102, 231], matrix);
            graphics.drawCircle(10, 10, 100);
            graphics.endFill();
            var shine:Loader = new Loader();
            addChild(shine);
            shine.alpha = 0.5;
            shine.load(new URLRequest(basePath + sunshinePath), new LoaderContext(true));
        }

    }

}
