/**
 * Copyright cvelenosi ( http://wonderfl.net/user/cvelenosi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yat9
 */

// forked from fcukie's forked from: BitmapData pieces
package  {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]
    public class Main2 extends Sprite {
        
        static private const BMD_WIDTH:uint = 465;
        static private const BMD_HEIGHT:uint = 465;
        static private const BMD_RECT:Rectangle = new Rectangle(0, 0, BMD_WIDTH, BMD_HEIGHT);
        static private const COLOR_TRANSFORM:ColorTransform = new ColorTransform(1, 1, 1, 0.9);
        
        private var offset_x:int;
        private var offset_y:int;
        
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var piece0:Piece;
        
        private var mouse_down:Boolean;
        
        public function Main2() {
            setup();
            
            addChild(new Stats());
        }        

        private function setup():void {
            bmd = new BitmapData(BMD_WIDTH, BMD_HEIGHT, false, 0x000000);
            bmp = new Bitmap(bmd);
            addChild(bmp);            

            var cols:uint = 300;
            var rows:uint = 300;       

            offset_x = (BMD_WIDTH - cols * 2) / 2;
            offset_y = (BMD_HEIGHT - rows * 2) / 2;            

            var p:Piece;
            var c:uint;
            var prev:Piece;
            for (var i:int = 0; i < cols; i++) {
                for (var j:int = 0; j < rows; j++) {
                    c = j / cols * 255 << 16 | i / rows * 255 << 8 | 180;
                    
                    p = new Piece(randomRange( -offset_x, BMD_WIDTH - offset_x), randomRange( -offset_y, BMD_HEIGHT - offset_y), c);
                    p.damp = randomRange(50, 150) / 1000;
                    p.home_force = randomRange(30, 90) / 10000;
                    p.setTarLoc(i * 2, j * 2);                    

                    if (!piece0) {
                        piece0 = p;
                    } else {
                        prev.next = p;
                    }
                    prev = p;
                }
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        private function onEnterFrame(e:Event):void {
            bmd.lock();
            
            var force:int = -2;
            if (mouse_down) {
                mouse_down = false;
                force = -200;
            }
            
            var p:Piece = piece0;
            while (p) {
                p.addForce(mouseX - offset_x, mouseY - offset_y, 100, force);
                p.seekHome();
                p.addDamping();
                p.update();
                
                bmd.setPixel(p.x + offset_x, p.y + offset_y, p.color);                
                p = p.next;
            }
            
            bmd.colorTransform(BMD_RECT, COLOR_TRANSFORM);
            bmd.unlock();
        }
        
        private function onMouseDown(e:MouseEvent):void {
            mouse_down = true;
        }
        
        private function randomRange(_min:int, _max:int):int {
            return Math.floor(Math.random() * (_max - _min + 1)) + _min
        }        
    }
}

class Piece {
    
    //position
    public var x:Number;
    public var y:Number;
    //velocity
    private var vx:Number = 0;
    private var vy:Number = 0;
    //acceleration
    private var ax:Number = 0;
    private var ay:Number = 0;
    //target
    private var tx:Number;
    private var ty:Number;    

    public var color:uint;
    public var damp:Number;
    public var home_force:Number;
    public var next:Piece;    

    public function Piece(_x:Number, _y:Number, _color:uint) {
        x = _x;
        y = _y;
        color = _color;
    }    

    public function update():void {
        vx += ax;
        vy += ay;
        x += vx;
        y += vy;
        
        ax = ay = 0;
    }
    
    public function setTarLoc(_x:Number, _y:Number):void {
        tx = _x;
        ty = _y;
    }
    
    public function addForce(_x:Number, _y:Number, _min_dist:Number, _scale:Number):void {
        var _dx:Number = _x - x;
        var _dy:Number = _y - y;
        var _d:int = _dx * _dx + _dy * _dy;        

        if (_d < _min_dist * _min_dist) {
            _d = Math.sqrt(_d);
            var _pct:Number = 1 - (_d / _min_dist);
            _dx = _dx / _d * _scale * _pct;
            _dy = _dy / _d * _scale * _pct;
            ax += _dx;
            ay += _dy;
        }
    }    

    public function seekHome():void {
        var _dx:Number = tx - x;
        var _dy:Number = ty - y;
        _dx *= home_force;
        _dy *= home_force;
        ax += _dx;
        ay += _dy;
    }
    
    public function addDamping():void {
        var _dx:Number = ax - vx;
        var _dy:Number = ay - vy;
        _dx *= damp;
        _dy *= damp;
        ax += _dx;
        ay += _dy;
    }    

    public function toString():String {
        return "x = " + x + " y = " + y
    }    
}