/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yaPg
 */

// -------------------------------------------------
//
// 線状にサインカーブで伸縮するフィルタ
// 
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;

    public class Main extends Sprite {
        public function Main() {

	

// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート       
stage.frameRate = 60;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを配置
var board : Sprite = new Sprite();
addChild(board);

// リソース読み込み開始
load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	// 画像のURL
	var graphic_url:String = "http://actionscript.web.officelive.com/wonderfl/bg000.jpg";

	// ローダー
	var loader_obj : Loader = new Loader();
	
	// 読み込み開始
	var url : URLRequest = new URLRequest(graphic_url);
	loader_obj.load(url);
	
	// 読み込み終了
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// 読み込んだ画像を表示
		board.addChild(loader_obj);

		// 初期化へ
		init();
	}
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint;
	var h:uint;	
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		board.width = w;
		board.height = h;
	}
	ResizeFunc(null);
	
	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;

	// パラメータ
	var phase:Number = 0;		// 位相
	var amplitude:Number = 30;	// 振幅
	var cycle:Number = 300;		// 周期

	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		
		// 位相を変化
		phase += 0.01;
		if(phase > 1)	phase -= 1;

		// 角度
		var rot : Number = Math.atan2(h/2 - mouseY,w/2 - mouseX) * 180 / Math.PI;
		param = data.rotate;
		param.value = [rot];					

		// 位相
		param = data.phase;
		param.value = [phase];

		// 振幅
		param = data.amplitude;
		param.value = [amplitude];

		// 周期
		param = data.cycle;
		param.value = [cycle];

		// 適応
		board.filters = [filter];
	});
	
	// テキスト表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 200;
	tf.height = 40;
	tf.border = true;
	tf.background = true;
	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "振幅:" + amplitude + "　(上下キーで変更)\n";
		str += "周期:" + cycle + "　(左右キーで変更)\n";
		
		tf.text = str;
	});
	
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == Keyboard.UP)		amplitude -= 1;
		if(event.keyCode == Keyboard.DOWN)	amplitude += 1;
		if(event.keyCode == Keyboard.LEFT)	cycle -= 10;
		if(event.keyCode == Keyboard.RIGHT)	cycle += 10;
		
		if(amplitude < 0)	amplitude = 0;
		if(cycle < 0)	cycle = 0;
	};

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a41300); f(0x5363616c); f(0x65576176); 
	f(0x654c696e); f(0x6546696c); f(0x746572a0); f(0x0c6e616d); 
	f(0x65737061); f(0x63650073); f(0x63616c65); f(0x20776176); 
	f(0x65206c69); f(0x6e6500a0); f(0x0c76656e); f(0x646f7200); 
	f(0x48616b75); f(0x68696e00); f(0xa0087665); f(0x7273696f); 
	f(0x6e000100); f(0xa00c6465); f(0x73637269); f(0x7074696f); 
	f(0x6e0090fc); f(0x8ff382c9); f(0x83548343); f(0x8393834a); 
	f(0x815b8375); f(0x82c5904c); f(0x8f6b82b7); f(0x82e98374); 
	f(0x8342838b); f(0x835e00a1); f(0x01020000); f(0x0c5f4f75); 
	f(0x74436f6f); f(0x726400a3); f(0x00047372); f(0x6300a102); 
	f(0x0401000f); f(0x64737400); f(0xa1010100); f(0x00026379); 
	f(0x636c6500); f(0xa2016d69); f(0x6e56616c); f(0x7565003f); 
	f(0x800000a2); f(0x01646566); f(0x61756c74); f(0x56616c75); 
	f(0x650042c8); f(0x0000a20c); f(0x64657363); f(0x72697074); 
	f(0x696f6e00); f(0x946782aa); f(0x88ea8efc); f(0x82b782e9); 
	f(0x92b782b3); f(0x00a10101); f(0x00000170); f(0x68617365); 
	f(0x00a2016d); f(0x696e5661); f(0x6c756500); f(0x00000000); 
	f(0xa2016d61); f(0x7856616c); f(0x7565003f); f(0x800000a2); 
	f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65000000); 
	f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
	f(0x946782cc); f(0x88ca918a); f(0x00a10101); f(0x02000861); 
	f(0x6d706c69); f(0x74756465); f(0x00a2016d); f(0x696e5661); 
	f(0x6c756500); f(0x00000000); f(0xa2016465); f(0x6661756c); 
	f(0x7456616c); f(0x75650041); f(0x200000a2); f(0x0c646573); 
	f(0x63726970); f(0x74696f6e); f(0x00946782); f(0xcc976882); 
	f(0xea959d00); f(0xa1010102); f(0x0004726f); f(0x74617465); 
	f(0x00a2016d); f(0x696e5661); f(0x6c756500); f(0x00000000); 
	f(0xa2016d61); f(0x7856616c); f(0x75650043); f(0xb40000a2); 
	f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65000000); 
	f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
	f(0x946782cc); f(0x8a709378); f(0x001d0200); f(0x31000010); 
	f(0x00320300); f(0x803c8efa); f(0x35030300); f(0x80020040); 
	f(0x001d0300); f(0x40030000); f(0x000d0300); f(0x80030040); 
	f(0x001d0300); f(0x20030000); f(0x000c0300); f(0x80030040); 
	f(0x001d0300); f(0x10030000); f(0x001d0400); f(0xc10300b0); 
	f(0x001d0300); f(0x80040000); f(0x00030300); f(0x80020080); 
	f(0x001d0300); f(0x20040040); f(0x00030300); f(0x200200c0); 
	f(0x001d0300); f(0x10030000); f(0x00010300); f(0x10030080); 
	f(0x00320300); f(0x80000000); f(0x00020300); f(0x800300c0); 
	f(0x001d0300); f(0x20030000); f(0x001d0400); f(0x31040010); 
	f(0x00030400); f(0x310300a0); f(0x001d0400); f(0xc10400b0); 
	f(0x001d0300); f(0x80040000); f(0x00030300); f(0x80040000); 
	f(0x001d0300); f(0x10040040); f(0x00030300); f(0x10040040); 
	f(0x001d0400); f(0x20030000); f(0x00010400); f(0x200300c0); 
	f(0x00160300); f(0x80040080); f(0x001d0300); f(0x10030000); 
	f(0x00040300); f(0x80000080); f(0x00030300); f(0x800300c0); 
	f(0x001d0400); f(0x20030000); f(0x001a0300); f(0x80040080); 
	f(0x001d0400); f(0x10040080); f(0x00020400); f(0x10030000); 
	f(0x001d0400); f(0x200400c0); f(0x001d0300); f(0x80040080); 
	f(0x00010300); f(0x800000c0); f(0x00320400); f(0x1043b400); 
	f(0x001d0500); f(0x80030000); f(0x00030500); f(0x800400c0); 
	f(0x00320300); f(0x803c8efa); f(0x35030300); f(0x80050000); 
	f(0x000c0400); f(0x10030000); f(0x001d0300); f(0x800400c0); 
	f(0x00030300); f(0x80020000); f(0x001d0300); f(0x10030000); 
	f(0x000d0300); f(0x80030040); f(0x001d0400); f(0x10030000); 
	f(0x00030400); f(0x100300c0); f(0x00010200); f(0x200400c0); 
	f(0x000c0300); f(0x80030040); f(0x001d0400); f(0x10030000); 
	f(0x00030400); f(0x100300c0); f(0x00010200); f(0x100400c0); 
	f(0x00310500); f(0xf10200b0); f(0x001d0100); f(0xf305001b); 
	
	f = a.writeByte;
	f(0x00); 

	return a;

}

            
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	cycle			波が一周する長さ
	phase			波の位相 ( 0 ～ 1 までゆっくり変化させる)
	amplitude		波の揺れ幅
	rotate			波の角度(0～360)
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel ScaleWaveLineFilter<
	namespace : "scale wave line";
	vendor : "Hakuhin";
	version : 1;
	description : "線状にサインカーブで伸縮するフィルタ";
>{
	input image4 src;	// 入力イメージ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float cycle<
		minValue:float(1.0);
		defaultValue:float(100.0);
		description : "波が一周する長さ";
	>;
	parameter float phase<
		minValue:float(0.0);
		maxValue:float(1.0);
		defaultValue:float(0);
		description : "波の位相";
	>;
	parameter float amplitude<
		minValue:float(0.0);
		defaultValue:float(10.0);
		description : "波の揺れ幅";
	>;
	parameter float rotate<
		minValue:float(0.0);
		maxValue:float(360.0);
		defaultValue:float(0);
		description : "波の角度";
	>;


	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){

		// ピクセルの位置を取得
		float2 pos = outCoord();

		// 角度をラジアンに変更
		float rad = radians(rotate);
		
		// ラジアンをベクトルに変換
		float2 v = float2(cos(rad),sin(rad));

		// 角度に垂直で原点を通る線と現在の位置との距離を取得
		float t = -(v.x * pos.x + v.y * pos.y);
        v = v * t;
		float distance = sqrt((v.x * v.x) + (v.y * v.y));
		
		// 周期に丸める
		float d = distance / cycle;
		d = d - floor(d);
		
		// オフセットを取得して座標に加算
		distance = sin(radians((d + phase) * 360.0)) * amplitude;
		pos.x += cos(rad) * distance;
		pos.y += sin(rad) * distance;

		// ソースイメージからピクセルカラーを取得して出力
		dst = sampleLinear(src,pos);
	}
}
*/



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	
	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}