/**
 * Copyright omr ( http://wonderfl.net/user/omr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yaAA
 */

package 
{
    import flash.geom.Point;
    import frocessing.display.*;
 
    public class FrocessingSample02 extends F5MovieClip2DBmp {
        //描画サイズ
        private var m_stage_width:Number  = 500;
        private var m_stage_height:Number = 500;
       
        //図形描画の座標
        private var m_points/*Point*/:Array;  //座標を入れる
       
        private var m_point_current_index:int = 0;  //何番目の座標まで描画するか
       
        //線と塗りの色
        private var m_color:uint;
           
        public function FrocessingSample02(){
            super();
        }
       
        //初期化 Stage が呼び込まれたときに自動的に呼ばれる
        public function setup():void {
           
            //描画範囲指定
            size( m_stage_width, m_stage_height );
           
            //背景色指定（引数の数によって色の指定方法が変わる）
            background(0, 0);  // color, alpha
        }
       
       
        //図形描画の座標をセット
        private function setPoints(base_x:Number, base_y:Number):void {
           
            m_point_current_index = 0;
            m_points = new Array();
           
            var len:int = m_stage_width - random(m_stage_height / 1.5);
            var point_num:int = len / 10;
           
            var step:int = len / point_num + random(5, 1);
           
            var yure:Number = random(5, 1);  //くねくねサイズ
           
            var pt:Point;
           
            for (var i:int = 0; i <point_num ; i++) {
                pt = new Point(random(yure, -yure) + base_x, -step * i + base_y);
                m_points.push(pt);
            }
           
            //始点と終点は同じ値を2つ入れる（始点と終点はコントロールポイントになってるっぽいので）
            pt = m_points[0].clone();
            m_points.unshift(pt);
           
            pt = m_points[m_points.length - 1].clone();
            m_points.push(pt);
        }
       
        //ランダムな色を設定
        private function setRandomColor():void {
           
            var r:uint = random(200, 50);
            var g:uint = random(200, 50);
            var b:uint = random(200, 50);
           
            m_color = this.color(r, g, b);
        }
       
       
        //描画（フレーム毎に繰り返し）
        public function draw():void {
           
            //マウスが押された場合
            if ( isMousePressed ){
                //色再設定
                setRandomColor();
               
                //座標再設定
                setPoints(mouseX, mouseY - m_stage_height);
            }
           
            if (m_points != null) {
               
                var i:int = 0;  //汎用カウンタ
                var maru_size:Number = 0;  //円サイズ
               
                //原点の移動
                translate( 0, m_stage_height);
               
                //-----くねくね線-----
               
                //塗りをなしに
                noFill();
               
                //線色の指定（引数の数によって色の指定方法が変わる）
                stroke(m_color, 0.5);  //color, alpha
               
                //線幅指定
                strokeWeight(0.1);
               
                var pt:Point;
               
                //頂点を複数持つ図形の描画
                beginShape();
                for (i = 0; i <m_point_current_index ; i++) {
                    pt = m_points[i];
                    curveVertex(pt.x, pt.y);
                }
                endShape();
               
                //枝
                if(m_point_current_index> 0 && m_point_current_index <m_points.length - 1){
                   
                    //枝の先の座標設定
                    if(m_point_current_index> 0){
                        pt = m_points[m_point_current_index - 1];
                    }
                    else {
                        pt = m_points[0];
                    }
                    var eda_inc_x:Number = random(30, 0);
                    if (random(1)> 0.5) {
                        eda_inc_x *= -1;
                    }
                    var eda_inc_y:Number = random( -10, -30);
                   
                    var eda_x:Number = eda_inc_x + pt.x;
                    var eda_y:Number = eda_inc_y + pt.y;
                   
                    //直線
                    line(pt.x, pt.y, eda_x, eda_y);
                   
                    //枝の先のランダムな円いくつか
                    noStroke();
                    fill(m_color, 0.5);
                   
                    for (i = 0; i <5;i++){
                        maru_size = random(10, 1);
                        ellipse(eda_x + random(10, -10), eda_y + random(10, -10), maru_size, maru_size);
                    }
                }
               
                //伸び始め位置に円を書く
                if (m_point_current_index == 0) {
                   
                    noStroke();
                    fill(m_color, 0.5);
                   
                    maru_size = 0;
                    for (i = 1; i <5; i++){
                        maru_size += i * random(5, 2);
                        ellipse(m_points[1].x, m_points[1].y, maru_size, maru_size);
                    }
                }
 
                //描画する座標進める
                m_point_current_index++;
               
                //最後の座標まで行ったら、次の座標が設定されるまで描画止める
                if (m_point_current_index> m_points.length) {
                    m_point_current_index = 0;
                    m_points = null;
                }
           
            }
        }
       
        //描画をリセットする
        public function reset():void {
           
            background(0, 0);
        }
    }
}