/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yZdL
 */

// forked from bkzen's 【問題】Graphics の drawCircle と drawRoundRect が壊れました
package 
{
	import flash.display.Graphics;
	import flash.display.Shader;
	import flash.display.Sprite;
	import flash.events.Event;
	import mx.utils.Base64Decoder;
	
	/**
	 * Graphics.drawCircle と drawRoundRect が壊れました。
	 * 別の方法で、半径 CIRCLE_RADIUS の 円を書きなさい。
	 * @mxmlc -o bin/CircleTest.swf -load-config+=obj\Alltest3Config.xml
	 * @author jc at bk-zen.com
	 */
	public class CircleTest extends Sprite
	{
		private const ANSWER_COLOR: uint = 0x003366;
		private const COLOR: uint = 0x3399CC;
		private const CIRCLE_RADIUS: Number = 50;
		
		public function CircleTest() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
			var centerX: Number = (stage.stageWidth - CIRCLE_RADIUS) / 2;
			var centerY: Number = (stage.stageHeight - CIRCLE_RADIUS) / 2;
			var g: Graphics = graphics;
			// 差を見るために解答として先に半径+1 の円を描いておきます。
			g.beginFill(ANSWER_COLOR); g.drawCircle(centerX, centerY, CIRCLE_RADIUS + 1);
			
			// 
			drawCircle(g, centerX, centerY, CIRCLE_RADIUS, COLOR);
		}
		
		/**
		 * これを作る。
		 * @param	g
		 * @param	x
		 * @param	y
		 * @param	r
		 * @param	color
		 */
		public function drawCircle(g: Graphics, x: Number, y: Number, r: Number, color: uint): void
		{
			_drawCircleKernel.data.center.value[0] = y;
			_drawCircleKernel.data.center.value[1] = x;
			_drawCircleKernel.data.color.value[0] = ((color & 0xff0000) >> 16) / 0xff;
			_drawCircleKernel.data.color.value[1] = ((color & 0x00ff00) >>  8)/ 0xff;
			_drawCircleKernel.data.color.value[2] = ((color & 0x0000ff)) / 0xff;
			_drawCircleKernel.data.radius.value[0] = r;
			
			g.beginShaderFill(_drawCircleKernel);
			g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			g.endFill();
		}
		
		private var _drawCircleKernel:Shader = (function ():Shader {
		    var shader:Shader = new Shader;
			var decoder:Base64Decoder = new Base64Decoder;
			decoder.decode(<drawCircle>
DIcxpQEAAACkCgBEcmF3Q2lyY2xloAxuYW1lc3BhY2UAOXJlAKAMdmVuZG9yADlyZQCgCHZlcnNp
b24AAQCgDGRlc2NyaXB0aW9uAHlvdXIgZGVzY3JpcHRpb24AoQECAAAMX091dENvb3JkAKEBAgAA
A2NlbnRlcgCiAm1pblZhbHVlAAAAAAAAAAAAogJtYXhWYWx1ZQBJEnwASRJ8AKICZGVmYXVsdFZh
bHVlAEM0AABDNAAAoQEBAQAIcmFkaXVzAKIBbWluVmFsdWUAAAAAAKIBbWF4VmFsdWUASRJ8AKIB
ZGVmYXVsdFZhbHVlAELIAAChAQQCAA9jb2xvcgCiBG1pblZhbHVlAAAAAAAAAAAAAAAAAAAAAACi
BG1heFZhbHVlAD+AAAA/gAAAP4AAAD+AAACiBGRlZmF1bHRWYWx1ZQAAAAAAAAAAAAAAAAA/gAAA
oQIEAwAPcmVzdWx0AB0BAGEAABAAAgEAYQAAsAAdBADBAQBgACQBAEEEABAAHQEAIAEAQAAqAQAg
AQAAAB0BgIAAgAAANAAAAAGAAAAdAwDzAgAbADUAAAAAAAAAMgMAgAAAAAAyAwBAAAAAADIDACAA
AAAAMgMAEAAAAAA2AAAAAAAAAA==</drawCircle>);
			shader.byteCode = decoder.drain().readObject();
		    
		    return shader;
		})();
		
<pbk>
<![CDATA[		
<languageVersion : 1.0;>

kernel DrawCircle
<   namespace : "9re";
    vendor : "9re";
    version : 1;
    description : "drwing circle with shader";
>
{
    parameter float2 center
    <
        minValue: float2(0.0);
        maxValue: float2(600000.0);
        defaultValue: float2(180.0);
    >;
    parameter float radius
    <
        minValue: 0.0;
        maxValue: 600000.0;
        defaultValue: 100.0;
    >;
    parameter pixel4 color
    <
        minValue: float4(0.0,0.0,0.0,0.0);
        maxValue: float4(1.0,1.0,1.0,1.0);
        defaultValue: float4(0.0,0.0,0.0,1.0);
    >;
    output pixel4 result;
	
    void evaluatePixel() {
        float2 coord_for_this_pixel = outCoord() - center;
        float cur_radius = length(coord_for_this_pixel);
        if (cur_radius < radius) {
            result = color;
        }
        else {
			result = float4(0.0, 0.0, 0.0, 0.0);
        }
    }
}
]]>
</pbk>
	}

}