/**
 * Copyright flashrod ( http://wonderfl.net/user/flashrod )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yZB5
 */

// analog clock
package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    [SWF(frameRate="1")]
    public class Aclock extends Sprite {
        private var r:Number = 465/2*0.8;
        private var cx:int = int(465/2);
        private var cy:Number = int(465/2);
        private var fg:Shape = new Shape();
        public function Aclock() {
            for (var i:int = 0; i < 12; ++i) {
                var t:Number = i / 6 * Math.PI;
                graphics.beginFill(0x888888);
                graphics.drawCircle(cx + r*Math.cos(t), cy + r*Math.sin(t), 8);
                graphics.endFill();
            }
            fg.filters = [new DropShadowFilter()];
            addChild(fg);
            addEventListener(Event.ENTER_FRAME, repaint);
        }
        private function repaint(e:Event):void {
            var d:Date = new Date();
            var h:Number = (d.hours + d.minutes/60-3) / 6 * Math.PI;
            var m:Number = (d.minutes + d.seconds/60-15) / 30 * Math.PI;
            var s:Number = (d.seconds-15) / 30 * Math.PI;
            fg.graphics.clear();
            for each (var o:Object in [{w:8, c:0x008800, x:(r*0.6)*Math.cos(h), y:(r*0.6)*Math.sin(h)},
                                       {w:4, c:0x000088, x:(r*0.8)*Math.cos(m), y:(r*0.8)*Math.sin(m)},
                                       {w:0, c:0xFF0000, x:(r*0.9)*Math.cos(s), y:(r*0.9)*Math.sin(s)}]) {
                fg.graphics.lineStyle(o.w, o.c);
                fg.graphics.moveTo(cx, cy);
                fg.graphics.lineTo(cx + o.x, cy + o.y);
            }
        }
    }
}
