/**
 * Copyright staticmh ( http://wonderfl.net/user/staticmh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yYV9
 */

// forked from actionscriptbible's Chapter 37 Example 13
package {
  import flash.display.*;
  import flash.events.Event;
  import flash.filters.DisplacementMapFilter;
  import flash.filters.DisplacementMapFilterMode;
  import flash.geom.*;
  import flash.net.URLRequest;
  [SWF(backgroundColor="#000000",frameRate="50")]
  public class ch37ex13 extends Sprite {
    protected const FLAG_WIDTH:Number = 660, FLAG_HEIGHT:Number = 480;
    protected const WIND_SPEED:Number = -10;
    protected const DISPLACEMENT:Number = 20;
    protected const OCTAVES:int = 3;
    protected const SHIFT_COLORS:ColorTransform = new ColorTransform(2, 2, 2, 1, -128, -128, -128, 0);
    protected var flag:DisplayObject;
    protected var fadeOutWave:Shape;
    protected var map:BitmapData;
    protected var offsets:Array;
    protected var perlinSeed:Number;
    protected var displacementFilter:DisplacementMapFilter;
    public function ch37ex13() {
      var l:Loader = new Loader();
      var image:URLRequest = new URLRequest("http://upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Flag_of_Israel.svg/660px-Flag_of_Israel.svg.png");
      l.load(image);
      l.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
    }
    protected function onLoadComplete(event:Event):void {
      flag = LoaderInfo(event.target).content;
      flag.width = FLAG_WIDTH;
      flag.height = FLAG_HEIGHT;
      flag.x = 20;
      map = new BitmapData(FLAG_WIDTH, FLAG_HEIGHT, false, 0x808080);
      displacementFilter = new DisplacementMapFilter(map, new Point(),
          BitmapDataChannel.RED, BitmapDataChannel.RED,
          DISPLACEMENT*0.7, DISPLACEMENT,
          DisplacementMapFilterMode.COLOR);
      addChild(flag);
      flag.filters = [displacementFilter];
      perlinSeed = int(Math.random() * int.MAX_VALUE);
      offsets = new Array();
      for (var i:int = 0; i < OCTAVES; i++) offsets[i] = new Point();
      
      fadeOutWave = new Shape();
      var m:Matrix = new Matrix();
      m.createGradientBox(FLAG_WIDTH/2, FLAG_HEIGHT);
      fadeOutWave.graphics.beginGradientFill(GradientType.LINEAR, [0x808080, 0x808080], [1, 0], [0, 255], m);
      fadeOutWave.graphics.drawRect(0, 0, FLAG_WIDTH/2, FLAG_HEIGHT);
      fadeOutWave.graphics.endFill();
      
      var shadeBitmap:Bitmap = new Bitmap(map);
      shadeBitmap.height = FLAG_HEIGHT + DISPLACEMENT*2;
      shadeBitmap.width = FLAG_WIDTH + DISPLACEMENT;
      shadeBitmap.y = -DISPLACEMENT;
      addChild(shadeBitmap);
      shadeBitmap.blendMode = BlendMode.OVERLAY;
      shadeBitmap.alpha = 0.4;
      
      this.x = 50; this.y = 50;
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      for (var i:int = 0; i < OCTAVES; i++) {
        offsets[i].x += Math.pow((1+i), 0.2) * WIND_SPEED;
      }
      map.perlinNoise(map.width, map.height * 6, OCTAVES, perlinSeed, false, true, 0, true, offsets);
      map.colorTransform(map.rect, SHIFT_COLORS);
      map.draw(fadeOutWave);
      displacementFilter.mapBitmap = map;
      flag.filters = [displacementFilter];
    }
  }
}