/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yYJb
 */

package {
    /**
     * あのメニュー
     * @author ksnmt
     * 
     * 
     * カーソルキーでメニュー選択
     */
    
    /* Flash
    // /////////////////////////////////////////////////////// */
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.ui.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.tweens.ITweenGroup;
    
    [SWF(backgroundColor="#222222", frameRate="120")]
    public class MainMenuGadget extends Sprite {
        
        /* Var
        // /////////////////////////////////////////////////////// */
        private var contents:Vector.<Menu> = Vector.<Menu>([
            new Menu(0x000000, "The"),
            new Menu(0x111111, "quick"),
            new Menu(0x222222, "brown"),
            new Menu(0x333333, "fox"),
            new Menu(0x444444, "jumps"),
            new Menu(0x555555, "over"),
            new Menu(0x666666, "the"),
            new Menu(0x777777, "lazy"),
            new Menu(0x888888, "dog"),
            new Menu(0x999999, "Hello"),
            new Menu(0xAAAAAA, "World"),
            new Menu(0xBBBBBB, "Wonderfl")
        ]);
        
        private var DUMMY:Menu = new Menu(0x0, "Foo");
        
        /** start index */
        private var _startIndex:int = 0;
        
        private var _container:Vector.<Menu> = new Vector.<Menu>();
        
        private var group:ITweenGroup = BetweenAS3.parallelTweens([]);
        
        /**
         * constructor
         * @param    kernel
         * @param    width
         * @param    height
         */
        public function MainMenuGadget(/*kernel:IKernel, width:int = 0, height:int = 0*/) {
            this.addEventListener(Event.ADDED, added);
        }
        
        /**
         * added
         * @param    e
         */
        private function added(e:Event = null):void {
            this.removeEventListener(Event.ADDED, added);
            this.createMainMenu();
        }
        
        private function createMainMenu():void {
            
            for (var counter:int = 0, index:int = _startIndex; counter < Menu.MENU_ROWS; counter++, index++) {
                
                if (contents.length == index) index = 0;
                
                var handlingMenu:Menu = this.addChild(contents[index]) as Menu;
                handlingMenu.x = Menu.MENU_START_POINT.x;
                handlingMenu.y = Menu.Y_COORD(counter, 0);
                
                _container.push(handlingMenu);
            }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
            //stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUpHandler);
        }
        
        private var handler:Function;
        private var isFinalGroupCalled:Boolean;
        
        /**
         *
         * @param    bubbleBottom
         */
        private function bubble(bubbleBottom:Boolean = false):void {
            
            var counter:int = 0;
            var tweens:Array = [];
            var handlingMenu:Menu;
            var beforeHandler:Function = handler;
            var isPlaying:Boolean = group.isPlaying;
            group.stop();
            if (isPlaying) beforeHandler.call(null);
            
            if (bubbleBottom) {
                if (_startIndex == 0) _startIndex = (contents.length - 1);
                else _startIndex--;
                
                handlingMenu = this.addChild(contents[_startIndex]) as Menu;
                handlingMenu.x = Menu.MENU_START_POINT.x;
                handlingMenu.y = Menu.Y_COORD(counter, -1);
                
                _container.unshift(handlingMenu);
                
                for (counter = 0; counter <= Menu.MENU_ROWS; counter++ ) {
                    tweens.push(BetweenAS3.tween(_container[counter], { y : Menu.MENU_START_POINT.y + Menu.MENU_MARGIN_Y_INACTIVE * (counter) + (((counter) > Menu.MENU_ACTIVE_INDEX) ? 2 : 1) * (((counter) >= Menu.MENU_ACTIVE_INDEX) ? Menu.MENU_SUBTRACT_MARGIN_Y_ACTIVE : 0) }, null, Menu.TWEEN_TIME));
                    
                    handlingMenu = _container[counter] as Menu
                }
                
                handler = onTweenBubbleBottomCompletedHandler;
            }
            
            else {
                var index:int = _startIndex;
                
                while (counter < Menu.MENU_ROWS) {
                    counter++, index ++;
                    if (contents.length == index) index = 0;
                }
                
                if (_startIndex == (contents.length - 1)) _startIndex = 0;
                else _startIndex++;
                
                
                handlingMenu = this.addChild(contents[index]) as Menu;
                handlingMenu.x = Menu.MENU_START_POINT.x;
                handlingMenu.y = Menu.Y_COORD(counter, +1);
                _container.push(contents[index]);
                
                var slide:int = -1;
                
                counter = 0;
                for each(var menu:Menu in _container) {
                    tweens.push(BetweenAS3.tween(menu, { y : Menu.MENU_START_POINT.y + Menu.MENU_MARGIN_Y_INACTIVE * (counter+slide) + (((counter+slide) > Menu.MENU_ACTIVE_INDEX) ? 2 : 1) * (((counter+slide) >= Menu.MENU_ACTIVE_INDEX) ? Menu.MENU_SUBTRACT_MARGIN_Y_ACTIVE : 0) }, null, Menu.TWEEN_TIME));
                    counter++;
                }
                
                handler =  onTweenBubbleTopCompletedHandler;
            }
            
            group = BetweenAS3.parallelTweens(tweens);
            group.addEventListener(TweenEvent.COMPLETE, handler);
            group.play();
        }
        
        /**
         *
         * @param    e
         */
        private function onTweenBubbleBottomCompletedHandler(e:TweenEvent = null):void {
            var handlingMenu:Menu = _container.pop();
            this.removeChild(handlingMenu);
        }
        
        /**
         *
         * @param    e
         */
        private function onTweenBubbleTopCompletedHandler(e:TweenEvent = null):void {
            var handlingMenu:Menu = _container.shift();
            this.removeChild(handlingMenu);
        }
        
        /**
         *
         * @param    e
         */
        private function onKeyDownHandler(e:KeyboardEvent):void {
            switch(e.keyCode) {
                case Keyboard.UP :
                    this.bubble(false);
                break;
                case Keyboard.DOWN :
                    this.bubble(true);
                break;
            }
        }
        
        /* Method
        // /////////////////////////////////////////////////////// */
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.MovieClip;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;


class Menu extends Sprite {
    
    public function Menu(color:uint, string:String) {
        this.graphics.beginFill(color);
        this.graphics.lineStyle(1, 0xFF0000);
        this.graphics.drawRect(0, 0, 100, 20);
        this.graphics.endFill();
        
        var textField:TextField = new TextField();
        textField.text = string;
        textField.autoSize = TextFieldAutoSize.LEFT;
        textField.selectable = false;
        textField.textColor = 0xFFFFFF;
        textField.x = this.width * .5 - textField.width * .5;
        textField.y = this.height * .5 - textField.height * .5;
        this.addChild(textField);
    }
    
    public static function Y_COORD(counter:int, slide:int = 0):Number {
        return Menu.MENU_START_POINT.y + Menu.MENU_MARGIN_Y_INACTIVE * (counter + slide) + (((counter + slide) > Menu.MENU_ACTIVE_INDEX) ? 2 : 1) * (((counter + slide) >= Menu.MENU_ACTIVE_INDEX) ? Menu.MENU_SUBTRACT_MARGIN_Y_ACTIVE : 0)
    }
    
    public static const MENU_ROWS:int = 7;
    
    /** start Zero */
    public static const MENU_ACTIVE_INDEX:int = 3;
    public static const MENU_START_POINT:Point = new Point(300.0, 26.0);
    public static const MENU_ACTIVE_POINT:Point = new Point(300.0, 26.0);
    
    public static const MENU_SUBTRACT_MARGIN_Y_ACTIVE:Number = 10;
    public static const MENU_MARGIN_Y_INACTIVE:Number = 60;
    
    public static const SELECTED_MODE_NAME_POINT:Point = new Point(15, 155);
    
    public static const TWEEN_TIME:Number = 0.06;
    
    private static const MENU_PADDING_TOP:Number = 15;
    
}
