/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yYI6
 */

// forked from djankey's forked from: flash on 2013-9-2
// forked from J.J's flash on 2013-9-2
package  {
    import flash.filters.BlurFilter;
    import flash.display.BlendMode;
    import flash.geom.Vector3D;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.display.Shape;    
    import net.hires.debug.Stats;

    public class Test extends Sprite {
        private var ps : PSystem;
        private var bg:Shape;
        private var over:Boolean = false;
        
        public function Test() {
            stage.frameRate=60;            
            
            bg = new Shape();
            bg.graphics.beginFill(0x000000);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            addChild(bg);
            
            ps = new PSystem(this, 30);         
            
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeave);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            //addChild(new Stats());
        }

        private function loop(event : Event) : void {   
            if(over) {         
                ps.repelLoc.x=mouseX;
                ps.repelLoc.y=mouseY;   
                ps.render(5);             
            } else {
                ps.repelLoc.x=ps.repelLoc.y= 2147483647;    
                ps.render(8);                          
            }             
        }
        
        private function onMouseLeave(event:Event):void
        {            
            over = false; 
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove); 
        }
        
        private function onMouseMove(event:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            over = true; 
        }
    }

}

//-------------- PARTICLES --------------------------------------------------------
import flash.display.DisplayObjectContainer;
import flash.geom.Vector3D;

class PSystem{
    public var repelLoc:Vector3D=new Vector3D();
    public var particles:Vector.<Particle>;
    private var NUM:int;
    private var container:DisplayObjectContainer;
    private var len:int;

    public function PSystem (con:DisplayObjectContainer,_num:int):void{
        particles=new Vector.<Particle>()
        NUM=_num;
        container=con;
        var s:Number=456/NUM;
    
        for (var i : int = 1; i < 2; i++) {
            for (var j : int = 1; j < NUM; j++) {
               var p:Particle=new Particle(200 + i*s, j*s, (i*j)/(NUM*NUM), s/2-1);             
               container.addChild(p);
               particles.push(p);
            }
        }
        
        len=particles.length;
    }

    public function render(max:int = 5):void{
        for (var i : int = 0; i < len; i++) {
            var p:Particle=particles[i];
            p.applyForce(p.spring());
            p.applyForce(p.repell(repelLoc));
            p.applyForce(p.damping());
            p.render(max);
        }
    }
}



import flash.geom.Vector3D;
import flash.display.Shape;

class Particle extends Shape {
    private const K:Number = 0.15;
    private const G:Number = 60000;
    public var loc:Vector3D,acc:Vector3D,vel:Vector3D,anchor:Vector3D;
    public var spLen:Number = 0;
    public var mass:Number = 10;
    

    public function Particle(_x:Number,_y:Number,_r:Number, _w:Number = 5):void{
        var _c:uint = Math.round(_r * 0xFFFFFF);
        loc=new Vector3D(_x,_y);
        anchor=loc.clone();
        acc=new  Vector3D();
        vel=new Vector3D();
        this.x=_x,this.y=_y;
        with(this.graphics) {
            beginFill(_c);
            drawCircle(0, 0, _w);
            endFill();
        }        
    }

    public function applyForce(v:Vector3D):void{
        var f:Vector3D=v.clone();
        f.scaleBy(1/mass);
        acc=acc.add(f);
    }

    public function render(max:int):void{
        vel=vel.add(acc);
        vel=limit(vel, max);
        loc=loc.add(vel);
        acc.scaleBy(0);
        //set location
        this.x=loc.x;
        this.y=loc.y;
    }

    public function spring():Vector3D{
        var f:Vector3D=loc.subtract(anchor);
        var d:Number=f.length;
        var X:Number=d-spLen;
        f.normalize();
        f.scaleBy(-1*K*X);
        return f;
    }

    private function limit(v:Vector3D,lim:Number):Vector3D{
         if(v.length>lim) v.normalize() , v.scaleBy(lim);
         return v;
    }

    public function damping():Vector3D{
        var f:Vector3D=vel.clone();
        f.scaleBy(-1);
        f.normalize();
        f.scaleBy(1);
        return f;
    }

    public function repell(repelLoc:Vector3D):Vector3D{
        var f:Vector3D=repelLoc.subtract(loc);
        var r:Number=f.length;
        f.normalize();
        var fs:Number=-1*G/(r*r);
        f.scaleBy(fs);
        return f;
    }
}