/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yYBd
 */

/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yYBd
 */

package 
{
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.BitmapData;
    import flash.display.Bitmap;    
    import flash.display.Loader;
    import flash.geom.Matrix;
    import flash.ui.Mouse;    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest; 
    import flash.net.URLLoader;
    import flash.display.LoaderInfo;
    import flash.system.Security;    
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageDisplayState;
    import com.bit101.components.PushButton;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author djankey
     */
    public class Main extends Sprite 
    {
        private var pattern_url         :String        = "http://farm2.static.flickr.com/1197/5116216816_39957c273e.jpg";
        private var patternMatrix       :Matrix        = new Matrix(); 
        private var patternSprite       :Sprite        = new Sprite();
        private var cursor              :Shape         = new Shape();
        private var _patternBitmapData  :BitmapData;
        private var fbtn                :PushButton;
    
        private var stage_w             :int;        
        private var stage_h             :int;        
        private var speed_x             :Number  = 1;
        private var speed_y             :Number  = 1;
        private var max_speed           :Number  = 16;
        private var retard              :Number  = 0.95;
        
        private var tweening            :Boolean = false;
        private var new_x                :Number  = 0;
        private var old_x                :Number  = 0;
        private var new_y                :Number  = 0;
        private var old_y                :Number  = 0;
        private var throwing            :Boolean = false;        
        private var x_speed        :Number  = 0;
        private var y_speed        :Number  = 0;        
        private var max_t               :Number  = 10000;
        private var pattern_tx          :Number;
        private var pattern_ty          :Number;
        
        //________________________________________________________
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        //________________________________________________________ init
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
                        
            stage.scaleMode     = StageScaleMode.NO_SCALE;
            stage.align         = StageAlign.TOP_LEFT;
            stage.frameRate     = 60;
                                    
            Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
                                    
            var loader : Loader = new Loader(); 
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);  
            loader.load(new URLRequest(pattern_url));
        }
        
        //________________________________________________________ Image loading complete
        private function loadComplete(e:Event):void
        {
            _patternBitmapData = e.target.content.bitmapData;
          
            pattern_tx    = Math.ceil(max_t/_patternBitmapData.width) * _patternBitmapData.width;
            pattern_ty    = Math.ceil(max_t/_patternBitmapData.height) * _patternBitmapData.height;
            
            addChild(patternSprite);                                
            addChild(new Stats());    
            
            cursor.graphics.beginFill(0xfffffff, 0.8);
            cursor.graphics.drawCircle(0, 0, 10);
            cursor.graphics.endFill();
            cursor.visible = false;
            addChild(cursor);
            
            fbtn     = new PushButton(this, 0, 5, "Fullscreen");
            fbtn.x     = stage_w - fbtn.width - 5;
            fbtn.addEventListener(MouseEvent.MOUSE_UP, toggleFullscreen);
            addChild(fbtn);
                        
            stage.addEventListener(Event.ENTER_FRAME, draw);        
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mousePosition);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseIsDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, tween);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            
            resizeHandler();
        }
        
        //________________________________________________________ Toggle fullscreen
        private function toggleFullscreen(event:MouseEvent):void
        {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState=StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState=StageDisplayState.NORMAL;
            }
        }
        
        //________________________________________________________ Resize
        private function resizeHandler(event:Event = null):void
        {
            stage_w = stage.stageWidth;
            stage_h = stage.stageHeight;
            
            fbtn.x = stage_w - fbtn.width - 5;           
        }
        
        //________________________________________________________ Mouse down
        private function mouseIsDown(event:MouseEvent):void
        {
            old_x         = mouseX;
            old_y         = mouseY;
            throwing     = true;
            tweening     = false;    
            
            Mouse.hide();
            cursor.visible = true;
        }
                    
        //________________________________________________________ Tween!
        private function tween(event:MouseEvent):void
        {
            cursor.visible = false;
            Mouse.show();
            
            x_speed = mouseX - old_x;
            y_speed = mouseY - old_y;
            
            throwing = false;
            tweening = true;
        }
                                
        //________________________________________________________ Mouse position
        private function mousePosition(e:MouseEvent):void
        {
            speed_x = -((stage.mouseX - stage_w * 0.5) / stage_w * 0.5) * max_speed;
            speed_y = -((stage.mouseY - stage_h * 0.5) / stage_h * 0.5) * max_speed;
            
            cursor.x = stage.mouseX;
            cursor.y = stage.mouseY;
        }
        
        //_______________________________________________________ draw
        private function draw(e:Event):void
        {
            if(throwing==false) {
                if (tweening == false) {
                    patternMatrix.tx += speed_x;
                    patternMatrix.ty += speed_y;
                } else {
                    x_speed *= retard;
                    y_speed *= retard;
                    if(x_speed>-0.1 && x_speed<0.1 && y_speed>-0.1 && y_speed<0.1) tweening = false;
                    patternMatrix.tx += x_speed;
                    patternMatrix.ty += y_speed;
                }
            } else {
                new_x = mouseX;
                new_y = mouseY;
                patternMatrix.tx += (new_x - old_x);
                patternMatrix.ty += (new_y - old_y);
                old_x = new_x;
                old_y = new_y;
            }        
            
            if(patternMatrix.tx< -max_t) patternMatrix.tx         += pattern_tx;
            else if(patternMatrix.tx> max_t) patternMatrix.tx     -= pattern_tx;
            
            if(patternMatrix.ty< -max_t) patternMatrix.ty         += pattern_ty;
            else if(patternMatrix.ty> max_t) patternMatrix.ty     -= pattern_ty;
            
            patternSprite.graphics.clear();
            patternSprite.graphics.beginBitmapFill(_patternBitmapData, patternMatrix, true, false);
            patternSprite.graphics.drawRect(0, 0, stage_w, stage_h);
            patternSprite.graphics.endFill();
        }    
    }    
}