/**
 * Copyright beryu ( http://wonderfl.net/user/beryu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yXdI
 */

/**
 * webcam映像をRGB3色に着色して震えさせる
 * 
 * ※ホントは着色ではなくて色の抽出がしたいんだけど、
 *  その方法をまだ知らない。
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;
    
    public class VibratingCam extends Sprite {
        // 震えの許容値
        private const LATITUDE:Number = 10;
        
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmp:Bitmap;
        private var _bmpDataSrc:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataDst:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataR:BitmapData;
        private var _bmpDataG:BitmapData;
        private var _bmpDataB:BitmapData;
        private var _cmfR:ColorMatrixFilter;
        private var _cmfG:ColorMatrixFilter;
        private var _cmfB:ColorMatrixFilter;
        
        public function VibratingCam()
        {
            // ビデオ準備
            _cam = Camera.getCamera();
            _cam.setMode(stage.stageWidth, stage.stageHeight, 15);
            _vid = new Video(stage.stageWidth, stage.stageHeight);
            _vid.attachCamera(_cam);
            
            // エフェクト準備
            _cmfR = new ColorMatrixFilter([
                5, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, 0.4, 0
            ]);
            _cmfG= new ColorMatrixFilter([
                1, 0, 0, 0, 0,
                0, 5, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, 0.35, 0
            ]);
            _cmfB= new ColorMatrixFilter([
                1, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 5, 0, 0,
                0, 0, 0, 0.3, 0
            ]);
            
            // 表示用Bitmapに出力用bitmapを関連づける
            _bmp = new Bitmap(_bmpDataDst);
            
            // stageにadd
            addChild(_bmp);
            
            // イベント
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            _bmpDataSrc.draw(_vid);
            _bmpDataR = _bmpDataSrc.clone();
            _bmpDataG = _bmpDataSrc.clone();
            _bmpDataB = _bmpDataSrc.clone();
            _bmpDataR.applyFilter(_bmpDataSrc, _bmpDataSrc.rect, new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE), _cmfR);
            _bmpDataG.applyFilter(_bmpDataSrc, _bmpDataSrc.rect, new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE), _cmfG);
            _bmpDataB.applyFilter(_bmpDataSrc, _bmpDataSrc.rect, new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE), _cmfB);
            _bmpDataDst.draw(_bmpDataR);
            _bmpDataDst.draw(_bmpDataG);
            _bmpDataDst.draw(_bmpDataB);
        }
    }
}