/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yXX0
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        public var _buffer :Buffer;
        
        public function Main()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _buffer = new Buffer();

            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(_buffer);
            
            init();
        }
        
        public function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1);
            graphics.drawRect(0, 0, stage.stageWidth-1, stage.stageHeight-1);    
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Constants
{
}

class Buffer extends Sprite
{
    private var _gridContainer :GridContainer;
    
    public function Buffer()
    {
        _gridContainer = new GridContainer(15, 20);
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(_gridContainer);
        
        init();
    }
    
    public function init() :void
    {
        
    }
}

class GridContainer extends Sprite
{
    protected var _nodeSize :int;
    protected var _nodeScale :int;  
    protected var _nodeMargin :int;
    
    private var _node :GridNode;
    
    public function GridContainer($nodeSize:int, $nodeScale:int)
    {
        _nodeSize = $nodeSize;
        _nodeScale = $nodeScale;
        _nodeMargin = 5;
        
        for (var $x:int = 0; $x<_nodeScale; $x++)
        {
            for (var $y:int = 0; $y<_nodeScale; $y++)
            {
                _node = new GridNode($x*_nodeScale+_nodeMargin, $y*_nodeScale+_nodeMargin, _nodeSize, _nodeSize);
                
                addChild(_node);
            }
        }
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();    
    }
    
    public function init() :void
    {
    
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        
    }

}

class GridNode extends Sprite
{
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    
    public function GridNode($x:int, $y:int, $width:int, $height:int)
    {
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {    
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0xCCCCCC);
        graphics.drawRect(_x, _y, _width, _height);
        graphics.endFill();
    }
}