/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yXLj
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"id":0,"col":16777010,"fx":121,"time":2033,"fy":197,"type":"draw","childlist":[{"time":2253,"x":120,"y":199},{"time":2274,"x":120,"y":200},{"time":2296,"x":119,"y":201},{"time":2316,"x":119,"y":202},{"time":2357,"x":119,"y":203},{"time":2379,"x":118,"y":204},{"time":2400,"x":118,"y":205},{"time":2440,"x":118,"y":207},{"time":2461,"x":117,"y":207},{"time":2481,"x":117,"y":208},{"time":2521,"x":117,"y":209},{"time":2562,"x":116,"y":210},{"time":2583,"x":116,"y":211},{"time":2625,"x":116,"y":212},{"time":2688,"x":116,"y":213},{"time":2709,"x":116,"y":214},{"time":2749,"x":116,"y":215},{"time":2790,"x":116,"y":216},{"time":2852,"x":115,"y":217},{"time":2934,"x":115,"y":218},{"time":2995,"x":115,"y":219},{"time":3035,"x":115,"y":220},{"time":3076,"x":115,"y":221},{"time":3118,"x":115,"y":222},{"time":3138,"x":115,"y":223},{"time":3180,"x":115,"y":224},{"time":3221,"x":115,"y":225},{"time":3241,"x":115,"y":226},{"time":3283,"x":115,"y":227},{"time":3304,"x":115,"y":228},{"time":3324,"x":115,"y":229},{"time":3348,"x":116,"y":230},{"time":3368,"x":116,"y":231},{"time":3389,"x":116,"y":232},{"time":3450,"x":116,"y":233},{"time":3470,"x":116,"y":234},{"time":3490,"x":117,"y":235},{"time":3532,"x":117,"y":236},{"time":3573,"x":117,"y":237},{"time":3614,"x":117,"y":238},{"time":3634,"x":118,"y":239},{"time":3655,"x":118,"y":240},{"time":3675,"x":118,"y":241},{"time":3716,"x":119,"y":242},{"time":3758,"x":119,"y":243},{"time":3780,"x":119,"y":244},{"time":3800,"x":120,"y":245},{"time":3841,"x":120,"y":246},{"time":3883,"x":120,"y":247},{"time":3924,"x":121,"y":247},{"time":3944,"x":121,"y":248},{"time":4006,"x":121,"y":249},{"time":4026,"x":122,"y":249},{"time":4049,"x":122,"y":250},{"time":4090,"x":122,"y":251},{"time":4111,"x":123,"y":251},{"time":4194,"x":123,"y":252},{"time":4215,"x":124,"y":252},{"time":4235,"x":124,"y":253},{"time":4297,"x":125,"y":254},{"time":4338,"x":125,"y":255},{"time":4359,"x":126,"y":255},{"time":4381,"x":126,"y":256},{"time":4401,"x":127,"y":256},{"time":4422,"x":127,"y":257},{"time":4484,"x":128,"y":257},{"time":4525,"x":128,"y":258},{"time":4547,"x":129,"y":258},{"time":4568,"x":129,"y":259},{"time":4588,"x":130,"y":259},{"time":4629,"x":131,"y":259},{"time":4650,"x":131,"y":260},{"time":4691,"x":132,"y":260},{"time":4715,"x":133,"y":261},{"time":4756,"x":134,"y":261},{"time":4795,"x":134,"y":262},{"time":4837,"x":135,"y":262},{"time":4857,"x":136,"y":262},{"time":4876,"x":137,"y":263},{"time":4897,"x":138,"y":263},{"time":4918,"x":138,"y":264},{"time":4939,"x":139,"y":264},{"time":4981,"x":140,"y":264},{"time":5000,"x":140,"y":265},{"time":5082,"x":141,"y":265},{"time":5144,"x":142,"y":265},{"time":5185,"x":143,"y":265},{"time":5225,"x":143,"y":266},{"time":5247,"x":144,"y":266},{"time":5267,"x":145,"y":266},{"time":5309,"x":146,"y":266},{"time":5350,"x":147,"y":266},{"time":5371,"x":148,"y":267},{"time":5414,"x":149,"y":267},{"time":5455,"x":150,"y":267},{"time":5496,"x":151,"y":267},{"time":5518,"x":151,"y":268},{"time":5539,"x":152,"y":268},{"time":5559,"x":153,"y":268},{"time":5600,"x":154,"y":268},{"time":5640,"x":155,"y":268},{"time":5681,"x":156,"y":269},{"time":5702,"x":157,"y":269},{"time":5743,"x":158,"y":269},{"time":5783,"x":159,"y":269},{"time":5804,"x":160,"y":269},{"time":5849,"x":161,"y":269},{"time":5869,"x":162,"y":269},{"time":5910,"x":163,"y":269},{"time":5930,"x":164,"y":269},{"time":5951,"x":164,"y":270},{"time":5991,"x":165,"y":270},{"time":6053,"x":166,"y":270},{"time":6074,"x":167,"y":270},{"time":6094,"x":168,"y":270},{"time":6116,"x":169,"y":270},{"time":6157,"x":170,"y":270},{"time":6198,"x":171,"y":270},{"time":6219,"x":172,"y":270},{"time":6239,"x":173,"y":270},{"time":6260,"x":174,"y":270},{"time":6300,"x":175,"y":270},{"time":6321,"x":176,"y":270},{"time":6362,"x":178,"y":270},{"time":6383,"x":179,"y":269},{"time":6404,"x":180,"y":269},{"time":6425,"x":181,"y":269},{"time":6489,"x":182,"y":269},{"time":6509,"x":183,"y":269},{"time":6530,"x":184,"y":269},{"time":6571,"x":185,"y":269},{"time":6614,"x":186,"y":268},{"time":6675,"x":187,"y":268},{"time":6756,"x":188,"y":268},{"time":6819,"x":189,"y":268},{"time":6860,"x":190,"y":268},{"time":6880,"x":191,"y":267},{"time":6900,"x":192,"y":267},{"time":6942,"x":193,"y":267},{"time":6982,"x":194,"y":267},{"time":7003,"x":195,"y":267},{"time":7065,"x":196,"y":267},{"time":7126,"x":197,"y":267},{"time":7169,"x":198,"y":267},{"time":7210,"x":199,"y":267},{"time":7231,"x":200,"y":267},{"time":7252,"x":200,"y":266},{"time":7273,"x":201,"y":266},{"time":7293,"x":202,"y":266},{"time":7334,"x":203,"y":266},{"time":7355,"x":204,"y":266},{"time":7375,"x":205,"y":266},{"time":7395,"x":206,"y":265},{"time":7436,"x":207,"y":265},{"time":7456,"x":208,"y":265},{"time":7476,"x":209,"y":265},{"time":7497,"x":210,"y":265},{"time":7538,"x":211,"y":265},{"time":7559,"x":211,"y":264},{"time":7581,"x":212,"y":264},{"time":7602,"x":213,"y":264},{"time":7622,"x":214,"y":263},{"time":7643,"x":216,"y":263},{"time":7665,"x":217,"y":262},{"time":7706,"x":218,"y":262},{"time":7726,"x":219,"y":262},{"time":7768,"x":220,"y":261},{"time":7809,"x":221,"y":261},{"time":7854,"x":222,"y":260},{"time":7915,"x":223,"y":260},{"time":7976,"x":224,"y":259},{"time":8019,"x":225,"y":259},{"time":8039,"x":226,"y":258},{"time":8060,"x":227,"y":258},{"time":8082,"x":228,"y":258},{"time":8102,"x":229,"y":257},{"time":8122,"x":230,"y":257},{"time":8143,"x":231,"y":256},{"time":8165,"x":232,"y":256},{"time":8185,"x":232,"y":255},{"time":8205,"x":234,"y":255},{"time":8226,"x":235,"y":254},{"time":8249,"x":237,"y":253},{"time":8269,"x":238,"y":252},{"time":8290,"x":239,"y":252},{"time":8336,"x":240,"y":252},{"time":8356,"x":240,"y":251},{"time":8377,"x":241,"y":251},{"time":8460,"x":242,"y":251},{"time":8501,"x":242,"y":250},{"time":8521,"x":243,"y":250},{"time":8542,"x":244,"y":250},{"time":8563,"x":244,"y":249},{"time":8608,"x":245,"y":249},{"time":8648,"x":246,"y":249},{"time":8668,"x":247,"y":248},{"time":8709,"x":249,"y":248},{"time":8729,"x":250,"y":247},{"time":8750,"x":251,"y":246},{"time":8770,"x":252,"y":246},{"time":8791,"x":253,"y":245},{"time":8811,"x":254,"y":245},{"time":8833,"x":254,"y":244},{"time":8854,"x":255,"y":244},{"time":8896,"x":256,"y":244},{"time":8917,"x":257,"y":243},{"time":8958,"x":258,"y":242},{"time":9000,"x":259,"y":242},{"time":9061,"x":260,"y":241},{"time":9102,"x":261,"y":241},{"time":9142,"x":262,"y":240},{"time":9183,"x":263,"y":240},{"time":9204,"x":264,"y":239},{"time":9224,"x":265,"y":238},{"time":9244,"x":266,"y":238},{"time":9266,"x":266,"y":237},{"time":9286,"x":267,"y":237},{"time":9307,"x":268,"y":236},{"time":9327,"x":269,"y":236},{"time":9348,"x":270,"y":235},{"time":9409,"x":271,"y":234},{"time":9429,"x":272,"y":234},{"time":9490,"x":273,"y":233},{"time":9533,"x":274,"y":233},{"time":9574,"x":275,"y":232},{"time":9637,"x":276,"y":232},{"time":9657,"x":276,"y":231},{"time":9680,"x":277,"y":230},{"time":9701,"x":278,"y":230},{"time":9721,"x":279,"y":229},{"time":9761,"x":280,"y":229},{"time":9783,"x":281,"y":228},{"time":9843,"x":282,"y":227},{"time":9885,"x":283,"y":227},{"time":9949,"x":284,"y":226},{"time":10029,"x":285,"y":225},{"time":10070,"x":286,"y":225},{"time":10091,"x":286,"y":224},{"time":10114,"x":287,"y":224},{"time":10135,"x":287,"y":223},{"time":10155,"x":288,"y":223},{"time":10197,"x":289,"y":223},{"time":10218,"x":289,"y":222},{"time":10259,"x":290,"y":222},{"time":10283,"x":291,"y":221},{"time":10323,"x":292,"y":220},{"time":10365,"x":293,"y":220},{"time":10386,"x":293,"y":219},{"time":10406,"x":294,"y":219},{"time":10449,"x":295,"y":218},{"time":10510,"x":296,"y":217},{"time":10532,"x":297,"y":217},{"time":10573,"x":298,"y":217},{"time":10593,"x":298,"y":216},{"time":10641,"x":299,"y":215},{"time":10682,"x":300,"y":215},{"time":10702,"x":300,"y":214},{"time":10766,"x":301,"y":213},{"time":10807,"x":302,"y":212},{"time":10849,"x":302,"y":211},{"time":10869,"x":303,"y":211},{"time":10890,"x":303,"y":210},{"time":10912,"x":304,"y":210},{"time":10953,"x":304,"y":209},{"time":10974,"x":305,"y":209},{"time":11017,"x":305,"y":208},{"time":11058,"x":306,"y":208},{"time":11080,"x":306,"y":207},{"time":11100,"x":307,"y":206},{"time":11139,"x":308,"y":206},{"time":11158,"x":308,"y":205},{"time":11201,"x":309,"y":205},{"time":11221,"x":309,"y":204},{"time":11283,"x":310,"y":203},{"time":11344,"x":311,"y":202},{"time":11407,"x":311,"y":201},{"time":11427,"x":312,"y":201},{"time":11468,"x":312,"y":200},{"time":11509,"x":313,"y":200},{"time":11552,"x":313,"y":199},{"time":11573,"x":314,"y":199},{"time":11616,"x":314,"y":198},{"time":11681,"x":315,"y":198},{"time":11701,"x":315,"y":197},{"time":11803,"x":316,"y":196},{"time":11868,"x":317,"y":195},{"time":11929,"x":317,"y":194},{"time":11951,"x":318,"y":194},{"time":12014,"x":318,"y":193},{"time":12035,"x":319,"y":193},{"time":12076,"x":319,"y":192},{"time":12097,"x":320,"y":192},{"time":12138,"x":320,"y":191},{"time":12180,"x":321,"y":191},{"time":12200,"x":321,"y":190},{"time":12262,"x":322,"y":190},{"time":12282,"x":322,"y":189},{"time":12303,"x":323,"y":189},{"time":12324,"x":323,"y":188},{"time":12390,"x":324,"y":187},{"time":12452,"x":324,"y":186},{"time":12472,"x":325,"y":186},{"time":12515,"x":325,"y":185},{"time":12556,"x":326,"y":185},{"time":12576,"x":326,"y":184},{"time":12658,"x":326,"y":183},{"time":12683,"x":327,"y":183},{"time":12702,"x":327,"y":182},{"time":12801,"x":328,"y":181},{"time":12903,"x":328,"y":180},{"time":12923,"x":329,"y":180},{"time":12984,"x":329,"y":179},{"time":13005,"x":330,"y":179},{"time":13049,"x":330,"y":178},{"time":13070,"x":331,"y":178},{"time":13154,"x":332,"y":178},{"time":13174,"x":332,"y":177},{"time":13235,"x":333,"y":177},{"time":13382,"x":334,"y":177},{"time":13525,"x":335,"y":178},{"time":13588,"x":335,"y":179},{"time":13650,"x":336,"y":180},{"time":13714,"x":336,"y":181},{"time":13735,"x":336,"y":182},{"time":13781,"x":336,"y":183},{"time":13801,"x":336,"y":184},{"time":13841,"x":336,"y":185},{"time":13882,"x":336,"y":186},{"time":13903,"x":336,"y":187},{"time":13944,"x":335,"y":188},{"time":13966,"x":335,"y":189},{"time":14027,"x":335,"y":190},{"time":14049,"x":335,"y":191},{"time":14091,"x":334,"y":192},{"time":14132,"x":334,"y":193},{"time":14173,"x":334,"y":194},{"time":14214,"x":333,"y":194},{"time":14235,"x":333,"y":195},{"time":14275,"x":333,"y":196},{"time":14316,"x":333,"y":197},{"time":14337,"x":332,"y":197},{"time":14358,"x":332,"y":198},{"time":14383,"x":332,"y":199},{"time":14404,"x":331,"y":200},{"time":14424,"x":331,"y":201},{"time":14449,"x":330,"y":202},{"time":14470,"x":330,"y":203},{"time":14491,"x":330,"y":204},{"time":14512,"x":329,"y":204},{"time":14534,"x":329,"y":205},{"time":14555,"x":329,"y":206},{"time":14596,"x":328,"y":207},{"time":14615,"x":328,"y":208},{"time":14635,"x":327,"y":209},{"time":14675,"x":327,"y":210},{"time":14696,"x":327,"y":211},{"time":14722,"x":326,"y":212},{"time":14742,"x":325,"y":213},{"time":14802,"x":325,"y":214},{"time":14822,"x":324,"y":214},{"time":14843,"x":324,"y":215},{"time":14885,"x":324,"y":216},{"time":14906,"x":323,"y":216},{"time":14926,"x":323,"y":217},{"time":14969,"x":323,"y":218},{"time":14989,"x":322,"y":218},{"time":15010,"x":322,"y":219},{"time":15032,"x":322,"y":220},{"time":15053,"x":321,"y":220},{"time":15073,"x":321,"y":221},{"time":15094,"x":320,"y":222},{"time":15118,"x":320,"y":224},{"time":15139,"x":319,"y":225},{"time":15202,"x":318,"y":226},{"time":15222,"x":318,"y":227},{"time":15264,"x":318,"y":228},{"time":15285,"x":317,"y":228},{"time":15326,"x":317,"y":229},{"time":15349,"x":317,"y":230},{"time":15368,"x":316,"y":230},{"time":15388,"x":316,"y":231},{"time":15450,"x":315,"y":232},{"time":15489,"x":315,"y":233},{"time":15530,"x":314,"y":233},{"time":15551,"x":314,"y":234},{"time":15571,"x":314,"y":235},{"time":15615,"x":313,"y":236},{"time":15698,"x":313,"y":237},{"time":15759,"x":313,"y":238},{"time":15823,"x":312,"y":238},{"time":15844,"x":312,"y":239},{"time":15865,"x":312,"y":240},{"time":15906,"x":312,"y":241},{"time":15948,"x":311,"y":242},{"time":15989,"x":311,"y":243},{"time":16052,"x":310,"y":244},{"time":16073,"x":310,"y":245},{"time":16138,"x":309,"y":246},{"time":16182,"x":309,"y":247},{"time":16223,"x":308,"y":248},{"time":16286,"x":308,"y":249},{"time":16306,"x":307,"y":250},{"time":16368,"x":307,"y":251},{"time":16389,"x":306,"y":252},{"time":16450,"x":306,"y":253},{"time":16471,"x":305,"y":253},{"time":16491,"x":305,"y":254},{"time":16537,"x":305,"y":255},{"time":16558,"x":304,"y":255},{"time":16581,"x":304,"y":256},{"time":16642,"x":303,"y":257},{"time":16683,"x":302,"y":258},{"time":16703,"x":302,"y":259},{"time":16849,"x":301,"y":260},{"time":16890,"x":301,"y":261},{"time":16933,"x":300,"y":262},{"time":16974,"x":299,"y":263},{"time":16994,"x":298,"y":264},{"time":17035,"x":298,"y":265},{"time":17055,"x":297,"y":265},{"time":17075,"x":297,"y":266},{"time":17141,"x":296,"y":267},{"time":17203,"x":295,"y":268},{"time":17244,"x":295,"y":269},{"time":17267,"x":294,"y":269},{"time":17288,"x":294,"y":270},{"time":17309,"x":293,"y":271},{"time":17390,"x":292,"y":272},{"time":17472,"x":292,"y":273},{"time":17493,"x":291,"y":273},{"time":17539,"x":291,"y":274},{"time":17560,"x":290,"y":274},{"time":17580,"x":290,"y":275},{"time":17661,"x":289,"y":276},{"time":17702,"x":288,"y":277},{"time":17743,"x":288,"y":278},{"time":17764,"x":287,"y":278},{"time":17784,"x":287,"y":279},{"time":17848,"x":286,"y":279},{"time":17869,"x":286,"y":280},{"time":17889,"x":285,"y":280},{"time":17909,"x":285,"y":281},{"time":17950,"x":284,"y":281},{"time":17991,"x":284,"y":282},{"time":18055,"x":283,"y":282},{"time":18075,"x":283,"y":283},{"time":18136,"x":282,"y":284},{"time":18218,"x":281,"y":285},{"time":18238,"x":280,"y":286},{"time":18301,"x":279,"y":287},{"time":18362,"x":278,"y":288},{"time":18422,"x":277,"y":289},{"time":18483,"x":277,"y":290},{"time":18503,"x":276,"y":290},{"time":18544,"x":275,"y":291},{"time":18585,"x":274,"y":292},{"time":18648,"x":274,"y":293},{"time":18668,"x":273,"y":293},{"time":18708,"x":273,"y":294},{"time":18729,"x":272,"y":294},{"time":18771,"x":272,"y":295},{"time":18792,"x":271,"y":295},{"time":18834,"x":270,"y":296},{"time":18855,"x":269,"y":297},{"time":18936,"x":268,"y":298},{"time":18956,"x":267,"y":298},{"time":18977,"x":266,"y":299},{"time":18998,"x":266,"y":300},{"time":19019,"x":265,"y":300},{"time":19060,"x":265,"y":301},{"time":19101,"x":264,"y":301},{"time":19142,"x":264,"y":302},{"time":19162,"x":263,"y":302},{"time":19204,"x":262,"y":303},{"time":19248,"x":261,"y":304},{"time":19269,"x":260,"y":304},{"time":19290,"x":259,"y":305},{"time":19311,"x":258,"y":305},{"time":19373,"x":257,"y":305},{"time":19394,"x":257,"y":306},{"time":19414,"x":256,"y":306},{"time":19434,"x":255,"y":307},{"time":19517,"x":254,"y":307},{"time":19538,"x":254,"y":308},{"time":19582,"x":253,"y":308},{"time":19623,"x":252,"y":309},{"time":19686,"x":251,"y":309},{"time":19707,"x":251,"y":310},{"time":19747,"x":250,"y":310},{"time":19789,"x":250,"y":311},{"time":19809,"x":249,"y":311},{"time":19850,"x":248,"y":312},{"time":19910,"x":247,"y":313},{"time":19951,"x":246,"y":314},{"time":20014,"x":246,"y":315},{"time":20034,"x":245,"y":315},{"time":20117,"x":244,"y":316},{"time":20177,"x":244,"y":317},{"time":20198,"x":243,"y":317},{"time":20239,"x":243,"y":318},{"time":20259,"x":242,"y":318},{"time":20323,"x":241,"y":319},{"time":20385,"x":240,"y":320},{"time":20448,"x":239,"y":321},{"time":20489,"x":238,"y":321},{"time":20510,"x":237,"y":322},{"time":20573,"x":236,"y":322},{"time":20638,"x":235,"y":322},{"time":20659,"x":235,"y":323},{"time":20685,"x":234,"y":323},{"time":20723,"x":233,"y":324},{"time":20765,"x":232,"y":324},{"time":20825,"x":231,"y":324},{"time":20848,"x":231,"y":325},{"time":20888,"x":230,"y":325},{"time":20951,"x":229,"y":325},{"time":20971,"x":228,"y":326},{"time":21009,"x":227,"y":326},{"time":21030,"x":227,"y":327},{"time":21069,"x":226,"y":327},{"time":21152,"x":225,"y":327},{"time":21172,"x":225,"y":328},{"time":21215,"x":224,"y":328},{"time":21298,"x":223,"y":328},{"time":21319,"x":223,"y":329},{"time":21339,"x":222,"y":329},{"time":21360,"x":221,"y":329},{"time":21490,"x":220,"y":330},{"time":21511,"x":219,"y":330},{"time":21602,"x":218,"y":330},{"time":21623,"x":217,"y":330},{"time":21665,"x":216,"y":330},{"time":21768,"x":215,"y":330},{"time":21810,"x":213,"y":331},{"time":21852,"x":212,"y":331},{"time":21936,"x":211,"y":331},{"time":21999,"x":210,"y":331},{"time":22040,"x":209,"y":332},{"time":22081,"x":208,"y":332},{"time":22102,"x":207,"y":332},{"time":22185,"x":206,"y":332},{"time":22226,"x":205,"y":332},{"time":22248,"x":204,"y":333},{"time":22269,"x":203,"y":333},{"time":22317,"x":202,"y":333},{"time":22357,"x":201,"y":333},{"time":22384,"x":200,"y":333},{"time":22403,"x":199,"y":334},{"time":22423,"x":198,"y":334},{"time":22442,"x":197,"y":334},{"time":22461,"x":196,"y":334},{"time":22482,"x":195,"y":334},{"time":22522,"x":194,"y":335},{"time":22565,"x":193,"y":335},{"time":22605,"x":192,"y":335},{"time":22729,"x":191,"y":335},{"time":22811,"x":190,"y":335},{"time":22852,"x":189,"y":335},{"time":22937,"x":188,"y":335},{"time":22983,"x":187,"y":336},{"time":23070,"x":186,"y":336},{"time":23110,"x":185,"y":336},{"time":23173,"x":184,"y":336},{"time":23193,"x":183,"y":336},{"time":23255,"x":182,"y":336},{"time":23317,"x":181,"y":336},{"time":23338,"x":180,"y":336},{"time":23382,"x":179,"y":336},{"time":23443,"x":178,"y":336},{"time":23526,"x":177,"y":336},{"time":23628,"x":176,"y":336},{"time":23688,"x":175,"y":336},{"time":23708,"x":174,"y":336},{"time":23750,"x":173,"y":336},{"time":23832,"x":172,"y":336},{"time":23873,"x":171,"y":336},{"time":23920,"x":170,"y":336},{"time":23962,"x":169,"y":336},{"time":24003,"x":168,"y":336},{"time":24085,"x":167,"y":336},{"time":24127,"x":166,"y":336},{"time":24151,"x":165,"y":336},{"time":24190,"x":164,"y":336},{"time":24253,"x":163,"y":336},{"time":24316,"x":162,"y":336},{"time":24357,"x":161,"y":336},{"time":24405,"x":160,"y":336},{"time":24451,"x":159,"y":336},{"time":24490,"x":158,"y":336},{"time":24536,"x":157,"y":336},{"time":24576,"x":156,"y":336},{"time":24640,"x":155,"y":336},{"time":24703,"x":154,"y":336},{"time":24765,"x":153,"y":336},{"time":24827,"x":152,"y":336},{"time":24851,"x":151,"y":336},{"time":24892,"x":150,"y":335},{"time":24956,"x":149,"y":335},{"time":25000,"x":148,"y":335},{"time":25041,"x":147,"y":335},{"time":25083,"x":146,"y":335},{"time":25151,"x":145,"y":335},{"time":25192,"x":145,"y":334},{"time":25234,"x":144,"y":334},{"time":25275,"x":143,"y":334},{"time":25337,"x":142,"y":334},{"time":25404,"x":141,"y":334},{"time":25451,"x":140,"y":334},{"time":25490,"x":139,"y":334},{"time":25550,"x":138,"y":334},{"time":25591,"x":137,"y":334},{"time":25623,"x":136,"y":333},{"time":25643,"x":135,"y":333},{"time":25703,"x":134,"y":333},{"time":25783,"x":133,"y":333},{"time":25802,"x":132,"y":333},{"time":25865,"x":132,"y":332},{"time":25885,"x":130,"y":332},{"time":25906,"x":128,"y":332},{"time":25926,"x":126,"y":331},{"time":25969,"x":125,"y":331},{"time":26015,"x":124,"y":331},{"time":26036,"x":124,"y":330},{"time":26056,"x":123,"y":330},{"time":26102,"x":121,"y":329},{"time":26122,"x":120,"y":329},{"time":26164,"x":119,"y":329},{"time":26185,"x":119,"y":328},{"time":26226,"x":118,"y":328},{"time":26249,"x":117,"y":328},{"time":26290,"x":117,"y":327},{"time":26310,"x":115,"y":327},{"time":26353,"x":114,"y":326},{"time":26436,"x":113,"y":326},{"time":26456,"x":112,"y":325},{"time":26499,"x":110,"y":324},{"time":26582,"x":109,"y":324},{"time":26604,"x":109,"y":323},{"time":26648,"x":108,"y":323},{"time":26689,"x":107,"y":323},{"time":26711,"x":107,"y":322},{"time":26754,"x":106,"y":322},{"time":26818,"x":105,"y":321},{"time":26882,"x":104,"y":320},{"time":26965,"x":103,"y":320},{"time":26986,"x":103,"y":319},{"time":27006,"x":102,"y":319},{"time":27049,"x":101,"y":318},{"time":27068,"x":101,"y":317},{"time":27109,"x":100,"y":317},{"time":27132,"x":100,"y":316},{"time":27152,"x":99,"y":315},{"time":27172,"x":97,"y":313},{"time":27193,"x":95,"y":311},{"time":27258,"x":94,"y":311},{"time":27284,"x":94,"y":310},{"time":27308,"x":93,"y":310},{"time":27328,"x":93,"y":309},{"time":27349,"x":92,"y":308},{"time":27368,"x":92,"y":307},{"time":27388,"x":91,"y":307},{"time":27409,"x":91,"y":306},{"time":27511,"x":91,"y":305},{"time":27554,"x":90,"y":305},{"time":27575,"x":90,"y":304},{"time":27657,"x":90,"y":303},{"time":27688,"x":89,"y":302},{"time":27809,"x":89,"y":301},{"time":27831,"x":89,"y":300},{"time":27872,"x":88,"y":300},{"time":27893,"x":88,"y":299},{"time":27958,"x":88,"y":298},{"time":28022,"x":88,"y":297},{"time":28043,"x":87,"y":297},{"time":28108,"x":87,"y":296},{"time":28150,"x":87,"y":295},{"time":28171,"x":86,"y":295},{"time":28217,"x":86,"y":294},{"time":28282,"x":86,"y":293},{"time":28301,"x":85,"y":293},{"time":28342,"x":85,"y":292},{"time":28385,"x":85,"y":291},{"time":28425,"x":84,"y":291},{"time":28470,"x":84,"y":290},{"time":28490,"x":84,"y":289},{"time":28509,"x":83,"y":289},{"time":28532,"x":83,"y":288},{"time":28592,"x":83,"y":287},{"time":28637,"x":83,"y":286},{"time":28657,"x":82,"y":286},{"time":28681,"x":82,"y":285},{"time":28721,"x":82,"y":284},{"time":28743,"x":82,"y":283},{"time":28786,"x":81,"y":282},{"time":28851,"x":81,"y":281},{"time":28918,"x":81,"y":279},{"time":28938,"x":80,"y":278},{"time":28999,"x":80,"y":277},{"time":29039,"x":80,"y":276},{"time":29084,"x":80,"y":275},{"time":29126,"x":79,"y":274},{"time":29157,"x":79,"y":273},{"time":29198,"x":79,"y":272},{"time":29237,"x":79,"y":271},{"time":29283,"x":79,"y":270},{"time":29323,"x":79,"y":269},{"time":29385,"x":79,"y":268},{"time":29427,"x":79,"y":267},{"time":29470,"x":79,"y":266},{"time":29490,"x":78,"y":265},{"time":29550,"x":78,"y":264},{"time":29610,"x":78,"y":263},{"time":29652,"x":78,"y":262},{"time":29694,"x":78,"y":261},{"time":29738,"x":78,"y":260},{"time":29784,"x":78,"y":259},{"time":29825,"x":78,"y":258},{"time":29869,"x":78,"y":257},{"time":29929,"x":78,"y":256},{"time":29991,"x":78,"y":255},{"time":30037,"x":78,"y":254},{"time":30104,"x":78,"y":253},{"time":30144,"x":78,"y":252},{"time":30186,"x":78,"y":251},{"time":30207,"x":78,"y":250},{"time":30251,"x":78,"y":249},{"time":30338,"x":78,"y":248},{"time":30423,"x":78,"y":247},{"time":30484,"x":78,"y":246},{"time":30571,"x":78,"y":245},{"time":30611,"x":78,"y":244},{"time":30691,"x":78,"y":243},{"time":30803,"x":78,"y":242},{"time":30844,"x":78,"y":241},{"time":30887,"x":78,"y":240},{"time":30928,"x":78,"y":239},{"time":30971,"x":78,"y":238},{"time":31033,"x":78,"y":237},{"time":31084,"x":78,"y":236},{"time":31142,"x":78,"y":235},{"time":31242,"x":78,"y":234},{"time":31287,"x":78,"y":233},{"time":31351,"x":78,"y":232},{"time":31390,"x":79,"y":232},{"time":31409,"x":79,"y":231},{"time":31493,"x":79,"y":230},{"time":31555,"x":79,"y":229},{"time":31598,"x":79,"y":228},{"time":31659,"x":79,"y":227},{"time":31723,"x":79,"y":226},{"time":31786,"x":79,"y":225},{"time":31807,"x":80,"y":225},{"time":31827,"x":80,"y":224},{"time":31888,"x":80,"y":223},{"time":31949,"x":80,"y":222},{"time":31990,"x":80,"y":221},{"time":32011,"x":81,"y":221},{"time":32033,"x":81,"y":220},{"time":32074,"x":81,"y":219},{"time":32117,"x":82,"y":218},{"time":32181,"x":82,"y":217},{"time":32203,"x":82,"y":216},{"time":32266,"x":83,"y":215},{"time":32307,"x":83,"y":214},{"time":32371,"x":83,"y":213},{"time":32392,"x":84,"y":213},{"time":32421,"x":84,"y":212},{"time":32460,"x":84,"y":211},{"time":32502,"x":84,"y":210},{"time":32521,"x":85,"y":210},{"time":32582,"x":85,"y":209},{"time":32621,"x":85,"y":208},{"time":32641,"x":86,"y":208},{"time":32662,"x":86,"y":207},{"time":32683,"x":86,"y":206},{"time":32703,"x":87,"y":205},{"time":32723,"x":87,"y":204},{"time":32765,"x":88,"y":204},{"time":32785,"x":88,"y":203},{"time":32826,"x":88,"y":202},{"time":32870,"x":89,"y":201},{"time":32891,"x":89,"y":200},{"time":32916,"x":90,"y":200},{"time":32936,"x":90,"y":199},{"time":32984,"x":90,"y":198},{"time":33042,"x":91,"y":197},{"time":33104,"x":91,"y":196},{"time":33143,"x":92,"y":196},{"time":33187,"x":92,"y":195},{"time":33227,"x":92,"y":194},{"time":33250,"x":93,"y":194},{"time":33290,"x":93,"y":193},{"time":33335,"x":94,"y":192},{"time":33398,"x":94,"y":191},{"time":33439,"x":95,"y":191},{"time":33460,"x":95,"y":190},{"time":33549,"x":95,"y":189},{"time":33570,"x":96,"y":189},{"time":33610,"x":96,"y":188},{"time":33652,"x":97,"y":188},{"time":33673,"x":97,"y":187},{"time":33718,"x":98,"y":187},{"time":33739,"x":98,"y":186},{"time":33784,"x":99,"y":186},{"time":33806,"x":99,"y":185},{"time":33849,"x":100,"y":184},{"time":33888,"x":100,"y":183},{"time":33908,"x":101,"y":183},{"time":33969,"x":102,"y":182},{"time":34053,"x":102,"y":181},{"time":34074,"x":103,"y":181},{"time":34117,"x":103,"y":180},{"time":34138,"x":104,"y":180},{"time":34202,"x":105,"y":179},{"time":34265,"x":106,"y":179},{"time":34306,"x":106,"y":178},{"time":34350,"x":107,"y":178},{"time":34410,"x":107,"y":177},{"time":34452,"x":108,"y":177},{"time":34536,"x":109,"y":176},{"time":34619,"x":110,"y":176},{"time":34659,"x":110,"y":175},{"time":34683,"x":111,"y":175},{"time":34723,"x":112,"y":175},{"time":34817,"x":113,"y":175},{"time":34856,"x":114,"y":174},{"time":34936,"x":115,"y":174},{"time":34998,"x":116,"y":174},{"time":35040,"x":117,"y":174},{"time":35124,"x":118,"y":174},{"time":35191,"x":119,"y":174},{"time":35277,"x":120,"y":174},{"time":35341,"x":121,"y":174},{"time":35385,"x":121,"y":175},{"time":35406,"x":122,"y":175},{"time":35457,"x":123,"y":175},{"time":35537,"x":123,"y":176},{"time":35556,"x":124,"y":176},{"time":35575,"x":125,"y":177},{"time":35658,"x":126,"y":178},{"time":35751,"x":126,"y":179},{"time":35770,"x":127,"y":180},{"time":35790,"x":127,"y":181},{"time":35853,"x":127,"y":182},{"time":35918,"x":127,"y":183},{"time":35981,"x":127,"y":184},{"time":36064,"x":127,"y":185},{"time":36126,"x":127,"y":186},{"time":36151,"x":126,"y":186},{"time":36192,"x":126,"y":187},{"time":36258,"x":126,"y":188},{"time":36384,"x":126,"y":189},{"time":36471,"x":125,"y":190},{"time":36553,"x":125,"y":191},{"time":36618,"x":125,"y":192},{"time":36638,"x":124,"y":192},{"time":36771,"x":124,"y":193},{"time":36830,"x":123,"y":193},{"time":36871,"x":123,"y":194},{"time":36939,"x":123,"y":195},{"time":36960,"x":122,"y":195},{"time":37024,"x":122,"y":196},{"time":37044,"x":121,"y":196},{"time":37066,"x":121,"y":197},{"time":37172,"x":121,"y":198},{"time":37218,"x":120,"y":198},{"time":37284,"x":120,"y":199},{"time":37350,"x":120,"y":200},{"time":37389,"x":119,"y":200},{"time":37409,"x":119,"y":201},{"time":37494,"x":119,"y":202},{"time":37581,"x":119,"y":203},{"time":37659,"x":118,"y":203},{"time":37721,"x":118,"y":204},{"time":37786,"x":117,"y":206},{"time":37808,"x":115,"y":208}]}]';
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}