/**
 * Copyright murderdeathkitty ( http://wonderfl.net/user/murderdeathkitty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yXBt
 */

// forked from murderdeathkitty's SoundFork
// forked from murderdeathkitty's flash on 2009-7-17
package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.utils.*;
    public class SoundFork extends Sprite {
        
        private var sound: Sound;
        private var channel: SoundChannel
        private var phase: Number = 0;
        private var left: Number = 0;
        private var right: Number = 0;
        
        public function SoundFork(): void
        {
            addEventListener(Event.ADDED_TO_STAGE, start);
            addEventListener(Event.REMOVED_FROM_STAGE, stop);
        }
        public function start(e: Event = null): void
        {
            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, generate);
            channel = sound.play();
        }
        public function stop(e: Event = null): void
        {
            if(channel != null){
                channel.stop();
                channel = null;
            }
        }
        
        private function generate(e: SampleDataEvent): void
        {
            var data: ByteArray = e.data;
            var i: Number;
            var r: Number;
            for(i = 0; i < 4096; ++i){
                r = Math.random();
                left = (left + ((right+0.501)%1)*r*(1-phase))%1;
                right = (right + ((left+0.501)%1)*r*(phase-1))%1;
                e.data.writeFloat(left-right*0.25 - 0.5);
                e.data.writeFloat(right-left*0.25 - 0.5);
                phase = (phase+0.0001)%1;
            }
        }
    }
}