/**
 * Copyright bioRex21 ( http://wonderfl.net/user/bioRex21 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yWgU
 */

package 
{
    import flash.display.Stage;
    import com.bit101.components.PushButton;
    import com.bit101.components.Text;
    import flash.system.SecurityDomain;
    import flash.media.SoundLoaderContext;
    import flash.system.LoaderContext;
    import com.greensock.TweenLite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    import flash.system.Security;
    
    [SWF(frameRate= "60")]
    public class SoundSpectrum extends Sprite 
    {
        private var _musicURLTxt:Text;
        
        private var _byteArray:ByteArray = new ByteArray();    
        
        private var _slopesGen:SlopesGen;
        private var _lasersGen:LasersGen;
        
        private var _scoreDisplay:ScoreDisplay;
        private var _sound:Sound;
        private var _meteorUfoGen:MeteorUfoGen;
        private var _assetsManager:AssetsManager;
        private var _cursorManager:NativeCursorManager;
        private var _loadingTF:TextField;
        private var _percLoaded:Number;
        private var _bassData:Number;
        private var _trebleData:Number;
        
        
        public function SoundSpectrum() 
        {
            _cursorManager = new NativeCursorManager();
        
            _assetsManager = new AssetsManager();
            _assetsManager.onAllLoaded.add(onAllEnemyAssetsReady);            
            
            var blackBG:Shape = new Shape();
            blackBG.graphics.beginFill(0x000000);
            blackBG.graphics.drawRect(0,0, 465, 465);
            blackBG.graphics.endFill();
            addChild(blackBG);
            
            _slopesGen = new SlopesGen();
            _slopesGen.x = 465;            
            addChild(_slopesGen);                    
            
            _meteorUfoGen = new MeteorUfoGen();
            addChild(_meteorUfoGen);
            
            _lasersGen = new LasersGen();
            _lasersGen.onTargetHit.add(onTargetHit_handler);
            addChild(_lasersGen);
            
            _scoreDisplay = new ScoreDisplay();
            _scoreDisplay.x = 310;
            _scoreDisplay.y = 10;
            addChild(_scoreDisplay);
            
            _loadingTF = new TextField();
            _loadingTF.x = 200;
            _loadingTF.y = 200;
            _loadingTF.width += 100;
            _loadingTF.textColor = 0xfffff;
           
            addChild(_loadingTF);
            
            _sound = new Sound();        
            _sound.addEventListener(ProgressEvent.PROGRESS, onLoading);
            
            _musicURLTxt = new Text(this, 9, 10, "https://dl.dropboxusercontent.com/u/3164863/Pokemon%20GoldSilverCrystal%20Champion%20Theme%20Remix.mp3");
            _musicURLTxt.height = 20;            
            _musicURLTxt.addEventListener(MouseEvent.MOUSE_OVER, onMouseOverText);
            _musicURLTxt.addEventListener(MouseEvent.MOUSE_OUT, onMouseOutsideText);
            
            var startMusicLoadBtn:PushButton = new PushButton(this, 9, 30, "Load Music", startLoading);
            
        }
        
        private function onMouseOutsideText(e:MouseEvent):void 
        {
            _cursorManager.useShipCursor();
        }
        
        private function onMouseOverText(e:MouseEvent):void 
        {
            _cursorManager.useIBeamCursor();
        }
        
        private function startLoading(e:MouseEvent):void 
        {        
            _sound.load(new URLRequest(_musicURLTxt.text));
            _loadingTF.text = "loading..";
            
            this.removeChild(e.currentTarget as Sprite);
            this.removeChild(_musicURLTxt);
        }
        
        private function onLoading(e:ProgressEvent):void 
        {
            
            _percLoaded = Math.floor((e.bytesLoaded * 100) / e.bytesTotal);
            
            
            if(_percLoaded < 45)
            _loadingTF.text =  "loading song " +_percLoaded.toString() + "% .. D:";
            
            if(_percLoaded > 45 && _percLoaded < 85)
            _loadingTF.text =  "loading song " +_percLoaded.toString() + "% .. :)";
            
            if(_percLoaded > 85)
            _loadingTF.text =  "loading song " +_percLoaded.toString() + "% .. :D";
            
            if (_percLoaded == 100)
            onSoundLoaded();
            
            
        }
        
        private function onAllEnemyAssetsReady():void 
        {
            _meteorUfoGen.setBitmapDatas(_assetsManager.asteroidAsset, _assetsManager.ufoAsset);
        }        
        
        private function onSoundLoaded():void 
        {
            _loadingTF.textColor = 0xFBFF59;
            _loadingTF.text = "OMG dude you can shoot \n click click click!!";
            
            TweenLite.to(_loadingTF, 5, { x:_loadingTF.x, onComplete:removeTF  } );
            
            var soundChannel:SoundChannel;
            soundChannel = _sound.play(0,10);
            
            this.addEventListener(Event.ENTER_FRAME, onUpdate);
            stage.addEventListener(MouseEvent.CLICK, shootLaser);
        }
        
        private function removeTF():void 
        {
            removeChild(_loadingTF);
        }
        
        private function onUpdate(e:Event):void
        {
            SoundMixer.computeSpectrum(_byteArray, true, 0);
            
            var peakL:Number = 0;
            var peakR:Number = 0;
            
            //reading left channel (bass)
            for (var i:Number = 0; i < 256; i++) 
            {
                    if (i == 255) //reading the lower bass
                    peakL = (_byteArray.readFloat()*560)*255 ;                
            }
            
            //reading right channel (treble)
            for (var j:Number = 0; j < 256; j++) 
                peakR += (_byteArray.readFloat()*560);
            
            
            _bassData = (peakL / 256);
            _trebleData = peakR /256;
            
            _meteorUfoGen.addEnemy(_bassData);            
            _meteorUfoGen.update();
            
            _slopesGen.drawPeakData(_trebleData);
            _slopesGen.update();    
            
            _lasersGen.update(_meteorUfoGen.getChilds());            
            
        }
        
        private function onTargetHit_handler():void 
        {
            _scoreDisplay.incremScore();
        }
        
        private function shootLaser(e:MouseEvent):void 
        {
            _lasersGen.addLaser(e.stageX, e.stageY);
        }    
    }
}
import flash.system.SecurityDomain;
import flash.display.AVM1Movie;
import flash.ui.MouseCursor;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.net.URLRequest;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;
import flash.system.LoaderContext;
import flash.system.Security;

class AssetsManager
{
    public var asteroidAsset:BitmapData;
    public var ufoAsset:BitmapData;    
        
    //private var _urlRequests:Array = [new URLRequest("http://biorex21stuff.hostoi.com/asteroid2.png"), new URLRequest("http://biorex21stuff.hostoi.com/ufo2.png")];
    private var _urlRequests:Array = [new URLRequest("https://lh6.googleusercontent.com/SzaM_ZEBxPAhJyNrGJ50ZhG9NCEtysADGeImhxNkx9BaHXSR9TsfkINi7P7Gaio4o6ZQnDoj=w1893-h862"), new URLRequest("https://lh6.googleusercontent.com/SzaM_ZEBxPAhJyNrGJ50ZhG9NCEtysADGeImhxNkx9BaHXSR9TsfkINi7P7Gaio4o6ZQnDoj=w1893-h862")];
    
    private var _currentURL:Number = 0;
    private var _loader:Loader;
    public var onAllLoaded:ISignal;
    private var _context:LoaderContext;
        
    public function AssetsManager()
    {
        
        
        
        onAllLoaded = new Signal();
        _loader = new Loader();
           

        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
            
        loadContent(_urlRequests[_currentURL]);
    }
        
    
        
        private function loadContent(urlReq:URLRequest):void
        {        
         _context = new LoaderContext(true);
            _loader.load(urlReq, _context);
        }
        
        private function onLoadComplete(e:Event):void
        {           
            switch (_currentURL)
            {                
                case 0: 
                {
                    asteroidAsset = new BitmapData(_loader.width, _loader.height,true, 0x000000);
                    asteroidAsset.draw(_loader);
                    break;
                }
                
                case 1: 
                {
                    ufoAsset = new BitmapData(_loader.width, _loader.height,true, 0x000000);
                    ufoAsset.draw(_loader);
                    break;
                }
            
            }
            
            if (_currentURL < _urlRequests.length - 1)
            {
                _currentURL++;
                loadContent(_urlRequests[_currentURL]);
            }
            
            else
            {
                onAllLoaded.dispatch();
            }
        }
    
}

import flash.display.Sprite;
    import flash.geom.Point;
class SlopesGen extends Sprite 
    {        
        private var _peaksSeparation:Number = 10;
        
        private var _slopesVec:Vector.<Slope> = new Vector.<Slope>();        
        private var _emergePoint:Point = new Point(0,465);
        private var _peakPoint:Point = new Point();
        
        private var _boundLines:Sprite;
        
        private var removalCounter:Number = 0;
        private var removalLimit:Number = 300;
        private var _slopesContainer:Sprite;
        
        public function SlopesGen() 
        {
            
            _boundLines = new Sprite();
            addChild(_boundLines);
            
            _slopesContainer = new Sprite();
            addChild(_slopesContainer);
            
            //drawBounds();
            
        }    
            
        public function drawPeakData(averagePeakData:Number):void 
        {
            
            _peakPoint.x = _emergePoint.x + _peaksSeparation;    
            _peakPoint.y = 465- (averagePeakData);
                    
            var slope:Slope = new Slope(_emergePoint, _peakPoint);
            _slopesContainer.addChild(slope);            
            
            //redrawBounds(_emergePoint.y,(465- (averagePeakData[0] )));
            
            _emergePoint.x = _emergePoint.x + _peaksSeparation;
            _emergePoint.y =  465 - (averagePeakData);
            
                
        }
        
        private function redrawBounds(y1:Number, y2:Number):void 
        {
            trace("[SlopesGen] " + y1+", "+y2);
            
            _boundLines.graphics.clear();
            
            //base line
            _boundLines.graphics.lineStyle(1, 0xff0000);        
            _boundLines.graphics.moveTo(0, 50);    
            _boundLines.graphics.lineTo(880, 50);
            
            //right border
            _boundLines.graphics.moveTo(465, 50);
            _boundLines.graphics.lineTo(465, y2 - 465);
            
            //left border
            _boundLines.graphics.moveTo(0, 50);
            _boundLines.graphics.lineTo(465,(_slopesContainer.getChildAt(0) as Sprite).y-465);
        }
        
        public function update():void 
        {
            if (_slopesContainer.x <= -465)
            {
                var lineToRemove:Sprite = (_slopesContainer.getChildAt(0) as Sprite);
                (lineToRemove.parent as Sprite).removeChild(lineToRemove);
                
                
            }        
            _slopesContainer.x -= _peaksSeparation;
            //_boundLines.x += _peaksSeparation;
            
        
        }
        
        private function drawBounds():void 
        {
            _boundLines.x = -465;
            _boundLines.y = 465;
            _boundLines.graphics.lineStyle(1, 0xff0000);        
            _boundLines.graphics.moveTo(0, 50);    
            _boundLines.graphics.lineTo(465, 50);
            
            
        }
        
}

import flash.display.Sprite;
    import flash.geom.Point;
class Slope extends Sprite
{    
        
        public function Slope(emergePoint:Point, peakPoint:Point) 
        {
            this.graphics.lineStyle(1, 0x0000ff);
            this.graphics.moveTo(peakPoint.x - (peakPoint.x - emergePoint.x) , emergePoint.y);
            this.graphics.lineTo(peakPoint.x, peakPoint.y);
        }        
        
}
import flash.display.Sprite;
import flash.geom.Point;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;


class LasersGen extends Sprite 
{
        
        public var onTargetHit:ISignal;
        private var _scenarioWidth:Number = 465;
        
        public function LasersGen() 
        {
            onTargetHit = new Signal();
        }
        
        public function addLaser(xOrigin:Number, yOrigin:Number):void 
        {        
            //this.addChild(new Laser(xOrigin - this.x + 32, yOrigin+16));            
            
            this.addChild(new Laser(xOrigin - this.x + 32, yOrigin));            
            this.addChild(new Laser(xOrigin - this.x + 32, yOrigin+16));            
        }
        
        
        public function update(destroyableTargets:Vector.<IEnemy>):void 
        {
            var totalLasers:Number = this.numChildren;
            var totaltargets:Number = destroyableTargets.length ;
            
            var laserPosToDestroy:Number = -1;
            var enemyPosToDestroy:Number = -1;
            
            //collision check
            for (var laserPos:int = 0; laserPos < totalLasers; laserPos++) 
            {                
                for (var cloudPos:int = 0; cloudPos < totaltargets; cloudPos++) 
                {
                    var currentLaser:Laser = (this.getChildAt(laserPos) ) as Laser;
                    if (currentLaser.hitTestObject(destroyableTargets[cloudPos] as Sprite)) 
                    {                        
                        laserPosToDestroy = laserPos;
                        enemyPosToDestroy = cloudPos;                        
                        onTargetHit.dispatch();
                    }
                }
                
            }
            
            if(laserPosToDestroy != -1)
            (this.getChildAt(laserPosToDestroy)  as Laser).destroy();
            
            if(enemyPosToDestroy != -1)
            destroyableTargets[enemyPosToDestroy].destroy();
            
            //if laser goes outside the screen limits, gets removed
            if (this.numChildren > 0)
            {
                var laserToRemove:Laser = (this.getChildAt(0) as Laser);
                var globalCoords:Point =     this.localToGlobal(new Point(laserToRemove.x, laserToRemove.y));    
            
                if (globalCoords.x > _scenarioWidth)
                    laserToRemove.destroy();
                
                
            }
            
            this.x+= 10;
        }
        
}

import flash.display.Shape;
import flash.display.Sprite;

class Laser extends Shape 
{
        
        public function Laser(xOrigin:Number, yOrigin:Number) 
        {
            this.x = xOrigin;
            this.y = yOrigin;
            
            this.graphics.beginFill(0xffffff);
            this.graphics.drawRect(0, 0, 5, 2);
            this.graphics.endFill();
            
        }
        
        public function destroy():void 
        {
            this.visible = false;
            (this.parent as Sprite).removeChild(this);
        }
        
        
        
}

import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Point;


class MeteorUfoGen extends Sprite 
{
        private var _lastIntensityWasntTwo:Boolean =  true;
        private var _asteroidBitmapData:BitmapData;
        private var _ufoBitmapData:BitmapData;
        public var enemiesOnScreen:Number = 0;
        
        private var _scenarioWidth:Number = 465;
                
        public function MeteorUfoGen() 
        {
            
        }
        
        public function setBitmapDatas(loadedAsteroidBitmapData:BitmapData, loadedUfoBitmapData:BitmapData):void 
        {
            _asteroidBitmapData = loadedAsteroidBitmapData;
            _ufoBitmapData = loadedUfoBitmapData;
        }
        
        /**
         * adds an enemy at random Y coord
         */
        public function addEnemy(intensity:Number):void 
        {
            //"_lastIntensityWasntTwo" to reduce repetition a bit
            if (intensity >= 500 && _lastIntensityWasntTwo)
            {
                
                var n:Number = Math.random();
                
                if (n < 0.5)
                {
                    
                    var asteroid:Asteroid = new Asteroid(_asteroidBitmapData);                    
                    asteroid.x = -this.x + _scenarioWidth ;
                    asteroid.y = randomNumber(5, 300);
                    asteroid.scaleX = asteroid.scaleY = (randomNumber(1,8)) *.1;
                    addChild(asteroid);
                }
                
                else
                {
                    var ufo:Ufo = new Ufo(_ufoBitmapData);                    
                    ufo.x = -this.x + _scenarioWidth ;
                    ufo.y = randomNumber(5, 300);
                    
                    addChild(ufo);
                }            
            
                _lastIntensityWasntTwo = false;
                
            }
            
            else
             _lastIntensityWasntTwo = true;
             
            
        }
        
        public function update():void 
        {
            this.x -= 10;
            
            if (this.numChildren > 0)
            {
                var enemyToRemove:IEnemy = (this.getChildAt(0) as IEnemy);
                var globalCoords:Point =     this.localToGlobal(new Point((enemyToRemove as Sprite).x, (enemyToRemove as Sprite).y));    
            
                if (globalCoords.x < 0)
                    enemyToRemove.destroy();                    
            }            
        }
        
        //vector for collision check
        public function getChilds():Vector.<IEnemy> 
        {
            var children:Vector.<IEnemy> = new Vector.<IEnemy>();
            
            var len:Number = this.numChildren;
            
            for (var i:int = 0; i < len; i++) 
                children.push( this.getChildAt(i));
            
            
            return children;
        }
        
        private function randomNumber(low:Number=0, high:Number=1):Number
        {
          return Math.floor(Math.random() * (1+high-low)) + low;
        }
        
}

import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;


class Asteroid extends Sprite implements IEnemy
{        
        public function Asteroid(bitmapDataAsset:BitmapData) 
        {    
            this.addChild(new Bitmap(bitmapDataAsset) );                    
            this.rotationZ = (Math.random() * 100);
            
        }        
        
        public function destroy():void 
        {
            //this.visible = false;
            (this.parent as Sprite).removeChild(this);
        }
        
}

import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;

class Ufo extends Sprite implements IEnemy
{
        public function Ufo(ufoBitmapData:BitmapData) 
        {
            this.addChild(new Bitmap(ufoBitmapData) );            
            this, scaleX = this.scaleY = 0.8; 
        }        
        
        public function destroy():void 
        {
            //this.visible = false;
            (this.parent as Sprite).removeChild(this);
        }
        
}

interface IEnemy 
{    
        
    function destroy():void
        
}

import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
class ScoreDisplay extends Sprite 
{
        private var _tf:TextField;
        
        private var _currentScore:Number = 0;
        
        public function ScoreDisplay() 
        {
            _tf = new TextField();
            _tf.text = "score: 0";           
            _tf.textColor = 0xffffff;
            _tf.width = 100;
            addChild(_tf);
        }
        
        public function incremScore(increm:Number = 1):void 
        {
            _currentScore += increm;
            _tf.text = "score: "+_currentScore.toString();
            
        }
        
}
import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.ui.Mouse;
    import flash.system.LoaderContext;
import flash.ui.MouseCursorData;

class NativeCursorManager 
{
        private var _shipBitmapDatas:Vector.<BitmapData>;
        
        private var _mouseFrame1:Loader;
        private var _mouseFrame2:Loader;
        
        public function NativeCursorManager() 
        {
            _shipBitmapDatas = new Vector.<BitmapData>();    
            
            loadCursor();
        }
        
        public function loadCursor():void 
        {
            _mouseFrame1 = new Loader();

            _mouseFrame1.contentLoaderInfo.addEventListener(Event.COMPLETE, onFrame1Loaded);

            

            _mouseFrame1.load(new URLRequest("https://lh5.googleusercontent.com/pOxToBeYJWCks_Wh3_qdVW5gDOkvX7Pl0xu7OawC8av7z7fjCB5x1cVJRuOCFuCCipzF2I3-h-VWuYw=w1893-h862"),new LoaderContext(true));

            

            
            _mouseFrame2 = new Loader();
            _mouseFrame2.contentLoaderInfo.addEventListener(Event.COMPLETE, onFrame2Loaded);
            
            _mouseFrame2.load(new URLRequest("https://lh5.googleusercontent.com/Sj9OxoMXj_tMdUcSDdBRaafU2C2JcPUtxpdhGWaAn8U413idO4rUicwTS3ZIsORwJjaouJDmhGkudcY=w1893-h862"),new LoaderContext(true));
        }
        
        private function onFrame1Loaded(e:Event):void 
        {
            var bitmapData1:BitmapData = new BitmapData(_mouseFrame1.width, _mouseFrame1.height, true, 0x000000);
            bitmapData1.draw(_mouseFrame1);
            _shipBitmapDatas.push( bitmapData1) ;
            
            if (_shipBitmapDatas.length == 2)
                onBothLoaded();
        }
        
        private function onFrame2Loaded(e:Event):void 
        {
            var bitmapData2:BitmapData = new BitmapData(_mouseFrame2.width, _mouseFrame2.height, true, 0x000000);
            bitmapData2.draw(_mouseFrame2);
            
            _shipBitmapDatas.push( bitmapData2) ;
            if (_shipBitmapDatas.length == 2)
                onBothLoaded();
        }
        
        
        
        public function onBothLoaded():void 
        {
            var cursorData:MouseCursorData = new MouseCursorData();        
             
            cursorData.hotSpot = new Point(0,0)
        
            cursorData.data = _shipBitmapDatas;
            cursorData.frameRate = 3;
         
            Mouse.registerCursor("shipCursor", cursorData)
            Mouse.cursor = "shipCursor";
        }
        
        public function useShipCursor():void 
        {
            if (_shipBitmapDatas.length == 2)
            {
                Mouse.cursor = "shipCursor";
            }
        }
        
        public function useIBeamCursor():void 
        {
            Mouse.cursor = MouseCursor.IBEAM;
        }
        
}


