/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yW3w
 */

package {

    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "25")]

    import flash.display.DisplayObject;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.MouseEvent;
    
    import caurina.transitions.Tweener;
    
    public class DEH extends Sprite {
        
        private var content:XML =
            <content>
                <menuItem barColor="0x0000ff" titleColor="0x33ffff" title="home"/>
                <menuItem barColor="0xff0000" titleColor="0xffffee" title="work"/>
                <menuItem barColor="0xff00ff" titleColor="0xffffff" title="about me/who am I"/>
                <menuItem barColor="0x00ff00" titleColor="0x000000" title="contact"/>
            </content>;
        
        public function DEH() {
            var childY:Number = 0;
            for each (var child:XML in content.*) {
                var mc:MovieClip = createMenuItem(uint(child.@barColor), uint(child.@titleColor), child.@title);
                mc.mask = createMask();
                mc.x = mc.xLeft;
                mc.y = childY;
                childY += mc.height;
                addChild(mc);
            }
        }
        
        private function createMenuItem(barColor:uint, titleColor:uint, title:String):MovieClip {
            const TITLE_LEFT_MARGIN:Number = 20;
            const TITLE_RIGHT_MARGIN:Number = 20;
            const TITLE_SCALE:Number = 4;
            var tf:TextField = new TextField();
            tf.textColor = titleColor;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.selectable = false;
            tf.mouseEnabled = false;
            tf.text = title;
            tf.x = TITLE_LEFT_MARGIN;
            tf.scaleX = tf.scaleY = TITLE_SCALE;
            var mc:MovieClip = new MovieClip();
            mc.addChild(tf);
            mc.graphics.beginFill(barColor);
            mc.graphics.drawRect(0, 0, TITLE_LEFT_MARGIN + tf.width + TITLE_RIGHT_MARGIN, tf.height);
            mc.graphics.endFill();
            mc.addEventListener(MouseEvent.MOUSE_OVER, itemOver);
            mc.addEventListener(MouseEvent.MOUSE_OUT, itemOut);
            mc.buttonMode = true;
            mc.xLeft = TITLE_RIGHT_MARGIN - mc.width;
            mc.xRight = 0;
            mc.animTime = mc.width / 500;
            return(mc);
        }
        
        private function itemOver(e:MouseEvent):void {
            var menuItem:MovieClip = MovieClip(e.currentTarget);
            Tweener.addTween(menuItem, {x:menuItem.xRight, time:menuItem.animTime, transition:"easeOutQuad"});
        }
        
        private function itemOut(e:MouseEvent):void {
            var menuItem:MovieClip = MovieClip(e.currentTarget);
            Tweener.addTween(menuItem, {x:menuItem.xLeft, time:menuItem.animTime, transition:"easeOutQuad"});
        }
        
        private function createMask():DisplayObject {
            var s:Shape = new Shape();
            s.graphics.beginFill(0x00ff00);
            s.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            s.graphics.endFill();
            addChild(s);
            return(s);
        }
        
    }
}