/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yVjV
 */

// forked from miyaoka's Milk
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import net.hires.debug.Stats;
    import flash.filters.BevelFilter;
    import flash.filters.DropShadowFilter;
    
    [SWF(width = "465", height = "465", backgroundColor = 0xFFFFFF, frameRate = "30")]
    
    public class Milk
    extends Sprite
    {
        private var bmd:BitmapData;
        private var ballsContainer:Sprite;
        private var alphaArray:Array = new Array(0x100);
        public function Milk() 
        {
            //bg
            graphics.beginFill(0xffffff);
            graphics.drawRect(0, 0, SW, SH);
            
            //bmd
            bmd = new BitmapData(SW, SH, true);
            
            //threshold for metaball
            makeThreshold(0x80, 0x82);
            
            //balls
            ballsContainer = new Sprite();
            var num:uint = 3;
            while (num--) 
            {
                var ball:Ball = new Ball();
                ballsContainer.addChild(ball);
                ball.filters = [
                    new DropShadowFilter(10, 270, 0xff333333, 1.0, 100, 100, .8, 3, false)
                ];
            }
            ballsContainer.filters =
            [
              // new BevelFilter(2)
//new DropShadowFilter(30, 45, 0xcccccc, 0.9, 20, 20, 2, 2, false) 

            ];    
            
            //add
//            addChild(ballsContainer);            
            addChild(new Bitmap(bmd));
            addChild(new Stats());
            
            //evt
            addEventListener(Event.ENTER_FRAME, function ():void 
            {
                bmd.lock();
                bmd.fillRect(bmd.rect , 0);
                bmd.draw(ballsContainer);
                bmd.paletteMap(bmd, bmd.rect, new Point(), null, null, null, alphaArray);        
                bmd.unlock();
            });
        }
        private function makeThreshold(min:uint, max:uint):void 
        {
            alphaArray = [];
            var step:Number = 0xFF / (max - min);
            var i:int;
            //under threshold
            for(i = 0; i < min; i++) {
                alphaArray[i] = 0;
            }
            for(i = min; i < max; i++) {
                alphaArray[i] = uint(((i - min) * step)  << 24);
            }            
            //over threshold
            for(i = max; i < 0x100; i++) {
                alphaArray[i] = 0xff000000;
            }
        }
        
    }    
}

var SW:Number = 465;
var SH:Number = 465;

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.filters.DropShadowFilter; 
class Ball
extends Shape
{
    private var vct:Point;
    public function Ball():void 
    {
        vct = new Point(5*Math.random(), 2*Math.random());
        
        //draw
        var g:Graphics = graphics;
        var radius:Number = 100;
        var mtx:Matrix = new Matrix();
        mtx.createGradientBox(radius * 2, radius * 2, 0, -radius, -radius);
        g.beginGradientFill(
            GradientType.RADIAL, 
            [0xffffff, 0xffffff],
            [1, 0],
            [0x33, 0xff],
            mtx
        );

        g.drawCircle(0, 0, radius); 
        
        //evt
        addEventListener(Event.ENTER_FRAME, function ():void 
        {
            var pos:Point = new Point(x, y).add(vct);
            x = pos.x;
            y = pos.y;
            checkWall();
        });
    }
    private function checkWall():void 
    {
        if (x < 0)
        {
            x = 0;
            vct.x *= -1;
        }
        else if (x > SW)
        {
            x = SW;
            vct.x *= -1;            
        }
        
        if (y < 0)
        {
            y = 0;
            vct.y *= -1;
        }
        else if (y > SH)
        {
            y = SH;
            vct.y *= -1;            
        }
    }
}