/**
 * Copyright Mae_ITR ( http://wonderfl.net/user/Mae_ITR )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yVcK
 */

// forked from clockmaker's Green Icon Generator
// forked from alumican_net's [Sample] BoundaryResizer Demo

//このデータを18枚x4セット作る課題
//手作業でやってたら半端無かったので作った
//急造なんでコード汚いです

package 
{
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.net.*;
	
	import com.bit101.components.*;
	import jp.progression.casts.*;
	import mx.graphics.codec.*;
	
	/**
	 * ...
	 * @author mae0510
	 */
	public class Main extends CastDocument 
	{
		private var _fr:FileReference;
		private var _loader:CastLoader;
		private var _baseimage:BaseImage;
		private var _ui:Sprite;
		private var _count:uint = 1;
		private var slider:HSlider;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			// entry point
			
			//BaseImage
			_baseimage = new BaseImage();
			_baseimage.scaleX = _baseimage.scaleY = 0.5; 
			addChildAt(_baseimage, 0);
			
			//Loader
			_fr = new FileReference();
			_loader = new CastLoader();			
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplateHandler);
			
			//UI
			_ui = new Sprite();
			addChildAt(_ui, 1);
			new PushButton(this._ui, 10, 10, "Load Image", FileBrowseHandler);
			new PushButton(this._ui, 10, 40, "Save Image", FileSaveHandler);
			slider = new HSlider(this._ui, 120, 12.5, scaleHandler);
			new Label(this._ui, 230, 10, "Zoom Out / In");
			slider.value = _baseimage.scaleX * 100;
			
			//枠まわり
			this.graphics.lineStyle(1, 0xCCCCCC);
			this.graphics.beginFill(0xFFFFFF);
			this.graphics.drawRect(0,0,620, 877);
			this.graphics.endFill();
			
		}
		//エクスプローラーを開く
		private function FileBrowseHandler(e:Event = null):void
		{
			_fr.browse();
			_fr.addEventListener(Event.SELECT, FileSelectHandler );
		}
		//ファイルを選択する
		private function FileSelectHandler(e:Event):void 
		{
			_fr.addEventListener(Event.COMPLETE, FileLoadedHanler );
			_fr.removeEventListener(Event.SELECT, FileSelectHandler );
			_fr.load();
			
		}
		//ファイルデータのロードの完了
		private function FileLoadedHanler(e:Event = null):void 
		{
			_fr.removeEventListener(Event.COMPLETE,  FileLoadedHanler);
			_loader.loadBytes(_fr.data);
		}
		//_loaderのデータロードの完了&イメージを書き出す
		private function loadComplateHandler(e:Event):void 
		{
			trace("BitmapData Loaded");
			var bmd:BitmapData = new BitmapData(_loader.width, _loader.height);
			bmd.draw(_loader);
			_baseimage.drawImage(bmd);
		}
		//イメージを保存する
		private function FileSaveHandler(e:Event = null):void
		{
			if (!_loader.content) return;
			var capture :BitmapData = new BitmapData(1240, 1754);
			_baseimage.ui.removeAllChildren();
			capture.draw(_baseimage);
			_fr.save((new PNGEncoder()).encode(capture), "data" + _count + ".png");
			_count++;
		}
		//BaseImageの拡大縮小 ※後付け　超適当
		private function scaleHandler(e:Event = null):void
		{
			_baseimage.zoom = slider.value / 100;
			this.graphics.clear();
			this.graphics.lineStyle(1, 0xCCCCCC);
			this.graphics.beginFill(0xFFFFFF);
			this.graphics.drawRect(0, 0, 1240 * slider.value / 100, 1754 * slider.value / 100);
			this.graphics.endFill();
		}		
	}
}
	import flash.display.*;
	import flash.events.*;
	import flash.ui.*;
	import flash.geom.Rectangle;
	import flash.text.*;
	import frocessing.color.FColor;
	import jp.progression.casts.CastSprite;
	//import net.alumican.as3.geom.BoundaryResizer;

	
	/**
	 * ...
	 * @author mae0510
	 */
	class BaseImage extends CastSprite
	{
		private var _scale:Number = 0.5;
		public var ui:CastSprite;
		private var _image:CastSprite;		
		private var _pickCursor:Sprite;
		private var _picture:Bitmap;
		
		private var eventbar:ColorBar;
		private var editbars:Array;
		
		public function BaseImage() 
		{
			_image = new CastSprite();
			ui = new CastSprite();
			addChild(_image);
			addChildAt(ui, 10);
			
			drawTitle();
			
			//カラーピック時のカーソルを描く
			_pickCursor = new Sprite();
			_pickCursor.graphics.beginFill(0x111111);
			_pickCursor.graphics.drawRect(0,-10, 1.5, 20);
			_pickCursor.graphics.drawRect( -10, 0, 20, 1.5);
			_pickCursor.graphics.endFill();			
		}
		//タイトル＆名前
		private function drawTitle():void
		{
			var title:TextField = new TextField();
			trace(title.type);
			title.type = TextFieldType.INPUT;
			trace(TextFieldType.INPUT);
			title.defaultTextFormat = new TextFormat("_ゴシック", 20, 0x666666);
			title.text = "タイトル/イメージ１ 学籍番号　名前";
			title.x = 729;
			title.y = 1676;
			title.width = 400;
			addChildAt(title,1);
		}
		//画像データのリサイズ＆表示
		public function drawImage(bmd:BitmapData):void
		{
			_image.removeAllChildren();
			ui.removeAllChildren();
			_picture = new Bitmap(bmd);
			var boundary:Rectangle = new Rectangle(204,113,830,560);
			var target:Rectangle = _picture.bitmapData.rect;
			var resized:Rectangle = BoundaryResizer.resize(target, boundary, BoundaryResizer.SHOW_ALL, BoundaryResizer.BOTTOM);
			_picture.width = resized.width;
			_picture.height = resized.height;
			_picture.x = resized.x;
			_picture.y = resized.y;
			_image.addChild(_picture);
			
			drawBars();
			
		}
		private function drawBars():void 
		{
			editbars = new Array();
			var dotcolor:Array = new Array();
			for (var i:int = 0; i <= 2; i++) {
				dotcolor[i]=_picture.bitmapData.getPixel(_picture.width*Math.random(),_picture.height*Math.random());
				var colorbar:ColorBar = new ColorBar(dotcolor[i]);
				colorbar.name = String(i);
				colorbar.x = 204 + 276 * i;
				colorbar.y = 768;
				_image.addChild(colorbar);
				colorbar.addEventListener(ColorBar.DOWN, mouswDownHandler);
				
				var colorbar2:ColorBar = new ColorBar(dotcolor[i]);
				colorbar2.name =String(i);
				colorbar2.x = 204 + 276  * i;
				colorbar2.y = 1020;
				_image.addChild(colorbar2);
				editbars[i] = colorbar2;
				colorbar2.addEventListener(ColorBar.CLICK,colorEditHandler);
			}			
		}
		
		private function colorEditHandler(e:Event):void 
		{
			var eventbar2:ColorBar =  e.currentTarget as ColorBar;
			eventbar2.removeEventListener(ColorBar.CLICK, colorEditHandler);
			var editwindow:Editer = new Editer();
			editwindow.target = eventbar2;
			editwindow.window.title =  "Color:HSV " + String(int(eventbar2.name)+1);
			editwindow.slider1.value = (eventbar2.color.h>=0)?Math.round(eventbar2.color.h / 360 * 100):Math.round((360+eventbar2.color.h) / 360 * 100);
			editwindow.slider2.value = Math.round(eventbar2.color.s * 100);
			editwindow.slider3.value = Math.round(eventbar2.color.v * 100);
			editwindow.x = stage.mouseX / _scale;
			editwindow.y = stage.mouseY / _scale;
			editwindow.width /= _scale;
			editwindow.height /= _scale;
			ui.addChild(editwindow);
			editwindow.addEventListener(Editer.CHANGE, changevalueHandler);
			editwindow.addEventListener(Editer.CLOSE, windowCloseHandler);
		}
		
		private function windowCloseHandler(e:Event):void 
		{
			ui.removeChild(e.currentTarget as Editer);
			e.currentTarget.target.addEventListener(ColorBar.CLICK,colorEditHandler);
		}
		
		private function changevalueHandler(e:Event):void 
		{
			var tempColor:FColor = new FColor();
			tempColor.hsv(	e.currentTarget.slider1.value * 360 / 100,
							e.currentTarget.slider2.value /100,
							e.currentTarget.slider3.value /100
						);
			e.currentTarget.target.draw(tempColor.value);
		}
		
		private function mouswDownHandler(e:Event):void 
		{
			Mouse.hide();
			addChild(_pickCursor);
			eventbar =  e.currentTarget as ColorBar;						
			_pickCursor.x = stage.mouseX / _scale;
			_pickCursor.y = stage.mouseY / _scale;
			addEventListener(MouseEvent.MOUSE_UP, mouseupHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, colorpickHandler);
		}
		
		private function colorpickHandler(e:MouseEvent):void 
		{
			var color:uint = _picture.bitmapData.getPixel(_picture.mouseX,_picture.mouseY);
			eventbar.draw(color);
			editbars[int(eventbar.name)].draw(color);
			_pickCursor.x = stage.mouseX / _scale;
			_pickCursor.y = stage.mouseY / _scale;
		}
		
		private function mouseupHandler(e:MouseEvent):void 
		{
			Mouse.show();
			removeChild(_pickCursor);
			removeEventListener(MouseEvent.MOUSE_UP, mouseupHandler);
			stage.removeEventListener(MouseEvent.MOUSE_MOVE,colorpickHandler);
		}
		public function set zoom(scale:Number):void {
			this._scale = this.scaleX = this.scaleY = scale;
			for each(var target:Sprite in this.ui.children) {
				target.scaleX = target.scaleY = 1/scale;
			}
		}
		
		
	}
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import frocessing.color.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author mae0510
	 */
	class ColorBar  extends Sprite
	{
		public var colorbar:Sprite;
		public var color:FColor;
		private var _tfHSBs:Array;
		private var _tfRGBs:Array;
		private var th:Array = ["H", "S", "B" ];
		private var tr:Array = ["R", "G", "B" ];
		
		static public const CLICK:String = "barclick";
		static public const DOWN:String = "bardown";
		
		public function ColorBar(color:uint) 
		{
			init(color);			
		}
		
		private function init(color:uint):void
		{
			colorbar = new Sprite();
			colorbar.addEventListener(MouseEvent.CLICK, mouseclickHandler);
			colorbar.addEventListener(MouseEvent.MOUSE_DOWN,mousedownHandler);
			addChild(colorbar);
			
			_tfHSBs = new Array();
			_tfRGBs = new Array();
			var tformat:TextFormat = new TextFormat("_sans", 20, 0x666666);
			for (var i:int = 0; i <= 2; i++ ) {
				var tfHSB:TextField = new TextField();
				tfHSB.defaultTextFormat = tformat;
				tfHSB.x = 11 + i * 87;
				tfHSB.y = 63;
				addChild(tfHSB);
				_tfHSBs.push(tfHSB);
				
				var tfRGB:TextField = new TextField();
				tfRGB.defaultTextFormat = tformat;
				tfRGB.x = 11 + i * 87;
				tfRGB.y = 119;
				addChild(tfRGB);
				_tfRGBs.push(tfRGB);
			}
			
			draw(color);
			
		}

		public function draw(color:uint):void {
			drawBar(color);
			drawParam(color);
		}
		
		private function drawBar(value:uint):void
		{
			colorbar.graphics.clear();
			colorbar.graphics.beginFill(value);
			colorbar.graphics.drawRect(0, 0, 276, 14);
			colorbar.graphics.endFill();
			
		}
		
		private function drawParam(value:uint):void
		{
			color = new FColor();
			color.value = value;
			
			for (var i:int = 0; i <= 2; i++ ) {
				switch(i) {
					case 0: (color.h >= 0)?_tfHSBs[i].text = th[i] + ": " + Math.round(color.h):_tfHSBs[i].text = th[i] + ": " + Math.round(360 + color.h);
							_tfRGBs[i].text = tr[i] + ": " + color.r;
							break;
					case 1: _tfHSBs[i].text = th[i] + ": " + Math.round(color.s * 100);
							_tfRGBs[i].text = tr[i] + ": " + color.g;
							break;
					case 2: _tfHSBs[i].text = th[i] + ": " + Math.round(color.v * 100);
							_tfRGBs[i].text = tr[i] + ": " + color.b;
							break;
					default : break;
				}
			}
			
		}
				
		private function mousedownHandler(e:MouseEvent):void 
		{
			dispatchEvent(new Event(ColorBar.DOWN));
		}
		
		private function mouseclickHandler(e:MouseEvent):void 
		{
			dispatchEvent(new Event(ColorBar.CLICK));
		}
		
	}
	import com.bit101.components.*;
	import flash.display.Sprite;	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	
	/**
	 * ...
	 * @author Mae0510
	 * */
	class Editer extends Sprite 
	{
		
		public var target:ColorBar;
		
		public var window:Window;
		public var slider1:HSlider;
		public var slider2:HSlider;
		public var slider3:HSlider;
		private var btn:PushButton;
		
		static public const CHANGE:String = "change";
		static public const CLOSE:String = "close";
		
		public function Editer() 
		{
			init();	
		}
		
		private function init():void
		{
			window = new Window(this, 0, 0);
			window.width = 215;
			window.height = 120;
			
			slider1 = new HSlider(window.content, 20, 10);
			slider1.addEventListener(Event.CHANGE,changevalueHandler);
			slider1.width = 180;			
			slider2 = new HSlider(window.content, 20, 30);
			slider2.addEventListener(Event.CHANGE,changevalueHandler);
			slider2.width = 180;
			slider3 = new HSlider(window.content, 20, 50);
			slider3.addEventListener(Event.CHANGE,changevalueHandler);
			slider3.width = 180;
			
			btn = new PushButton(window.content, 100, 70, "close", closeHandler);
			
			new Label(window.content, 5, 7, "H");
			new Label(window.content, 5, 27, "S");
			new Label(window.content, 5, 47, "B");
		}
		
		private function closeHandler(e:Event = null):void
		{
			dispatchEvent(new Event(Editer.CLOSE));
			//this.parent.removeChild(this);
		}
		
		private function changevalueHandler(e:Event):void 
		{
			dispatchEvent(new Event(Editer.CHANGE));
		}
		
	}
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Rectangle;
	
	/**
	 * BoundaryResizer
	 * 様々なリサイズをRectangleベースで実行するクラスです．
	 * @see http://blog.alumican.net/2009/10/07_225251
	 * @author alumican.net<Yukiya Okuda>
	 */
	class BoundaryResizer
	{
		//-------------------------------------
		//CLASS CONSTANTS
		
		/**
		 * scaleMode
		 * リサイズ方法を操作するscaleModeには以下の定数を指定できます．
		 */
		static public const EXACT_FIT:String = StageScaleMode.EXACT_FIT; // targetとboundaryが完全に一致するようにリサイズされます．多くの場合，targetの縦横比は保たれません．
		static public const SHOW_ALL:String  = StageScaleMode.SHOW_ALL;  // targetが縦横比を保ち，かつtargetがboundaryの内側にフィットするようにリサイズされます．targetがトリミングされることはありませんが，上下または左右に隙間ができることがあります．
		static public const NO_BORDER:String = StageScaleMode.NO_BORDER; // targetが縦横比を保ち，かつboundaryがtargetの内側にフィットするようにリサイズされます．targetとboundaryの間に隙間ができることはありませんが，targetがトリミングされることがあります．
		static public const NO_SCALE:String  = StageScaleMode.NO_SCALE;  // リサイズがおこなわれず，alignによる基準点合わせのみがおこなわれます．
		
		/**
		 * align
		 * リサイズ後のオブジェクトの基準点を操作するalignには以下の定数を指定できます．
		 */
		static public const TOP_LEFT:String     = StageAlign.TOP_LEFT;     // x軸方向:左  , y軸方向:上
		static public const TOP:String          = StageAlign.TOP;          // x軸方向:中央, y軸方向:上
		static public const TOP_RIGHT:String    = StageAlign.TOP_RIGHT;    // x軸方向:右  , y軸方向:上
		static public const LEFT:String         = StageAlign.LEFT;         // x軸方向:左  , y軸方向:中央
		static public const CENTER:String       = "";                      // x軸方向:中央, y軸方向:中央
		static public const RIGHT:String        = StageAlign.RIGHT;        // x軸方向:右  , y軸方向:中央
		static public const BOTTOM_LEFT:String  = StageAlign.BOTTOM_LEFT;  // x軸方向:左  , y軸方向:下
		static public const BOTTOM:String       = StageAlign.BOTTOM;       // x軸方向:中央, y軸方向:下
		static public const BOTTOM_RIGHT:String = StageAlign.BOTTOM_RIGHT; // x軸方向:右  , y軸方向:下
		
		
		
		
		
		//-------------------------------------
		//METHODS
		
		/**
		 * targetをboundaryに合わせてリサイズした矩形を返します．
		 * リサイズ方法と基準点をscaleMode，alignで指定できます．
		 * @param   target    リサイズ対象オブジェクトの矩形を指定します．(例)リサイズしたい画像の矩形
		 * @param   boundary  リサイズの基準となる矩形を指定します．(例)リサイズ後の画像を収める枠
		 * @param   scaleMode リサイズ時のスケールモードを指定します．このパラメータはStageScaleModeと互換性があります．このパラメータを省略した場合はBoundaryResizer.NO_SCALEとなり，リサイズはおこなわれません．
		 * @param   align     boundaryに対するtargetの基準位置を指定します．このパラメータはStageAlignと互換性があります．このパラメータを省略した場合はBoundaryResizer.CENTERとなり，縦横ともに中央揃えとなります．
		 * @return            リサイズ後の矩形が返されます．target及びboundaryは変更しません．
		 */
		static public function resize(target:Rectangle, boundary:Rectangle, scaleMode:String = "noScale", align:String = ""):Rectangle
		{
			var tx:Number = target.x,
			    ty:Number = target.y,
			    tw:Number = target.width,
			    th:Number = target.height,
			    bx:Number = boundary.x,
			    by:Number = boundary.y,
			    bw:Number = boundary.width,
			    bh:Number = boundary.height;
			
			switch (scaleMode)
			{
				case SHOW_ALL:
				case NO_BORDER:
					var ratioW:Number = bw / tw,
					    ratioH:Number = bh / th,
					    ratio:Number  = (scaleMode == SHOW_ALL) ? ( (ratioW < ratioH) ? ratioW : ratioH ) :
					                                              ( (ratioW > ratioH) ? ratioW : ratioH ) ;
					tw *= ratio;
					th *= ratio;
					break;
				
				case EXACT_FIT:
					return new Rectangle(bx, by, bw, bh);
			}
			
			tx = bx + ( (align == TOP_LEFT    || align == LEFT   || align == BOTTOM_LEFT ) ? 0               :
			            (align == TOP_RIGHT   || align == RIGHT  || align == BOTTOM_RIGHT) ? (bw - tw)       :
			                                                                                 (bw - tw) / 2 ) ;
			ty = by + ( (align == TOP_LEFT    || align == TOP    || align == TOP_RIGHT   ) ? 0               :
			            (align == BOTTOM_LEFT || align == BOTTOM || align == BOTTOM_RIGHT) ? (bh - th)       :
			                                                                                 (bh - th) / 2 ) ;
			
			return new Rectangle(tx, ty, tw, th);
		}
	}
	
