/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yV8I
 */

package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	[SWF(width = "240",height = "180")]
	public class LoopTest extends Sprite {
		static private const MAX_NUMBER:uint = 10000;
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		private var mySprite:Sprite = new Sprite();
		public function LoopTest() {
			// Creating a TextField for display
			addChild(mySprite);
			createTextField();
			// Starting Test
			combined_loops();
			separate_loops();
			combined_loops();
			separate_loops();
		}
		private function separate_loops():void {
			removeChild(mySprite);
			mySprite = new Sprite();
			addChild(mySprite);
			var started:int = getTimer();
			var instances:Vector.<Sprite> = new Vector.<Sprite>(MAX_NUMBER);
			for (var i:int = 0; i < MAX_NUMBER; i++) {
				instances[i] = new Sprite();
			}
			for (var j:uint = 0; j < MAX_NUMBER; j++) {
				mySprite.addChild(instances[j]);
			}
			xTrace("separate",getTimer() - started);
		}
		private function combined_loops():void {
			removeChild(mySprite);
			mySprite = new Sprite();
			addChild(mySprite);
			var started:int = getTimer();
			var instances:Vector.<Sprite> = new Vector.<Sprite>(MAX_NUMBER);
			for (var i:int = 0; i < MAX_NUMBER; i++) {
				var child:Sprite = new Sprite()
				instances[i] = child;
				mySprite.addChild(child);
			}
			xTrace("combined",getTimer() - started);
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_fmt.align = TextFormatAlign.RIGHT;
			// my_txt.x +=  50;
			my_txt.defaultTextFormat = my_fmt;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
		}
		private function xTrace(_str:String,n:int):void {
			my_txt.appendText(String(n) + "\n");
			label_txt.appendText(_str + ":" + "\n");
		}
	}
}