/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yV2L
 */

package  
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HSlider;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;
    import com.greensock.TweenLite;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    public class OilPaintingLines extends Sprite
    {
        private var targetX:Number;
        private var oilPainter:OilPainter;
        private var c:int;
        private var yPos:Number;
        private var completedCount:int;
        private var yPosInit:Number;
        private var hSliderX:HSlider;
        private var sprite:Sprite;
        private var _rectangle:Rectangle;
        private var totalTimePerLine:Number;
        private var vbox:VBox;
        private var currentFunction:Function;
        private var textArea:Label;
        private var marginX:Number;
        private var separation:HUISlider;
        private var linesAmount:HUISlider;
        private var heightTarget:HUISlider;
        public var position:Number = 0;
        public function OilPaintingLines() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            var rrr:Number ;
            ((rrr = Math.random()) + 20 / 10 - 0.5);
            trace( "     -> " + ((rrr = Math.random()) + 20 / 10 - 0.5) );
            var number:Number = rrr + 1.5;
            trace( "number : " + number );
            
            
            targetX = 465-20;
            totalTimePerLine = 2.3;
            oilPainter = addChild(new OilPainter) as OilPainter;
            oilPainter.signal.add(onPlay);
            yPos = yPosInit = 100;
            position = marginX = 20;
            //var list:List = SCEasing.getList();
            currentFunction = SCEasing.getFunction();
            TweenLite.to(this, totalTimePerLine, { position:targetX, onUpdate:loop , onComplete:oc,ease:currentFunction } );
            scrollRectTest();    
            vbox = new VBox(this, 220, 10);
            vbox.visible = false;
            var timePerLine:HUISlider = new HUISlider(vbox, 0, 0, 'tpl',onTpl);
            timePerLine.maximum = 3;
            timePerLine.minimum = 0.01;
            timePerLine.value = totalTimePerLine;
            //var hBox:HBox = new HBox(vbox, 0, 0);
            textArea = new Label(vbox, 0, 0);
            textArea.text = SCEasing.getFunctionName();
            new CheckBox(vbox, 0, 0, 'change function automatically', doIsAutomatic).selected=SCEasing.isAutomatic;
            //list.setSize(100, 190);
            //vbox.addChildAt(list, vbox.numChildren);
            //vbox.addChild(buttons,vbox.numChildren);
            new CheckBox(this, 465 - 10, 0, '', doControlsVisibility).selected = vbox.visible;
            
            separation = new HUISlider(vbox, 0, 0, 'separation');
            separation.value = 35;
            linesAmount = new HUISlider(vbox, 0, 0, 'amount');
            linesAmount.value = 4;
            linesAmount.enabled = false;
            heightTarget = new HUISlider(vbox, 0, 0, 'heightTarget');
            heightTarget.maximum = 350;
            heightTarget.minimum = 15;
            heightTarget.value = 350;
            //list.addEventListener(Event.SELECT, onEasingSelect);
            SCEasing.getButtons(vbox, onSelectFunction);
            vbox.alpha = 0.88;
            
        }
        
        private function onSelectFunction(e:Event):void 
        {
            var pushButton:PushButton = e.target as PushButton;
            trace( "pushButton.name : " + pushButton.name );
            var i:int = int(pushButton.name);
            currentFunction = SCEasing.getFunction(i);
            textArea.text = SCEasing.getFunctionName();
            trace( "pushButton.label : " + pushButton.label );
        }
        
        private function doIsAutomatic(e:Event):void 
        {
            SCEasing.isAutomatic = CheckBox(e.target).selected
        }
        
        private function doControlsVisibility(e:Event):void 
        {
            vbox.visible = !vbox.visible;
        }
        /*
        private function onEasingSelect(e:Event):void 
        {
            var list:List = e.target as List;
            var s:int = list.selectedIndex;
            currentFunction = SCEasing.getFunction(s);
            textArea.text = SCEasing.getFunctionName() ;
        }
        */
        private function onTpl(e:Event):void 
        {
            totalTimePerLine = HUISlider(e.target).value;
        }
        
        
        private function onX(e:Event):void 
        {
            rectangle.x = hSliderX.value;
            sprite.scrollRect = rectangle;
        }
        
        private function onPlay():void 
        {
            yPos = yPosInit;
            position = 0;
            completedCount = 0;
            oilPainter._move(marginX, yPos, new Point(marginX, yPos) );
            TweenLite.to(this, totalTimePerLine, { position:targetX, onUpdate:loop ,onComplete:oc,ease:currentFunction} );
        }
        
        private function oc():void 
        {
            var rowsAmount:Number = heightTarget.value / separation.value;
            linesAmount.value = rowsAmount;
            completedCount++;
            position = 0;
            yPos += separation.value;
            oilPainter._move(marginX, yPos, new Point(marginX, yPos) );
            if (completedCount<rowsAmount) 
            {
                
                TweenLite.to(this, totalTimePerLine, { position:targetX, onUpdate:loop ,onComplete:oc ,ease:currentFunction} );
            }
            else
            {
                currentFunction = SCEasing.getFunction();
                oilPainter.clearIt();
                oilPainter.randomize();
                onPlay();
                textArea.text = SCEasing.getFunctionName();
            }
        }
        
        private function loop():void 
        {
            oilPainter._move(position, yPos );
            if (c++ % 2000==0)
            {
                c = 1;
                oilPainter.clearIt();
            }

        }
        
        private function scrollRectTest():void 
        {
            sprite = addChild(new Sprite) as Sprite;
            var g:Graphics = sprite.graphics;
            g.beginFill(0);
            g.drawCircle(0, 0, 40);
            sprite.x = 25;
            sprite.y = 25;
            sprite.visible = false;
            var vbox:VBox = new VBox(this,200, 0);
            hSliderX = new HSlider(vbox, 0, 0, onX);
            hSliderX.maximum = 200;
            hSliderX.minimum = -50;
            hSliderX.value = -50;
            hSliderX.visible = false;
            rectangle = new Rectangle(-50, -50, 100, 100);
        
        }
        
        public function get rectangle():Rectangle 
        {
            return _rectangle;
        }
        
        public function set rectangle(value:Rectangle):void 
        {
            _rectangle = value;
            sprite.scrollRect = _rectangle;
        }
        
    }

}
import com.bit101.components.CheckBox;
import com.bit101.components.HUISlider;
import com.bit101.components.Label;
import com.bit101.components.Panel;
import com.bit101.components.PushButton;
import com.bit101.components.RadioButton;
import com.bit101.components.VBox;
import com.bit101.components.VSlider;
import com.greensock.easing.Back;
import com.greensock.easing.Circ;
import com.greensock.easing.Cubic;
import com.greensock.easing.Elastic;
import com.greensock.easing.Expo;
import com.greensock.easing.Linear;
import flash.display.BitmapData;
import flash.display.CapsStyle;
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.LineScaleMode;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;
import idv.cjcat.signals.Signal;
class OilPainter extends Sprite {
    private var cnavasSprite:Sprite;
    private var prevX:int;
    private var prevY:int;
    private var startPosX:int;
    private var startPosY:int;
    private var disX:Number;
    private var disY:Number;
    private var color:uint;
    private var bitmapData:BitmapData;
    private var capsstyle:String=CapsStyle.ROUND;
    private var lineScaleMode:String=LineScaleMode.NONE;
    private var dispersion:HUISlider;
    private var sizeFactor:HUISlider;
    private var panel:Panel;
    private var angle:HUISlider;
    private var vbox:VBox;
    private var g1:Array;
    private var g2:Array;
    private var isRandom:Boolean =true;
    public var signal:Signal;
    public function OilPainter() {
        addEventListener(Event.ADDED_TO_STAGE, init);
        //stage.addEventListener(MouseEvent.MOUSE_MOVE, _move);
        //stage.addEventListener(MouseEvent.MOUSE_DOWN,_down)
        cnavasSprite = addChild(new Sprite()) as Sprite;
        panel = new Panel(this, 10, 10);
        panel.alpha = 0.87;
        panel.visible = false;
        vbox = new VBox(panel, 10, 0);
        panel.setSize(200, 330);
        new CheckBox(this, 0, 0, '', doPanelVisibility);
        g1 = radioButtonGroup('caps style', [CapsStyle.NONE, CapsStyle.ROUND, CapsStyle.SQUARE], 'g1', onG1, 1);
        g2 = radioButtonGroup('Line Scale Mode', [LineScaleMode.HORIZONTAL, LineScaleMode.VERTICAL, LineScaleMode.NORMAL, LineScaleMode.NONE], 'g2', onG2, 3);
        SCRadioButton.clearIt();
        cnavasSprite .doubleClickEnabled = true;
        bitmapData = new BitmapData(465, 465);
        //addChild(new Bitmap(bitmapData));
        dispersion = new HUISlider(null, 0, 0, "dispersion");
        dispersion.maximum = 10;
        dispersion.value = 10;
        
        sizeFactor = new HUISlider(null, 0, 0, 'size factor');
        sizeFactor.minimum = 10;
        sizeFactor.maximum = 60;
        sizeFactor.value = 15;
        angle = new HUISlider(null, 0, 0, 'angle');
        angle.maximum = Math.PI;
        angle.value = 0.5;
        
        addChildToVBox(angle);
        addChildToVBox(sizeFactor);
        addChildToVBox(dispersion);
        
        addChildToVBox(new PushButton(null, 0, 0, 'clear', doClear));
        addChildToVBox(new PushButton(null, 0, 0, 'play', doPlay));
        addChildToVBox(new PushButton(null, 0, 0, 'randomize', doRandomize));
        var checkBoxIsRandom:CheckBox = new CheckBox(null, 0, 0, 'change values randomly', doIsRandom);
        checkBoxIsRandom.selected = isRandom;
        addChildToVBox(checkBoxIsRandom);
        signal = new Signal;
    }
    
    private function doIsRandom(e:Event):void 
    {
        var checkBox:CheckBox = e.target as CheckBox;
        isRandom = checkBox.selected;
    }
    
    private function doRandomize(e:Event):void 
    {
        randomize();
    }
    public function randomize():void 
    {
        if (!isRandom) 
        {
            return;
        }
        randomizeHUIlsder(sizeFactor);
        randomizeHUIlsder(angle);
        randomizeHUIlsder(dispersion);
        capsstyle = randomizeRadioButtons(g1);
        
        lineScaleMode = randomizeRadioButtons(g2);
    }
    
    private function randomizeHUIlsder(huis:HUISlider):void 
    {
        huis.value = range(huis.minimum, huis.maximum);
    }
    private function range(ini:Number,end:Number):Number 
    {
        return ini + (end - ini) * Math.random();
    }
    private function randomizeRadioButtons(rbs:Array):String 
    {
        var lab:String;
        var rl:uint = rbs.length;
        var rr:int = int(rl * Math.random());
        var rb:SCRadioButton;
        for (var i:int = 0; i < rl; i++) 
        {
            if (i==rr) 
            {
                lab = SCRadioButton(rbs[i]).label;
            }
            SCRadioButton(rbs[i]).selected=(i==rr);
        }
        return lab;
    }
    private function doPlay(e:Event):void 
    {
        clearIt();
        signal.dispatch();
    }
    
    private function doClear(e:Event):void 
    {
        clearIt();    
    }
    
    private function doPanelVisibility(e:Event):void 
    {
        panel.visible=!panel.visible
    }
    
    private function onG2(e:Event):void 
    {
        lineScaleMode = SCRadioButton(e.target).label;
    }
    
    private function onG1(e:Event):void 
    {
        capsstyle = SCRadioButton(e.target).label;
    }
    
    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        stage.addEventListener(MouseEvent.DOUBLE_CLICK,onMouseDoubleClick)
    }
    private function onMouseDoubleClick(e:MouseEvent):void {
         cnavasSprite.graphics.clear();
    }
    public function clearIt():void 
    {
        onMouseDoubleClick(null);
    }
    private function _down(e:MouseEvent):void {
        color = Math.random() * 0xFFFFFF;    
    }
    
    private function radioButtonGroup(namem:String,labels:Array,groupName:String,callBack:Function,selected:int=-1):Array 
    {
        var radioButton:SCRadioButton;
        var al:uint = labels.length;
        var vboxl:VBox = new VBox(null, 0, 0);
        new Label(vboxl, 0, 0, namem);
        var radiobuttons:Array = [];
        for (var i:int = 0; i < al; i++) 
        {
            
            radioButton = new SCRadioButton(vboxl, 0, 0, labels[i], i==selected, callBack);
            radioButton.groupName = groupName;
            radiobuttons[i] = radioButton;
            
        }
        addChildToVBox(vboxl);
        return radiobuttons;
    }
    
    private function addChildToVBox(dobj:DisplayObject):void 
    {
        vbox.addChildAt(dobj, vbox.numChildren);
    }
    //private function _move(e:MouseEvent):void {
    public function _move(ex:Number, ey:Number,point:Point=null):void {
        SCRadioButton.clearIt();
        //cnavasSprite.graphics.clear();
        if (point) 
        {
            //prevX  = point.x;
            prevX = startPosX = point.x;
            //prevY = point.y;
            prevY = startPosY = point.y;
            
        }
        var rrr:Number;
        var distance:Number = Math.sqrt((prevX - startPosX)*(prevX - startPosX) + (prevY - startPosY)*(prevY - startPosY))
        var a:Number = distance * dispersion.value * (Math.pow(Math.random(),2)- 0.5)
        var r:Number = Math.random() - 0.5
        var size:Number = Math.random() * sizeFactor.value / distance
        var ang:Number =  angle.value;
        disX = (prevX - startPosX) * Math.sin(ang) + startPosX;
        disY = (prevY - startPosY) * Math.cos(ang) + startPosY;
        startPosX = prevX;
        startPosY = prevY;
        prevX = ex;
        prevY = ey;
        
        cnavasSprite.graphics.moveTo(startPosX, startPosY);
        cnavasSprite.graphics.curveTo(disX,disY,prevX,prevY)
        cnavasSprite.graphics.lineStyle(
                (Math.random() + 20 / 10 - 0.5) * size + (1 - Math.random() + 30 / 20 - 0.5) * size, 
                color,
                1, 
                false, 
                lineScaleMode,
                capsstyle
                );    
        cnavasSprite.graphics.moveTo(startPosX + a, startPosY + a);
        cnavasSprite.graphics.lineTo(startPosX+r+a, startPosY+r+a);
        cnavasSprite.graphics.endFill();
        //bitmapData.draw(cnavasSprite);
    }
}

class SCRadioButton extends RadioButton
{
    
    public function SCRadioButton(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, label:String = "", checked:Boolean = false, defaultHandler:Function = null)
    {
        super(parent, xpos , ypos  , label, checked, defaultHandler);
    }
    
    
    public static function clearIt():void
    {
        var colorTransform:ColorTransform;
        for(var i:uint = 0; i < buttons.length; i++)
        {
            colorTransform = SCRadioButton(buttons[i]).selected? new ColorTransform(1, 0, 0, 1):    new ColorTransform(0, 1, 0, 1);
            Sprite(SCRadioButton(buttons[i]).button()).transform.colorTransform = colorTransform;
        }
    }
    
    public function button():Sprite 
    {
        return _button;
    }
    
    public static function randomize():void 
    {
        var btns:Array = buttons;
        var sprite:SCRadioButton;
        var bl:uint = btns.length;
        for (var i:int = 0; i < bl; i++) 
        {
            sprite = SCRadioButton(buttons[i]);
            
        }
    }
    
    override protected function onClick(event:MouseEvent):void 
    {
        super.onClick(event);
        SCRadioButton.clearIt();
        addEventListener(Event.ENTER_FRAME, only_once);
        //var timer:Timer = new Timer(100,1);
        //timer.addEventListener(TimerEvent.TIMER_COMPLETE, function(e:TimerEvent):void { SCRadioButton.clearIt(); }, false, 0, true);
        //timer.start();
    }
    
    private function only_once(e:Event):void 
    {
        removeEventListener(Event.ENTER_FRAME, only_once);
        SCRadioButton.clearIt();
    }
    
    
}
class SCEasing 
{
    private static var currentFunctionIndex:int = 0;
    private static var currentFunctionName:String = '';
    public static var isAutomatic:Boolean = true;
    private static const FUNCTIONS:Vector.<Array> = Vector.<Array>([
            [Back.easeIn,'Back.easeIn'] 
            , [Back.easeInOut,'Back.easeInOut'] 
            , [Back.easeOut ,'Back.easeOut ']
            , [Circ.easeIn, 'Circ.easeIn']
            , [Circ.easeOut,'Circ.easeOut ']
            , [Circ.easeInOut,'Circ.easeInOut'] 
            , [Elastic.easeIn,'Elastic.easeIn'] 
            , [Elastic.easeInOut,'Elastic.easeInOut'] 
            , [Elastic.easeOut,'Elastic.easeOut'] 
            , [Expo.easeIn ,'Expo.easeIn ']
            , [Expo.easeOut,'Expo.easeOut'] 
            , [Expo.easeInOut, 'Expo.easeInOut'] 
            , [Linear.easeIn,'Linear.easeIn']
            , [Linear.easeOut,'Linear.easeOut']
            , [Linear.easeInOut,'Linear.easeInOut']
            , [Linear.easeNone,'Linear.easeNone']
            , [Cubic.easeIn,'Cubic.easeIn']
            , [Cubic.easeOut,'Cubic.easeOut']
            , [Cubic.easeInOut, 'Cubic.easeInOut']
            , [Expo.easeIn, 'Expo.easeIn']
            , [Expo.easeOut, 'Expo.easeOut']
            , [Expo.easeInOut, 'Expo.easeInOut']
        ]);
    //static private var list:List;
    static private var vbox:VBox;
    static private var listHeight:Number;
    
    public static function getFunction(s:int=-1):Function
    {
        var cf:Function;
        if (s==-1) 
        {
            
            cf = FUNCTIONS[currentFunctionIndex][0];
            currentFunctionName = FUNCTIONS[currentFunctionIndex][1];
            //list.selectedIndex = currentFunctionIndex; 
            
            if(isAutomatic) currentFunctionIndex++;
            if (currentFunctionIndex>=FUNCTIONS.length) 
            {
                currentFunctionIndex = 0;
            }
        }
        else
        {
            cf = FUNCTIONS[s][0];
            currentFunctionName = FUNCTIONS[s][1];
            //list.selectedIndex = currentFunctionIndex; 
            currentFunctionIndex = s
        }
        return cf; 
    }
    public static function getFunctionName():String 
    {
        return currentFunctionName;
    }
    /*
    public static function getList():List 
    {
        var listItem:ListItem;
        var fl:int = FUNCTIONS.length;
        var items:Array = [];
        for (var i:int = 0; i < fl; i++) 
        {
            listItem = new ListItem;
            {label:FUNCTIONS[i][1]}
            //listItem.data = FUNCTIONS[i][1]
            items[items.length]={label:FUNCTIONS[i][1]};
        }
        list = new List(null, 0, 0,items);
        return list;
    }
    */
    public static function getButtons(vboxArg:VBox, callBack:Function):void
    {
        listHeight = 190;
        var pushButton:PushButton;
        var fl:int = FUNCTIONS.length;
        //var hBox:HBox = new HBox(vboxArg,0,0);
        //vbox = new VBox(hBox, 0, 0);
        var sprite:Sprite = vboxArg.addChild(new Sprite) as Sprite;
        var numCols:Number = 2;
        for (var i:int = 0; i < fl; i++) 
        {
            var n:int = i % numCols;
            var m:int = int(i / numCols);
            trace( " " + m,',',n );
            pushButton = new PushButton(sprite, n*110, m*22, FUNCTIONS[i][1], callBack);
            pushButton.name = i.toString();
        }
        //vbox.scrollRect = new Rectangle(0, 0, 100, listHeight);
        //vbox.addEventListener(Event.ADDED_TO_STAGE, addScroller);
        
        //VBox(e.target).removeEventListener(Event.ADDED_TO_STAGE, addScroller);
        //var vBox:VBox = e.target as VBox;
        //var vSlider:VSlider = new VSlider(hBox, 0, 0, onSlide);
        //vSlider.setSize(vSlider.width, listHeight);
        //vSlider.value = vSlider.maximum = vbox.height - listHeight;
        //return vbox;
    }
    /*
    static private function addScroller(e:Event):void 
    {
    }
    */
    static private function onSlide(e:Event):void 
    {
        var vSlider:VSlider = e.target as VSlider;
        var s:Rectangle = new Rectangle(0, 0, 100, listHeight);
        s.y = vSlider.maximum-VSlider(e.target).value;
        vbox.scrollRect = s;
    }
}