/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yUky
 */

package
{
    
    import flash.display.*;
    import flash.events.Event;
    
    [SWF(frameRate=60)]
    public class ASTest extends Sprite
    {
        
        private const NUM_RAIN:int = 1;
        
        public function ASTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(evt:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(evt:Event):void
        {
            for(var i:int = 0; i < NUM_RAIN; i++)
            {
                new Rain(this, Math.random()*stage.stageWidth, Math.random()*stage.stageHeight, 0xaaaaee);
            }
        }
    }
}

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

class Rain extends Sprite
{
    
    private const SPEED:Number = 200;                //雨が1フレームに落ちる距離 pix
    private const INTERVAL_RATIO:Number = 0.1;        //次のフレームと現在のフレームでどの程度雨の線が寸断されるか
    private const CIRCLE_DEF_RADIUS:Number = 10;    //波紋の初期半径
    private const W_LEVEL:Number = 10;                //波紋が何フレーム残るか
    private const DIP:Number = 1/4;                    //地面に対しどれくらいの角度で雨を眺めているか　1なら地面に垂直　0なら水平
    
    private var _container:DisplayObjectContainer;
    
    private var _radian:Number = (Math.PI - Math.random()*Math.PI*2)/30;
    private var _color:uint;
    private var _height:Number;
    private var _frame:int;
    private var _offset:Number = Math.random()*SPEED;
    private var _point:Point;
    
    private var _hitCircle:Sprite;
    
    public function Rain(container:DisplayObjectContainer, x:Number = 0, y:Number = 0, color:uint = 0x888888)
    {
        this.x = x;
        this.y = y;
        this._color = color;
        this._container = container;
        _container.addChild(this);
        init();
    }
    
    private function init():void
    {
        _height = y;
        _frame = Math.floor(_height/100)+1;
        
        _point = new Point(Math.sin(_radian)*(SPEED*_frame+_offset), -Math.cos(_radian)*(SPEED*_frame+_offset));
        
        _hitCircle = addChild(new Sprite()) as Sprite;
        
        addEventListener(Event.ENTER_FRAME, onEnter);
    }
    
    private function onEnter(evt:Event):void
    {
        this.graphics.clear();
        this.graphics.lineStyle(1,_color);
        this.graphics.moveTo(_point.x, _point.y);
        
        if(_frame == 0)
        {
            this.graphics.lineTo(0,0);
            _hitCircle.graphics.lineStyle(1,_color);
            _hitCircle.graphics.drawCircle(0,0,CIRCLE_DEF_RADIUS);
            _hitCircle.scaleY = _hitCircle.scaleX*DIP;
            removeEventListener(Event.ENTER_FRAME, onEnter);
            addEventListener(Event.ENTER_FRAME, circle);
            return;
        }
        
        _frame --;
        
        _point.x = Math.sin(_radian)*(SPEED*(_frame+INTERVAL_RATIO)+_offset);
        _point.y = -Math.cos(_radian)*(SPEED*(_frame+INTERVAL_RATIO)+_offset);
        this.graphics.lineTo(_point.x, _point.y);
        
        _point.x = Math.sin(_radian)*(SPEED*_frame+_offset);
        _point.y = -Math.cos(_radian)*(SPEED*_frame+_offset);
        
    }
    
    private function circle(evt:Event):void
    {
        this.graphics.clear();
        
        _frame++;
        _hitCircle.scaleX += 0.2;
        _hitCircle.scaleY = _hitCircle.scaleX*DIP;
        _hitCircle.alpha = (W_LEVEL-_frame)/W_LEVEL;
        if(_frame >= W_LEVEL)
        {
            removeEventListener(Event.ENTER_FRAME, circle);
            _container.removeChild(this);
        }
    }
}