/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yUba
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", frameRate="60")]
        
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var _sun:Sun;
        
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            
            _sun = new Sun();
            _sun.x = stage.stageWidth / 2;
            _sun.y = stage.stageHeight / 2;
            addChild( _sun );
        }
        
    }
    
}
import flash.events.Event;
import flash.display.Sprite;

class Sun extends Sprite{
    
    private var _base:Sprite;
    private var _part:Array = new Array();
    
    public    function    Sun() {
        
        super();
        
        _base = new Sprite();
        _base.graphics.beginFill( 0xFF0000 );
        _base.graphics.lineStyle( 10, 0xFF8800 );
        _base.graphics.drawCircle( 0, 0, 50 );
        _base.graphics.endFill();
        
        addChild( _base );
        
        for ( var i:int = 0; i < 10; i++ )
        {
            var part:SunPart = new SunPart(i%2);
            part.x = Math.cos( (360 / 10) * i * Math.PI / 180 ) * 80;
            part.y = Math.sin( (360 / 10) * i * Math.PI / 180 ) * 80;
            part.rotation = (360 / 10) * i;
            _base.addChild( part );
            _part.push( part );
        }    
        
        addEventListener( Event.ENTER_FRAME, Update );
    }    
    
    private    function    Update( e:Event ) : void
    {
        var r:Number = this.rotation;
        
        
        
        
        
        this.rotation = (r + 0.2) % 360;
    }
    
}

class SunPart extends Sprite {
    
    private var size:Number;
    private var _type:int;
    
    private var _step:int;
    
    private static const cos0:Number = Math.cos( 0 );
    private static const sin0:Number = Math.sin( 0 );
    private static const cos120:Number = Math.cos( 120 * Math.PI / 180 );
    private static const sin120:Number = Math.sin( 120 * Math.PI / 180 );
    private static const cos240:Number = Math.cos( 240 * Math.PI / 180 );
    private static const sin240:Number = Math.sin( 240 * Math.PI / 180 );
    
    
    public    function    SunPart(type:int = 0) {
    
        super();
        
        _step = 0;
        _type = type;
        
        if ( type == 0 )    _step = 0;
        else                 _step = 90;
        
        /*
        this.graphics.beginFill( 0xFF0000 );
        this.graphics.lineStyle( 5, 0xFF8800 );
        this.graphics.moveTo( Math.cos( 0 * Math.PI / 180 ) * 20, Math.sin( 0 ) * 20 );
        this.graphics.lineTo( Math.cos( 120 * Math.PI / 180 ) * 20, Math.sin( 120 * Math.PI / 180 ) * size );
        this.graphics.lineTo( Math.cos( 240 * Math.PI / 180 ) * 20, Math.sin( 240 * Math.PI / 180 ) * size );
        this.graphics.endFill();
        */
        addEventListener( Event.ENTER_FRAME, Update );
    }
    
    private    function    Update( e:Event ) : void
    {
        var s:int = _step % 180;
        var xSize:Number = 0;
        
        if ( s < 90 )
        {
            xSize = (1 - Math.sin( s * Math.PI / 180 )) * 10;
        }else
        {
            xSize = Math.sin( (s-90) * Math.PI / 180 ) * 10;
        }
        
        graphics.clear();
        this.graphics.beginFill( 0xFF0000 );
        this.graphics.lineStyle( 5, 0xFF8800 );
        this.graphics.moveTo( cos0 * (20+xSize), sin0 * 20 );
        this.graphics.lineTo( cos120 * (20+xSize), sin120 * 20 );
        this.graphics.lineTo( cos240 * (20+xSize), sin240 * 20 );
        this.graphics.endFill();
        
        
        _step+=2;
    }
    
}
