/**
 * Copyright bruno.imbrizi ( http://wonderfl.net/user/bruno.imbrizi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yTea
 */

// forked from bruno.imbrizi's Tornado
// @author Bruno Imbrizi http://brunoimbrizi.com
package  
{
    import com.bit101.components.CheckBox;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    public class Tornado3 extends Sprite 
    {
        private var _anchors                    :Vector.<Anchor> = new Vector.<Anchor>();
        private var _anchor                        :Anchor;
        private var _bmp                        :Bitmap;
        private var _bmpData                    :BitmapData;
        private var _spriteP                    :Sprite;
        private var _spriteA                    :Sprite;
        private var _start                        :Particle;
        private var _particle                    :Particle;
        
        private var _checkBoxAnchor                :CheckBox;
        private var _checkBoxBlur                :CheckBox;
        private var _checkBoxSpeed                :CheckBox;
        
        private var _fl                            :int = 1000;
        private var _ct                            :ColorTransform = new ColorTransform(1, 1, 1, 1, 5, 5, 5);
        private var _down                        :Boolean;
        
        public static const TORNADO_HEIGHT        :int = 600;
        
        
        public function Tornado3() 
        {
            initSprite();
            initBitmap();
            initAnchors();
            initControls();
            initListeners();
        }
        
        
        private function initSprite():void 
        {
            _spriteP = new Sprite();
            addChild(_spriteP);
            
            _spriteA = new Sprite();
            _spriteA.visible = false;
        }
        
        
        private function initBitmap():void 
        {
            _bmpData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFFFF);
            
            _bmp = new Bitmap(_bmpData);
            addChild(_bmp);
            
            addChild(_spriteA);
        }
        
        
        private function initAnchors():void 
        {
            var a:Anchor;
            
            for (var i:int = 0; i < 4; i++) 
            {
                a = new Anchor(int(stage.stageWidth * .5 + Math.random() * 100 - 50), int(stage.stageHeight / 3 * i));
                _spriteA.addChild(a);
                _anchors.push(a);
            }
        }
        
        
        private function initControls():void 
        {
            _checkBoxAnchor = new CheckBox(this, 10, stage.stageHeight - 20, "show anchors", function():void
            {
                _spriteA.visible = _checkBoxAnchor.selected;
            } );
            
            _checkBoxBlur = new CheckBox(this, 10, stage.stageHeight - 40, "add blur");
            _checkBoxBlur.selected = true;
            
            _checkBoxSpeed = new CheckBox(this, 10, stage.stageHeight - 60, "faster at the bottom");
        }
        
        
        private function createParticle():void 
        {
            var p:Particle;
            var py:Number;
            
            p = new Particle();
            p.x = stage.stageWidth * .5 - mouseX;
            p.y = mouseY;
            py = TORNADO_HEIGHT - p.y;
            p.r = (Math.sqrt(1 - (py /= TORNADO_HEIGHT) * py) - 1) * -300;
            p.r += Math.random() * 20;
            p.angle = Math.PI * .5;
            p.life = Math.random() * 2000;
            
            if (!_start) _start = p;
            else
            {
                p.next = _start.next;
                _start.next = p;
            }
        }
        
        
        private function initListeners():void 
        {
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp, false, 0, true);
        }
        
        
        private function onEnterFrame(e:Event):void 
        {
            if (_down) createParticle();
            
            var cx:int = stage.stageWidth * .5;
            var cy:int = stage.stageHeight * .5;
            var cz:int = 0;
            var dx:Number;
            var dz:Number;
            var d:Number;
            var r:Number;
            var px:Number;
            var py:Number;
            var scale:Number;
            var p:Particle;
            var a:Anchor;
            var a0:Anchor;
            var a1:Anchor;
            var aLength:int = _anchors.length;
            var i:int;
            
            _bmpData.lock();
            
            _spriteP.graphics.clear();
            _spriteP.graphics.lineStyle(0, 0x666666);
            
            _particle = _start;
            
            while (_particle)
            {
                p = _particle;
                
                if (_particle.next && _particle.next.age > _particle.next.life) 
                {
                    _particle.next = _particle.next.next;
                }
                
                d = Math.sqrt(p.x * p.x + p.z * p.z);
                if (d < p.r) d = p.r - 2;
                else d -= 2;
                
                p.x = Math.sin(p.angle) * d;
                p.z = Math.cos(p.angle) * d;
                
                // linear anchors
                /*
                i = 0;
                for each (a in _anchors)
                {
                    if (p.y < a.y) break;
                    i++;
                }
                
                a0 = (i) ? _anchors[i - 1] : _anchors[i];
                if (i < aLength) a1 = _anchors[i]
                else
                {
                    _particle = _particle.next;
                    continue;
                }
                cx = a0.x + (a1.x - a0.x) * ((p.y - a0.y) / (a1.y - a0.y));
                */
                
                // bezier anchors
                var t:Number = (p.y - _anchors[0].y) / (_anchors[3].y - _anchors[0].y);
                cx = (t * t * (_anchors[3].x - _anchors[0].x) + 3 * (1 - t) * (t * (_anchors[2].x - _anchors[0].x) + (1 - t) * (_anchors[1].x - _anchors[0].x))) * t + _anchors[0].x;
                
                scale = _fl / (_fl + p.z);
                px = p.x * scale + cx;
                py = p.y * scale;
                
                if (_checkBoxSpeed.selected) p.angle += Math.min(10 / d, .4);
                else p.angle += .1;
                p.age++;
                
                if (p.ox)
                {
                    _spriteP.graphics.moveTo(px, py);
                    _spriteP.graphics.lineTo(p.ox, p.oy);
                }
                
                p.ox = px;
                p.oy = py;
                
                _particle = _particle.next;
            }
            
            if (_checkBoxBlur.selected) _bmpData.applyFilter(_bmpData, _bmpData.rect, new Point(), new BlurFilter(5, 0));
            _bmpData.colorTransform(_bmpData.rect, _ct);
            _bmpData.draw(_spriteP);
            _bmpData.unlock();
        }
        
        
        private function onMouseDown(e:MouseEvent):void 
        {
            if (e.target is Anchor)
            {
                _anchor = e.target as Anchor;
                _ct = new ColorTransform(1, 1, 1, 1, 25, 25, 25);
                stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove, false, 0, true);
            }
            else if (!(e.target is CheckBox)) _down = true;
        }
        
        
        private function onMouseUp(e:MouseEvent):void 
        {
            _down = false;
            
            if (_anchor)
            {
                _anchor = null;
                _ct = new ColorTransform(1, 1, 1, 1, 5, 5, 5);
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            }
        }
        
        
        private function onMouseMove(e:MouseEvent):void 
        {
            _anchor.x = e.stageX;
            _anchor.y = e.stageY;
        }
    }

}

class Particle
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    public var ox:Number;
    public var oy:Number;
    public var age:int = 0;
    public var life:int;
    public var angle:Number;
    public var r:Number;
    public var next:Particle;
}

import com.greensock.TweenLite;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.MouseEvent;

class Anchor extends Sprite
{
    private var _backCircle:Shape;
    private var _frontCircle:Shape;
    
    public function Anchor(x:Number, y:Number)
    {
        this.x = x;
        this.y = y;
        
        _backCircle = new Shape();
        _backCircle.graphics.beginFill(0xFF9797, .4)
        _backCircle.graphics.drawCircle(0, 0, 12);
        _backCircle.graphics.endFill();
        addChild(_backCircle);
        
        _frontCircle = new Shape();
        _frontCircle.graphics.beginFill(0x660000, .5)
        _frontCircle.graphics.drawCircle(0, 0, 2);
        _frontCircle.graphics.endFill();
        addChild(_frontCircle);
        
        buttonMode = true;
        addEventListener(MouseEvent.ROLL_OVER, onRollOver, false, 0, true);
        addEventListener(MouseEvent.ROLL_OUT, onRollOut, false, 0, true);
    }
    
    private function onRollOver(e:MouseEvent):void 
    {
        TweenLite.to(_backCircle, .2, { scaleX:1.3, scaleY:1.3 } );
    }
    
    private function onRollOut(e:MouseEvent):void 
    {
        TweenLite.to(_backCircle, .2, { scaleX:1, scaleY:1 } );
    }
}