/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ySgQ
 */

// forked from Thy's 3D galaxy collision
// forked from Thy's forked from: 3D cube
// forked from Thy's 3D cube
package 
{
    import flash.geom.Rectangle;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    // 
    /* @author Thy
     * 2 galaxy colision, all by gravity.
    */
    public class Main extends Sprite
    {
        
        private var
        W:Number = 465, H:Number = 465;
        
        private var // 3D cene objects
        space:Ob = new Ob(),
        camera:Cam = new Cam();
        
        private const // const degree to radians proportion
        rads:Number = Math.PI / 180;
        
        private var
        data:BitmapData = new BitmapData(stage.stageWidth, 
            stage.stageHeight, false, 0),
        bm:Bitmap = new Bitmap(data, "auto", true);
        
        private var // mouse
        mouseDown:Boolean,
        ox:Number = mouseX, oy:Number = mouseY,
        pitchSpeed:Number = 0, yawSpeed:Number = 0;
        
        private var
        blur:BlurFilter = new BlurFilter(8,8),
        rect:Rectangle = data.rect,
        point:Point = new Point();

        public function Main():void
        {
            // camera settings
            camera.z = -10;
            camera.focal = 50;
            camera.offsetX = stage.stageWidth*.5;
            camera.offsetY = stage.stageHeight*.5;
            
            // box
            this.addChild(bm);
            
            // space.points.push( new P(0,0,0)); p.vx, p.vy, p.vz
            
            // event
            stage.addEventListener(Event.ENTER_FRAME, ef);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, md);
            stage.addEventListener(MouseEvent.MOUSE_UP, mu);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mm);
            
            //var p:P = new P();
            //p.vx = 5;
            //space.points.push(p);
            //p = new P();
            //p.vy = 5;
            //space.points.push(p);
            //p = new P();
            //p.vz = 5;
            //space.points.push(p);
            
            var i:int = -1, l:int = 1000, p:P = new P();
            p.color = 0xFFFFFF;
            space.points.push(p);
            
            while(++i < l)
            {
                p = new P(
                    (Math.random()- .5) * 300,
                    (Math.random() - .5)* 300, 
                    (Math.random() - .5) * 300);
                p.vx = (Math.random() - .5) * 100;
                p.vy = (Math.random() - .5) * 100;
                p.vz = (Math.random() - .5) * 100;
                space.points.push(p);    
            }
            
            space.points[0].mass = 1000000;
            
        }
        
        private function md(e:MouseEvent):void
        {
            mouseDown = true;
        }
        
        private function mu(e:MouseEvent):void
        {
            mouseDown = false;
        }
        
        private function mm(e:MouseEvent):void
        {
            if (mouseDown)
            {
                pitchSpeed += (mouseY - oy) / H * rads * 6;
                yawSpeed += (mouseX - ox) / W * rads * 6;
            }
            ox = mouseX;
            oy = mouseY;
        }

        
        private function ef(e:Event):void
        {
            
            // rotate the object box, NOT the camera
            space.pitch += (pitchSpeed *= .9);
            space.yaw += (yawSpeed *= .9);
            
            
            // move the 3D galaxy
            move3D(space);
            // do 3D to 2D conversion
            get2D(space, camera);
            // draw the especific galaxy
            data.lock();
            //data.fillRect(data.rect, 0);
            data.applyFilter(data, rect, point, blur);
            draw(space, camera, data);
            data.unlock();
        }
        
        
        private function move3D(ob:Ob = null):void
        {
            var i:int = -1, j:int, l:int = ob.points.length;
            var p:P, p2:P;
            var d:Number, dx:Number, dy:Number, dz:Number, v:Number, v2:Number;
            while(++i < l)
            {
                p = ob.points[i];
                j = i;
                while(++j < l)
                {
                    p2 = ob.points[j];
                    
                    d = (dx = (p.x - p2.x)) * dx + 
                        (dy = (p.y - p2.y)) * dy + 
                        (dz = (p.z - p2.z)) * dz;
                        
                    if(d * d < 4)
                    {
                        continue;
                    }

                    
                    v = p2.mass / (d);
                    v2 = p.mass / (d);
                    d = Math.sqrt(d);
                    
                    dx /= d;
                    dy /= d;
                    dz /= d;
                    
                    p.vx -= v * dx;
                    p.vy -= v * dy;
                    p.vz -= v * dz;
                    
                    p2.vx += v2 * dx;
                    p2.vy += v2 * dy;
                    p2.vz += v2 * dz;
                }
            }
            i = -1;
            while (++i < l)
            {
                p = ob.points[i];
                p.x += p.vx;
                p.y += p.vy;
                p.z += p.vz;
            }
            
        }

        
        private function get2D(ob:Ob = null, cam:Cam = null):void
        {
            // get the 2D coord of all points, incluing the rotation
            var i:int = -1, l:int = ob.points.length, p:P;
            var a1:Number, a2:Number, b1:Number, b2:Number,
                c1:Number, c2:Number;
            var X:Number, Y:Number, Z:Number,
                r1:Number = ob.pitch, 
                r2:Number = ob.yaw,
                r3:Number = ob.roll;
            var sr1:Number = Math.sin(r1),
                cr1:Number = Math.cos(r1),
                sr2:Number = Math.sin(r2),
                cr2:Number = Math.cos(r2),
                sr3:Number = Math.sin(r3),
                cr3:Number = Math.cos(r3);
                
            while(++i < l)
            {
                p = ob.points[i];
                X = p.x - cam.x;
                Y = p.y - cam.y;
                Z = p.z - cam.z;
                
                a1 = cr1*p.y - sr1*p.z; // pitch (x)
                a2 = sr1*p.y + cr1*p.z;
                
                b1 = cr2*a2 - sr2*p.x; // yaw (y)
                b2 = sr2*a2 + cr2*p.x;
                
                c1 = cr3*b2 - sr3*a1; // roll (z)
                c2 = sr3*b2 + cr3*a1;
                
                if(b1 > 0 || true)
                {
                    p.scale = cam.focal / (cam.focal + b1)
                    p.X = c1 * .02  /*p.scale*/   + cam.offsetX;
                    p.Y = c2 * .02  /*p.scale*/   + cam.offsetY;
                } else
                {
                    p.scale = cam.focal / (cam.focal + b1)
                    p.X = 0;
                    p.Y = 0;
                }
            }
        }
        
        private function draw(ob:Ob = null, cam:Cam = null, 
            d:BitmapData = null):void
        {
            // draw the especific galaxy
            var i:int = -1, l:int = ob.points.length;
            var p:P;
            while(++i < l)
            {
                p = ob.points[i];
                data.setPixel(p.X, p.Y, p.color);
            }

        }
    }
}


import flash.display.Sprite;

class P{
    public var // position
    x:Number = 0, y:Number = 0, z:Number = 0,
    X:Number = 0, Y:Number = 0, 
    scale:Number = 0, color:uint = 0xFFFFFF;
    
    public var // velocity
    vx:Number = 0, vy:Number = 0, 
        vz:Number = 0;
    
    public var // each point will be an star
    mass:int = 30;
    
    public function P(x:Number = 0,  y:Number = 0, z:Number = 0)
    {
        this.x = x; this.y = y; this.z = z;
    }
}

class Ob {
    public var 
    points:Vector.<P> = new Vector.<P>(),
    pitch:Number = 0, yaw:Number = 0, roll:Number = 0; 
}

class Cam{
    
    public var
    x:Number = 0, y:Number = 0, z:Number = 0,
    // I STILL DONT UNDERSTAND THE *CAMERA* ROTATIONS, only the *OBJECT* ones
    //pitch:Number = 0, yaw:Number = 0, roll:Number = 0, //
    focal:Number = 0, offsetX:Number = 0, offsetY:Number = 0;
}
