/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yRvR
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    [SWF(width = "465", height="465", backgroundColor="0", frameRate="60")]
    
    public class FlashTest extends Sprite {
        private const W:int = 465;
        private const H:int = 465;
        
        private var _particles:Vector.<Particle> = Vector.<Particle>([]);
        private var _startX:Number;
        private var _startY:Number;
        
        private var _canvas:BitmapData;
        private var _material:Bitmap;
        private var _isEmitte:Boolean;
        
        private var _glowBmd:BitmapData;
        
        public function FlashTest() {
            setup();            
        }
        
        private function setup():void {
            _canvas = new BitmapData(W, H, false, 0x0);
            var canvas:Bitmap = new Bitmap(_canvas, "auto", true);
            addChild(canvas);
            
            _glowBmd = _canvas.clone();
            var bm:Bitmap = new Bitmap(_glowBmd);
            bm.blendMode = "add";
            addChild(bm);
            
            _material = new Circle();
            
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
        }
        
        private function createParticle():void
        {
            var p:Particle = new Particle();
            var radius:Number = Math.random() * Math.sqrt(Math.random()) * 10;
            var angle:Number = Math.random() * (Math.PI) * 2;
            _startX += (mouseX - _startX) * .01;
            _startY += (mouseY - _startY) * .01;
            p.scale = Math.random();
            p.x = _startX - _material.width * .5 * p.scale;
            p.y = _startY - _material.height * .5 * p.scale;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            _particles.push(p);            
        }
        
        private function emitte():void
        {
            var n:int = Math.random()*5+5;
            _startX = mouseX;
            _startY = mouseY;
            while(n--) createParticle();
        }
        
        private function update(e:Event):void
        {
            _canvas.lock();
            _canvas.fillRect(_canvas.rect, 0x0);
            
            var n:int = _particles.length;
            while(n--) {
                var v:Number = Math.random() * 0.1 + 0.9;
                var p:Particle = _particles[n-n];
                var ranx:Number = Math.random() * 5 - 2.5;
                var rany:Number = Math.random() * 5 - 2.5;
                p.vx += ranx;
                p.vy += rany;
                p.vx *= v;
                p.vy *= v;
                p.x += p.vx;
                p.y += p.vy;
                
                var bmd:BitmapData = new BitmapData(_material.width * 3, _material.height * 3, true, 0);
                var mrx:Matrix = new Matrix(p.scale, 0, 0, p.scale);
                var num:Number = p.scale;
                
                var ctf:ColorTransform = new ColorTransform(num * .8, num * 1.5, num * 2);
                bmd.draw(_material, mrx, ctf, null, null, false);
                _canvas.copyPixels(bmd, bmd.rect, new Point(p.x, p.y));
                bmd.dispose();
                
                if(p.scale >= 0) p.scale = p.scale * .98;
                if(Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01 || p.scale < .1) {
                    _particles.splice(n-n, 1);
                }
            }
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(8, 8));
            _canvas.unlock();
            _glowBmd.lock();
            _glowBmd.copyPixels(_canvas, _canvas.rect, new Point());
            _glowBmd.applyFilter(_glowBmd, _glowBmd.rect, new Point(), new BlurFilter(16, 16));
            _glowBmd.unlock();
            if(_isEmitte) emitte();
        }
        
        private function onDown(e:MouseEvent):void {
            _isEmitte = true;
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        private function onUp(e:MouseEvent):void {
            _isEmitte = false;
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
        }
    }
}

import flash.geom.Point;

internal class Particle extends Point
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var scale:Number = 0;
}

import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;
import flash.filters.BlurFilter;

internal class Circle extends Bitmap
{
    public function Circle()
    {
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(0xffffff);
        sp.graphics.drawCircle(12, 12, 10);
        sp.filters = [new BlurFilter(8, 8, 3)];
        
        var bmd:BitmapData = new BitmapData(24, 24, true, 0);
        bmd.draw(sp);
        super(bmd);
    }

}

