/**
 * Copyright murderdeathkitty ( http://wonderfl.net/user/murderdeathkitty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yRtb
 */

// forked from murderdeathkitty's SoundFork
// forked from murderdeathkitty's flash on 2009-7-17
package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.net.*;
    public class SoundFork extends Sprite {
        
        private var sound: Sound;
        private var channel: SoundChannel;
        private var position: Number = 0;
        private var lastPhaseJump: Number = 0;
        private var lastPhaseRamp: Number = 0;
        private var lastFrequency: Number = 0;
        
        public function SoundFork(): void
        {
            addEventListener(Event.ADDED_TO_STAGE, start);
            addEventListener(Event.REMOVED_FROM_STAGE, stop);
        }
        public function start(e: Event = null): void
        {
            var loader: Loader = new Loader();
            addChild(loader);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, function(): void{});
            loader.load(new URLRequest("http://farm1.static.flickr.com/28/39449485_e2fdeb48e1.jpg"));

            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, generate);
            channel = sound.play();
        }
        public function stop(e: Event = null): void
        {
            if(channel != null){
                channel.stop();
                channel = null;
            }
        }
        
        //replace this with your own sound!!!
        //output is 44100 hz, stereo. values between -1 and 1
        private function generate(e: SampleDataEvent): void
        {
            var data: ByteArray = e.data;
            var i: Number;
            var output: Number;
            var newFrequency: Number = Math.random() < 0.5?Math.random()*0.5 + 0.05:lastFrequency;
            var region: ByteArray = Generate.region(position, 5000);
            var frequencyJump: ByteArray = Generate.linear(lastFrequency*0.1, newFrequency*0.1, region);
            var frequencyRamp: ByteArray = Generate.constant(newFrequency+0.1, region);
            var phaseJump: ByteArray = Generate.phase(lastPhaseJump, frequencyJump, region);
            var phaseRamp: ByteArray = Generate.phase(lastPhaseRamp, frequencyRamp, region);
            var oscillateJump: ByteArray;
            if(Math.random() < 0.5) oscillateJump = Generate.sin(phaseJump);
            else oscillateJump = Generate.saw(phaseJump);
            var oscillateRamp: ByteArray;
            if(Math.random() < 0.5) oscillateRamp = Generate.sin(phaseRamp);
            else oscillateRamp = Generate.sqr(phaseRamp)
            var mix: ByteArray = Generate.mul(oscillateJump, oscillateRamp);
            mix.position = 0;
            oscillateJump.position = 0;
            oscillateRamp.position = 0;
            for(i = 0; i < 5000; ++i){
                output = mix.readFloat()
                data.writeFloat(output);//left
                data.writeFloat(output);//right
            }
            lastPhaseJump = Generate.getSample(-1, phaseJump);
            lastPhaseRamp = Generate.getSample(-1, phaseRamp);
            lastFrequency = newFrequency;
            position += 5000;
        }
    }
}
class Generate{
    import flash.utils.*;
    public static function region(start: Number, length: Number): ByteArray
    {
        var result: ByteArray = new ByteArray();
        while(--length >= 0){
            result.writeFloat(start++);
        }
        return result;
    }
    public static function constant(value: Number, region: ByteArray): ByteArray
    {
        var result: ByteArray = new ByteArray();
        var i: Number = region.length/4;
        while(--i>=0){
            result.writeFloat(value);
        }
        return result;
    }
    public static function linear(start: Number, end: Number, region: ByteArray): ByteArray
    {
        var result: ByteArray = new ByteArray();
        var i: Number = region.length/4;
        var delta: Number = (end - start)/(i-1);//must finish ON the end value!
        while(--i >= 0){
            result.writeFloat(start);
            start += delta;
        }
        return result;
    }
    public static function phase(initial: Number, frequency: ByteArray, region: ByteArray): ByteArray
    {
        frequency.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = region.length/4;
        while(--i>=0){
            initial += frequency.readFloat();
            result.writeFloat(initial);
        }
        return result;
    }
    public static function sin(phase: ByteArray): ByteArray
    {
        phase.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = phase.length/4;
        while(--i>=0){
            result.writeFloat(Math.sin(phase.readFloat()));
        }
        return result;
    }
    public static function saw(phase: ByteArray): ByteArray
    {
        phase.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = phase.length/4;
        while(--i>=0){
            result.writeFloat((phase.readFloat()%1)*2 - 1);
        }
        return result;
    }
    public static function sqr(phase: ByteArray): ByteArray
    {
        phase.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = phase.length/4;
        while(--i>=0){
            result.writeFloat((phase.readFloat()%1)<0.5?-1:1);
        }
        return result;
    }
    public static function add(a: ByteArray, b: ByteArray): ByteArray
    {
        a.position = 0;
        b.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = a.length/4;
        while(--i>=0){
            result.writeFloat(a.readFloat() + b.readFloat());
        }
        return result;
    }
    public static function mul(a: ByteArray, b: ByteArray): ByteArray
    {
        a.position = 0;
        b.position = 0;
        var result: ByteArray = new ByteArray();
        var i: Number = a.length/4;
        while(--i>=0){
            result.writeFloat(a.readFloat()*b.readFloat());
        }
        return result;
    }
    public static function getSample(index: Number, samples: ByteArray): Number
    {
        var len: Number = samples.length/4;
        if(index < 0) index = index+len;
        samples.position = index*4;
        return samples.readFloat();
    }
}