/**
 * Copyright 0954321982 ( http://wonderfl.net/user/0954321982 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yRkK
 */

// forked from lizhi's fire particle
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    /**
     * ...
     * @author lizhi http://matrix3d.github.io/
     */
[SWF(frameRate='60')]
    public class TestFire extends Sprite
    {
        private var parts:Vector.<BitmapData>=new Vector.<BitmapData>;
        private var particles:Vector.<Particle> = new Vector.<Particle>;
        public function TestFire() 
        {
            var c:int = 20;
            while (c-->0) {
                parts.push(createShapePart());
            }
            c = 40;
            while (c-->0) {
                var p:Particle = new Particle;
                p.shape = new Shape;
                var bmd:BitmapData = parts[int(parts.length * Math.random())];
                p.shape.graphics.beginBitmapFill(bmd, new Matrix(1, 0, 0, 1, -30, -30));
                p.shape.graphics.drawRect( -30, -30, 60, 60);
                addChild(p.shape);
                particles.push(p);
                //p.shape.blendMode = BlendMode.ADD;
            }
            addEventListener(Event.ENTER_FRAME, enterFrame);
            addChild(new Stats);
        }
        
        private function enterFrame(e:Event):void 
        {
            for each(var p:Particle in particles) {
                if (p.life<0) {
                    p.reset(mouseX, mouseY);
                    addChild(p.shape);
                }
                p.shape.x += p.v.x;
                p.shape.y += p.v.y;
                
                p.shape.scaleX *= p.scaleMul.x;
                p.shape.scaleY *= p.scaleMul.y;
                
                p.shape.rotation += p.rotation;
                
                p.colorT.alphaMultiplier *= p.colorMul.x;
                p.colorT.redMultiplier *= p.colorMul.y;
                p.colorT.greenMultiplier *= p.colorMul.z;
                p.colorT.blueMultiplier *= p.colorMul.w;
                p.shape.transform.colorTransform = p.colorT;
                p.life--;
            }
        }
        
        
        private function createShapePart():BitmapData {
            var bmd:BitmapData = new BitmapData(256, 256, true, 0);
            bmd.perlinNoise(40,40, 3, 100*Math.random(), false, true);
            
            var shape:Shape = new Shape;
            shape.graphics.beginFill(0xffffff);
            shape.graphics.drawCircle(30, 30, 15);
            
            shape.filters = [new BlurFilter(10, 10, 3), new DisplacementMapFilter(bmd, null, BitmapDataChannel.RED, BitmapDataChannel.GREEN, 40, 40, DisplacementMapFilterMode.COLOR)];
            
            var bmd2:BitmapData = new BitmapData(60, 60, true, 0);
            bmd2.draw(shape);
            
            return bmd2;
        }
    }
}
import flash.geom.ColorTransform;
import flash.geom.Vector3D;

class Particle {
    public var shape:flash.display.Shape;
    public var v:flash.geom.Point = new flash.geom.Point;
    public var scaleMul:flash.geom.Point = new flash.geom.Point;
    public var rotation:Number = 0;
    public var colorMul:Vector3D = new Vector3D;
    public var colorT:ColorTransform = new ColorTransform;
    public var life:int=-1;
    public function reset(mouseX:Number,mouseY:Number):void {
        v.x = 0;
        v.y =-1 -1 * Math.random();
        shape.x = mouseX+(Math.random()-.5)*20;
        shape.y = mouseY + (Math.random() - .5) * 10;
        
        scaleMul.x = scaleMul.y = Math.random()*.05+.95;
        shape.scaleX = shape.scaleY = 1;
        
        rotation=10*(Math.random()-.5)
        shape.rotation = 0;
        
        colorMul.x = .999 +.001* Math.random();
        colorMul.y = .9 + .1*Math.random();
        colorMul.z = .9 + .1*Math.random();
        colorMul.w = .9 + .1*Math.random();
        colorT.alphaMultiplier = .7;
        colorT.redMultiplier = (0xd5-50*Math.random()) / 0xff; //0xD5C21C
        colorT.greenMultiplier = (0xc2-50*Math.random()) / 0xff;
        colorT.blueMultiplier = (0x1c-50*Math.random())/0xff;
        life = 100*Math.random();
    }
}