/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yRBP
 */

package {
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var pic:Bitmap;
        public var map:BitmapData;
        
        public var px:Number = 4;
        public var py:Number = 4;
        public var vx:Number = 0;
        public var vy:Number = 0;
        
        public var mwidth:int = 16;
        public var mheight:int = 16;
        public var colMap:Array =
        [ 1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,0,0, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,0,1, 1,1,1,1, 1,1,1,1,
          1,1,1,1, 0,0,0,1, 1,1,1,1, 1,1,1,1,
         
          1,1,0,0, 0,0,0,0, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,0,0, 0,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,0,1, 0,0,1,1, 1,1,1,1,
          1,1,1,1, 0,0,0,0, 0,0,1,1, 1,1,1,1,

          1,1,0,0, 0,0,0,0, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,1,1, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,1,1,1, 1,1,1,1, 1,1,1,1,
          1,1,1,1, 1,1,1,0, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,0,0, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,0,1,1, 1,1,1,1, 1,1,1,1,
          1,1,0,0, 0,1,1,1, 1,1,1,1, 1,1,1,1,
          1,1,1,1, 1,1,1,0, 1,1,1,1, 1,1,1,1
          
          
        ];
        
        
        public function FlashTest() {
            
            pic = new Bitmap(new BitmapData(128,96,false,0));
            addChild(pic);
            pic.scaleX = 8;
            pic.scaleY = 8;
            
            map = new BitmapData(128,128,false, 0);
            
            var i:int;
            var k:int;
            var yt:int;
            
            for (i = 0; i < mheight; i++)
            {
                yt = i * mwidth;
                for (k = 0; k < mwidth; k++)
                {
                    if (colMap[yt+k] == 1)
                    {
                        map.setPixel(k,i, 0xFFffFF);
                     }
                }//nextk
            }//nexti
            
            pic.bitmapData.draw(map);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function kdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function kup(e:KeyboardEvent):void {vecKey[e.keyCode] = false; }
        
        public var wait:int = 0;
        
        public function onEnter(e:Event):void
        {
            wait +=1;
            
            if (wait < 4) { return; }
            wait = 0;
            
            pic.bitmapData.lock();
                pic.bitmapData.draw(map);
                pic.bitmapData.setPixel(px, py, 0xFF0000);
            
            pic.bitmapData.unlock();
            
          
            
            vy += 0.2;
             if (vy >= 2) { vy = 2; }
            
            if (vy >= 0  && map.getPixel(px,Math.floor(py + 1)) > 0
            || map.getPixel(px,Math.floor(py + vy)) > 0
            )
            { vy = 0;}
            
            py += vy;
            
        }//onenter
        
    }//classend
}