/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yQYu
 */






package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    public class TestVehicle extends Sprite
    {
        public var vs:Vector.<Vehicle> = new Vector.<Vehicle>;
        public function TestVehicle() 
        {
            var c:int = 10;
            while (c-->0) {
                var v:Vehicle = new Vehicle;
                v.p.x = 400 * Math.random();
                v.p.y = 400 * Math.random();
                v.v.x = (Math.random() - .5) * 4;
                v.v.y = (Math.random() - .5) * 4;
                v.maxSpeed = (Math.random() + .5) * 6;
                v.r = 5 * (Math.random()+.5);
                vs.push(v);
            }
            vs[0].color = 0xff0000;
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(e:Event):void 
        {
            graphics.clear();
            for (var i:int = 0; i < vs.length;i++ ) {
                var v:Vehicle = vs[i];
                graphics.lineStyle(0,v.color);
                if (i == 0) {
                    v.p.x = mouseX;
                    v.p.y = mouseY;
                    var my:Vehicle = v;
                }else {
                    var desiredVelocity:Vector3D = my.p.subtract(v.p);
                    var d:Number = desiredVelocity.length-my.r-v.r;
                    desiredVelocity.normalize();
                    desiredVelocity.scaleBy(Math.min(d,v.maxSpeed));
                    v.f = desiredVelocity.subtract(v.v);  
                    for (var j:int = 1; j < vs.length;j++ ) {
                        var v2:Vehicle = vs[j];
                        var desiredVelocity2:Vector3D = v2.p.subtract(v.p);
                        var d2:Number = desiredVelocity2.length;
                        if (d2<(v2.r+v.r)) {
                            desiredVelocity2.normalize();
                            desiredVelocity2.scaleBy(v.maxSpeed);
                            desiredVelocity2 = v.v.subtract(desiredVelocity2);
                            desiredVelocity2.scaleBy(.5/vs.length);
                            v.f = v.f.add(desiredVelocity2);
                        }
                    }
                    
                    v.v = v.v.add(v.f);
                    if (v.v.length>v.maxSpeed) {
                        v.v.normalize();
                        v.v.scaleBy(v.maxSpeed);
                    }
                    v.p = v.p.add(v.v);
                    if (v.p.x > 400) v.p.x = 400;
                    if (v.p.y > 400) v.p.y = 400;
                    if (v.p.x < 0) v.p.x = 0;
                    if (v.p.y < 0) v.p.y = 0;
                }
                
                graphics.drawCircle(v.p.x, v.p.y, v.r);
            }
        }
        
    }
}



import flash.geom.Vector3D;
class Vehicle 
{
    public var color:int = 0;
    public var maxSpeed:Number = 5;
    public var r:Number = 2;
    public var p:Vector3D=new Vector3D;
    public var v:Vector3D=new Vector3D;
    public var f:Vector3D=new Vector3D;
}