/**
 * Copyright wonderwhyer ( http://wonderfl.net/user/wonderwhyer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yPPS
 */

package
{
    import flash.filters.DropShadowFilter;
    import flash.text.TextFieldType;
    import flash.text.TextField;
    import flash.display.LoaderInfo;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.DisplayObject;
    
    [SWF(backgroundColor=0xeeeeee, width=465, height=465)]
    public class MyClass extends Sprite
    {

        private var myPushButton:PushButton;
        private var myText:TextField;
        private var loader:Loader;
        private var image:DisplayObject;
        private var log:TextField;
        
        public function MyClass()
        {
            myPushButton = new PushButton(this, 360, 5, "LoadImage",OnClick);
            myText = new TextField();
            myText.border = true;
            myText.background=true;
            myText.filters = [new DropShadowFilter(2,45,0,1,4,4,0.3,1,true)];
            myText.type = TextFieldType.INPUT;
            myText.height = 20
            myText.width = 350;
            myText.text = "http://www.adobe.com/images/shared/product_logos/159x120/159x120_flash.gif";
            myText.x = 5;
            myText.y = 5;
            addChild(myText);
            log = new TextField();
            addChild(log);
            log.border = true;
            log.background=true;
            log.filters = [new DropShadowFilter(2,45,0,1,4,4,0.3,1,true)];
            log.width = 100;
            log.height = 300;
            log.x = 360;
            log.y=50;
            log.border=true;
        }
        
        public function OnClick(e:Event):void
        {
            loader = new Loader();
            loader.load(new URLRequest(myText.text));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,complete1);
            log.appendText("Click\n");
        }
        
        public function complete1(e:Event):void
        {
            log.appendText("Loaded\n");
            var info:LoaderInfo = e.currentTarget as LoaderInfo;
            //file actually loaded
            try
            {
                //but sandbox violation is only checked when we are trying to access what we loaded
                setImage(info.content);
            }
            catch(e:Error)
            {
                log.appendText("Error\n");
                //weirdly access to loaded bytes is allowed so we just load them again, and this time no sandbox error
                loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE,complete1);
                loader.loadBytes(info.bytes);
            }
        }
        
        public function setImage(newImage:DisplayObject):void
        {
            if(image)
                removeChild(image);
            image = newImage;
            image.x = 50;
            image.y=50;
            addChild(image);
        }

    }
}
