/**
 * Copyright pseudoDust ( http://wonderfl.net/user/pseudoDust )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yPMy
 */

// forked from pseudoDust's forked from: lava lamp effect
// forked from pseudoDust's lava lamp effect
package {
    import flash.display.PixelSnapping;
    import flash.utils.getTimer;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.geom.Matrix;
    import flash.display.GradientType;
    
    import flash.display.Sprite;
    [SWF(backgroundColor = "0x888888", frameRate = "30")]
    public class Blobs extends Sprite {
        private const GRADIENT_SIZE : Number = 200;
        private const PARTICLE_COUNT : Number = 40;
        
        private var gradient : Sprite;
        private var bmd:BitmapData;
        private var bm:Bitmap;
        private var particles:Array;
        private var lastT:Number
        
        { 
            Wonderfl.capture_delay( 10 );
        }
        
        public function Blobs() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            initGradient();
            initBitmap();
            initParticles();
            lastT = getTimer();
            addEventListener(Event.ENTER_FRAME,frameHandler)
        }
         
        private function initGradient() : void {
            gradient = new Sprite();
            var m : Matrix = new Matrix();
            m.createGradientBox(GRADIENT_SIZE,GRADIENT_SIZE,0,-GRADIENT_SIZE*0.5,-GRADIENT_SIZE*0.5);
            //*
            gradient.graphics.beginGradientFill(GradientType.RADIAL,[0xffffff,0xffffff],[1,0],[0,255],m);
            gradient.graphics.drawRect(-GRADIENT_SIZE*0.5,-GRADIENT_SIZE*0.5,GRADIENT_SIZE,GRADIENT_SIZE);
            gradient.graphics.endFill();
            /*/
            //gradient.graphics.beginFill(0xffffff);
            //gradient.graphics.drawCircle(0,0,10)
            //gradient.graphics.endFill();
            //*/
        }
        
        private function initBitmap() : void {
            bmd = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x888888);
            bm = new Bitmap(bmd);
            addChild(bm);
        }
        
        private function initParticles() : void {
            particles = new Array();
            for(var i : int = 0; i<PARTICLE_COUNT ; i++) {
                particles.push(new Particle(new Point(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight),
                                            new Point(Math.random()*200,Math.random()*200),
                                            bmd.rect));
            }

        }

        
        private function frameHandler(e : Event) : void {
            bmd.fillRect(bmd.rect,0);
            for(var i : int = 0; i<particles.length ; i++) {
                //var point : Point= new Point(100,100);
                var point : Point=particles[i].update((getTimer()-lastT)/1000);
                drawGradient(point.x,point.y,100);
                
            }
            lastT = getTimer();
            bmd.threshold(bmd,bmd.rect,new Point(),"<",0xfe000000,0,0xff000000,false);
            //bmd.threshold(bmd,bmd.rect,new Point(),">",0xce000000,0xffffffff,0xff000000,false);
        }
        
        private function drawGradient(cx:Number, cy:Number, r:Number) : void {
            var m : Matrix = new Matrix();
            m.createBox((r*2)/GRADIENT_SIZE,(r*2)/GRADIENT_SIZE,0,cx,cy)
            bmd.draw(gradient,m,null,BlendMode.LIGHTEN,null,true);
        }

    }
}

    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.geom.Matrix;
    import flash.display.GradientType;
class Particle {
    public var position:Point;
    public var velocity:Point;
    public var bounds:Rectangle;
    
    public function Particle(pos:Point,vel:Point,bou:Rectangle) {
        position = pos;
        velocity = vel;
        bounds = bou;
    }
    
    public function update(t:Number) : Point {
        var dp : Point=velocity.clone();
        dp.normalize(dp.length*t);
        position=position.add(dp);
        //*
        if(!bounds.containsPoint(position)) {
            if(position.x<bounds.left) {
                position.x=bounds.left-position.x;
                velocity.x=-velocity.x;
            }
            else if(position.x>bounds.right) {
                position.x=2*bounds.right-position.x;
                velocity.x=-velocity.x;
            }
            if(position.y<bounds.top) {
                position.y=bounds.top-position.y;
                velocity.y=-velocity.y;
            }
            else if(position.y>bounds.bottom) {
                position.y=2*bounds.bottom-position.y;
                velocity.y=-velocity.y;
            }
        }
        //*/
        return position;
    }
}