/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yOaX
 */

package {
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            deb = new TextField();
            deb.width=320;
            deb.height = 240;
            deb.textColor =0xFFffFF;
            deb.mouseEnabled = false;
            addChild(deb);
            
            obstMap = new BitmapData(465,465, false, 0);
            
            stage.quality= "LOW";
            
            var i:int;
            for (i = 0; i < 64; i++)
            {
              graphics.beginFill(0xffFFff,1);
              graphics.drawEllipse(Math.random()*465-64,350+Math.random()*129,8+Math.random()*128,5+Math.random()*128);
              graphics.endFill();  
            }//nexti
            obstMap.draw(this);
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function isWall(ax:Number,ay:Number):Boolean
        {
            if (ay >=465) {return true;}
            return obstMap.getPixel(ax,ay) > 0;
        }//iswall
        
        public function getHeight(ax:Number, ay:Number):Number
        {
          var i:int;
          for (i = 0; i < 16; i++)
          {
             if (isWall(ax,ay+i)) { return i; } 
          }//nexti
          return i;   
        }//getheight
        
        public var deb:TextField;
        
        
        public var cx:Number = 230;
        public var cy:Number = 230;
        public var vx:Number = 0;
        public var vy:Number = 0;
        
        public var obstMap:BitmapData;
        
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2,0); 
           
           graphics.beginBitmapFill(obstMap, null);
           graphics.drawRect(0,0,465,465);
           graphics.endFill();
           
           var i:int;
           for (i = 0; i < 16; i++) { update(); }
           
        }//onenter
        
        public function update():void
        {   
           var rad:Number;
           rad = 8;
           
           if (cx >= 465) {cx=0; cy=230;vx=0;vy=0;}
         
           
           vx = 1;
           vx = 0.4;
           
           vy += 0.2;
           
           if (isWall(cx,cy+rad)) {vy=0;}
           
           
           cx += vx;
           cy += vy;
           
           var kx:Number;
           kx = getHeight(cx,cy-rad);
           
           deb.text = ""+int(kx);
            
           if (kx < 16) { cy -= (16-kx);} 
            
           graphics.lineStyle(2,0xFF0000,0.4);
           graphics.drawCircle(cx,cy,rad);
            
            
           var rx:Number; var ry:Number;
           rx = getHeight(cx-8,cy);  ry = getHeight(cx+8,cy);
            
           graphics.lineStyle(2,0xFF);
           graphics.drawCircle(cx-8,cy+rx,4);
          
           graphics.lineStyle(2,0xFF);
           graphics.drawCircle(cx+8,cy+ry,4);
            
            
        }//onenter
        
    }//classend
}