/**
 * Copyright antalg ( http://wonderfl.net/user/antalg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yOZT
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import org.papervision3d.view.BasicView    
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    
    [SWF (backgroundColor="0x000000")]
    
    public class FlashTest extends BasicView {
        public function FlashTest() {
            for(var i:int = 0; i<count; i++) {
                var sphere:Sphere = new Sphere(null, rad, 8, 8);
                sphere.x = -(count-1)*rad + (rad)*2*i;
                scene.addChild(sphere);
                
                spheres.push(sphere);
            }
            
            camera.fov = 30;
            
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private var rad:Number = 25;
        
        private var count:Number = 10;
        private var xVal:Number = 0;
        private var dx:Number = Math.PI/count;
        
        private var spheres:Array = new Array();
        
        private function enterFrame(e:Event):void {
            xVal += dx;
            
            for(var i:int = 0; i<spheres.length; i++) {
                spheres[i].yaw(1);
                spheres[i].y = Math.sin(xVal+i*dx)*100;
                spheres[i].z = Math.sin(xVal+i*dx)*200;
                singleRender();
            }
        }
    }
}