/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yNv9
 */

// forked from whirlpower's forked from: Tiling
// forked from quqjp's Tiling
package 
{
    /*
    * BitmapをやめてShapeにしてみた。
    * 構造理解のため、そぎ落とせるところはそぎ落としている。
    *
    * ※ 止まりません。
    */

    import com.bit101.components.HBox;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.TimerEvent;
    import flash.system.Capabilities;
    import flash.system.fscommand;
    import flash.utils.Timer;
    import frocessing.color.ColorHSV;
    public class Tiling extends Sprite
    {
        static public const TILE_SCALE:int = 10;
        static public const TILE_MAX:int = 10;
        static public const IS_DEBUGGING:Boolean = false;
        private var mapLogic:MapLogic;
        private static var debugger:Debugger;
        private var csprite:Sprite;
        private var continueButton:PushButton;
        private var colorHSV:ColorHSV;
        private var counter:uint;
        private var tileAmount:int;
        private var psprite:Sprite;
        private var stopButton:PushButton;
        private var isStopped:Boolean = false;
        private var playButton:PushButton;
        private var stepButton:PushButton;
        private var esprite:Sprite;
        private var state:String;
        private const STATE_SLOW:String = 'STATE_SLOW';
        private const STATE_QUICK:String = 'STATE_QUICK';
        private var fsSprite:Sprite;
        private var labelName:String;
        
        public function Tiling():void
        {
            //stage.align = StageAlign.TOP_LEFT;
            //stage.scaleMode = StageScaleMode.NO_SCALE;
            //stage.frameRate = 5;
            var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
            sCKeyBoard.keyAndFunction =
            {
                S:doStep,
                Z:doStop,
                P:doPlay
            }
            debugger = new Debugger(this);
            tileAmount = int(465 / TILE_SCALE);
            mapLogic = new MapLogic( tileAmount, 10, TILE_SCALE );
            mapLogic.mapSignal.add(drawMap);
            //
            mapLogic.positionSignal.add(onPositionSignalHandler);
            mapLogic.emptyWidthSignal.add(onEmptyWidthSignalHandler);
            mapLogic.tileSignal.add(onTile);
            mapLogic.filledSpaceSignal.add(filledSpaceDraw)
            
            state = STATE_QUICK;;
            if (state==STATE_SLOW) 
            {
                labelName = 'labelName';
                new Label(this, 465 >> 1, 465 >> 1, "press S").name = labelName;
                stage.addEventListener(KeyboardEvent.KEY_DOWN, listener,false, 0, true);
                 
            }
            csprite = Sprite(addChild(new Sprite));
            var bar:HBox = new HBox(this, 0, 465-20);
            continueButton = new PushButton(bar, 0, 0, 'continue', doContinue);
            stopButton = new PushButton(bar, 0, 0, 'stop', doStop);
            playButton = new PushButton(bar, 0, 0, 'play', doPlay);
            stepButton = new PushButton(bar, 0, 0, 'step', doStep);
            if (state == STATE_QUICK) 
            {
                mapLogic.lengthChange.add(onMapChange);
                //mapLogic.lineSignal.add(onLineSignal);
                addEventListener( Event.ENTER_FRAME, render );
                stepButton.visible = false;
            }
            var isWeb:Boolean = Capabilities.playerType == "PlugIn" || Capabilities.playerType == "ActiveX";
            if (!isWeb) 
            {
                new PushButton(bar, 0, 0, 'close', doClose);
            }
            continueButton.visible = false;
            //draw();
            colorHSV = new ColorHSV();
            esprite = Sprite(addChild(new Sprite));
            psprite = Sprite(addChild(new Sprite));
            fsSprite = Sprite(addChild(new Sprite));
            swapChildren(debugger, getChildAt(numChildren-1));
        }
        
        private function listener (e:KeyboardEvent) :void
        { 
            if (e.keyCode == String('S').charCodeAt()) 
            { 
                removeChild(this.getChildByName(labelName));
                stage.removeEventListener(KeyboardEvent.KEY_DOWN, listener);
            }
        }    
        
        private function filledSpaceDraw(filledSpaceIndex:int):void 
        {
            if (IS_DEBUGGING) 
            {
                var g:Graphics = fsSprite.graphics;
                g.beginFill(0);
                drawRectangleAt(g, filledSpaceIndex,5);
                g.endFill();
                swapChildren(fsSprite, getChildAt(numChildren - 1));
            }
        }
        
        private function doClose(e:Event=null):void 
        {
            fscommand('quit', 'true');
        }
        
        private function onTile(oTileArg:Tile):void 
        {
            cTrace( "Tiling.onTile > oTileArg : " + oTileArg );
            addChild(oTileArg);
            esprite.graphics.clear();
            
        }
        
        private function doStep(e:Event=null):void 
        {
            render(null);
        }
        
        private function doPlay(e:Event=null):void 
        {
            isStopped = false;
            state = STATE_QUICK
            removeEventListener(Event.ENTER_FRAME, render);
            addEventListener(Event.ENTER_FRAME, render);
            stepButton.visible = false;
        }
        
        private function doStop(e:Event=null):void 
        {
            removeEventListener(Event.ENTER_FRAME, render);
            isStopped = true;
            stepButton.visible = true;
        }
        
        private function onEmptyWidthSignalHandler(emptyWidth:uint,position:int,type:int):void 
        {
            if (IS_DEBUGGING) 
            {
                var g:Graphics = esprite.graphics;
                switch (type) 
                {
                    case MapLogic.TYPE_FIRST:
                        g.beginFill(0xffffff);
                        g.lineStyle(0);
                        drawRectangleAt(g, position+emptyWidth, 5,0,5);
                        g.endFill();
                    break;
                    case MapLogic.TYPE_SECOND:
                        g.beginFill(new ColorHSV(1/6).value);
                        g.lineStyle(0);
                        drawRectangleAt(g, position+emptyWidth, 5);
                        g.endFill();
                    break;
                    default:
                        
                    break;
                }
            }
        }
        
        private function onPositionSignalHandler(position:int):void 
        {
            if (IS_DEBUGGING) 
            {
                var g:Graphics = psprite.graphics;
                //g.clear();
                g.lineStyle(0);
                g.beginFill(0xff00);
                drawRectangleAt(g, position,4,0,6);
                g.endFill();
            }
            
        }
        
        private function onMapChange():void 
        {
            cTrace( "Tiling.onMapChange" );
            removeEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = true;
            if (!isStopped)
            {
                var timer:Timer = new Timer(1000, 1);
                timer.addEventListener(TimerEvent.TIMER_COMPLETE, afterMapChange, false, 0, true);
                timer.start();
            }
        }
        
        private function afterMapChange(e:TimerEvent):void 
        {
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function onLineSignal():void 
        {
            removeEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = true;
        }
        
        private function doContinue(e:Event):void 
        {
            addEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = false;
        }
        
        private function drawMap(map:Array):void 
        {
            colorHSV.h = (counter++)%360
            var g:Graphics = csprite.graphics;
            g.clear();
            g.lineStyle(0);
            //g.beginFill(colorHSV.value);
            for (var i:int = 0; i < map.length; i++) 
            {
                var item:uint = map[i];
                g.beginFill(item == 0?0:0xff ,0.5);
                drawRectangleAt(g,i,TILE_SCALE-2);
            }
        }
        
        private function drawRectangleAt(g:Graphics, i:int, size:Number,xoff:Number=0,yoff:Number=0):void 
        {
            g.drawRect(
                i % tileAmount * TILE_SCALE + 1+xoff,
                uint(i / tileAmount) * TILE_SCALE + 1+yoff, 
                size, 
                size
            );
        }
        
        
        static public function traceIt(msg:String):void 
        {
            debugger.traceThis(msg)
            
        }
        
        private function cTrace(msg:String):void 
        {
            traceIt(msg);
        }
        
        private function draw():void 
        {
            while (addChild( mapLogic.create() ).y<480) 
            {
                
            }
        }
        
        private function render( e:Event ):void
        {
            switch (state) 
            {
                case STATE_QUICK:
                    addChild(mapLogic.create());
                break;
                case STATE_SLOW:
                    mapLogic.detailedCreate() 
                break;
                default:
                    
                break;
            }
        }
    }
}

import com.bit101.components.PushButton;
import com.bit101.components.TextArea;
import com.bit101.components.VBox;
import flash.display.*;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.ui.Keyboard;
import flash.utils.Timer;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;
internal class MapLogic
{
    static public const TYPE_SECOND:Number = 1;
    static public const TYPE_FIRST:Number = 0;
    private var _map:Array = [];
    private var gridW:int;
    private var gridH:int;
    private var tileMax:int;
    private var tileScale:int = 10;
    private var icount:uint;
    private var tiles:Vector.<Tile>;
    private var lineCounter:uint;
    private var mapLength:uint;
    private var mapIndex:uint;
    public var emptyPos:int = 0;
    public var lengthChange:ISignal;
    public var mapSignal:ISignal;
    public var lineSignal:ISignal;
    public var positionSignal:ISignal;
    private var emptyWidth:int;
    private var position:int;
    public var emptyWidthSignal:ISignal;
    private var ww:int;
    private var hh:int;
    public var emptyPosSignal:ISignal;
    public var tileSignal:ISignal;
    public var filledSpaceSignal:ISignal;
    
    public function MapLogic( gridW:int, tileMax:int, tileScale:int ):void
    {
        this.gridW        = gridW;
        this.tileMax      = tileMax;
        this.tileScale    = tileScale;
        
        mapSignal = new Signal(Array);
        lengthChange = new Signal();
        lineSignal = new Signal();
        tiles = Vector.<Tile>([]);
        positionSignal = new Signal(int);
        emptyPosSignal = new Signal(int);
        emptyWidthSignal = new Signal(int,int,int);
        tileSignal = new Signal(Tile);
        filledSpaceSignal = new Signal(int);
        
    }
    public function detailedCreate():void 
    {
        position = -1;
        emptyWidth = 0;
        icount = 0;
        mapIndex = emptyPos;
        var timer:Timer = new Timer(100);
        timer.addEventListener(TimerEvent.TIMER, doCreate);
        timer.start();
    }
    public function create():Tile
    {
        position = -1;
        emptyWidth = 0;
        icount = 0;
        forLoop();
        
        var t:Tile = createTile();
        
        return t;
    }
    
    private function createTile():Tile
    {
        setRandomWidth();
        
        setMap();
        
        var t:Tile = setTile();

        return t;
    }
    
    
    private function setTile():Tile 
    {
        var px:int = position % gridW * tileScale;
        var py:int = position == 0 ? 0 : int( position / gridW ) * tileScale;
        if ( px==0) 
        {
            lineCounter++;
            lineSignal.dispatch();
        }
        var tile:Tile = new Tile( px, py, ww * tileScale, hh * tileScale );    
        tiles[tiles.length] = tile;
        return tile;
    }
    
    
    private function setMap():void 
    {
        var p:int = position;
        for ( var yy:int = 0; yy < hh; yy++ ){
            for ( var xx:int = 0; xx < ww; xx++ ){
                _map[p] = 1;
                p++;
            }
            p += gridW  - ww;
            var delta:Number = (gridW - ww);
        }
        mapSignal.dispatch(_map);
        if (_map.length!=mapLength) 
        {
            lengthChange.dispatch();
        }
        mapLength = _map.length;
        emptyPos = position + ww;
        emptyPosSignal.dispatch(emptyPos);
    }
    
    
    private function forLoop():void 
    {
        for (mapIndex = emptyPos; mapIndex < emptyPos +500 ; mapIndex++ )
        {
            var s:int = setPosition()
            if (s==2||s==4) 
            {
                break;
            }
            if (s==0) 
            {
                filledSpaceSignal.dispatch(mapIndex);
            }
        }
    }
    
    
    private function doCreate(e:TimerEvent):void 
    {
        var s:int = setPosition();
        if (s==2||s==4) 
        {
            Timer(e.target).removeEventListener(TimerEvent.TIMER, doCreate);
            var t:Tile = createTile();
            tileSignal.dispatch(t);
        }
        if (s==0) 
        {
            filledSpaceSignal.dispatch(mapIndex);
        }
        mapIndex++ 
    }
    
    private function setRandomWidth():void 
    {
        ww    = int( OneMinusX_2() * emptyWidth ) + 1;
        ww    = int( Math.random() * emptyWidth ) + 1;
        if (emptyWidth<=4) 
        {
            ww = emptyWidth;
        }
        else if (emptyWidth>4 && ww<1) 
        {
            ww = emptyWidth
        }
        
        hh = int(Math.random() * emptyWidth) + 1
        //hh = ww;
    }
    
    private function OneMinusX_2():Number 
    {
        return 1 - Math.random() * Math.random();
    }
    
    
     private function setPosition():int
    {
        var output:Boolean = false;
        icount++;
        var conditionId:int;
        if ( !_map[mapIndex] && position == -1 )
        {
            conditionId = 1;
            position = mapIndex;
            positionSignal.dispatch(position);
            emptyWidth++;
            emptyWidthSignal.dispatch(emptyWidth, position, TYPE_FIRST);
            output = true;
        } else if ( emptyWidth >= tileMax )
        {
            conditionId = 2;
            output = false;
        } else if ( !_map[mapIndex] && !( mapIndex % gridW == 0 && mapIndex != emptyPos ) ) 
        {
            conditionId = 3;
            emptyWidth++;
            emptyWidthSignal.dispatch(emptyWidth, position, TYPE_SECOND);
            output = true;
        } else if ( position != -1 ) 
        {
            conditionId = 4;
            output = false;
        }
        return conditionId
    }   
    private function cTrace(arg1:String):void 
    {
        Tiling.traceIt(arg1);
    }
}

internal class Tile extends Shape
{
    public function Tile( _x:int, _y:int, _w:int, _h:int ):void
    {
        this.x = _x;
        this.y = _y;
        
        graphics.lineStyle( 1, 0x000000 );
        graphics.drawRect( 0, 0, _w, _h );
    }
}
class Debugger extends VBox
{
    private var _textField:TextField;
    private var _msprite:Sprite;
    public function Debugger(msprite:Sprite) 
    {
        super();
        _msprite = msprite;
        _msprite.addChild(this);
        addChildAt(new PushButton(null, 0, 0, "clear", doClear), numChildren);;
        var textArea:TextArea = new TextArea();
        addChildAt(textArea, numChildren);
        _textField = textArea.textField
        x = 465;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
        textArea.setSize(465, 430);
        var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
        sCKeyBoard.keyAndFunction =
        {
            Q:setDebuggerVisibility,
            A:setDebuggerAlpha,
            C:clear
        }
    }
    
    private function clear():void 
    {
        _textField.text = "";
    }
    private function setDebuggerAlpha():void 
    {
        const debuggerAlpha:Number = 0.5;
        alpha = alpha == debuggerAlpha?1:debuggerAlpha;
    }
    
    private function setDebuggerVisibility():void 
    {
        visible = !visible;
    }
    
    private function onKeyDownHandler(e:KeyboardEvent):void 
    {
        switch (e.keyCode) 
        {
            case Keyboard.UP:
                _textField.scrollV -= 10;
            break;
            case Keyboard.DOWN:
                _textField.scrollV += 10;
            break;
            default:
                
            break;
        }
    }
    
    private function doClear(e:Event):void 
    {
        _textField.text = "";
    }
    
    public function get textField():TextField 
    {
        return _textField;
    }
    
    public function set textField(value:TextField):void 
    {
        _textField = value;
    }
    
    public function traceThis(msg:String):void 
    {
        _textField.appendText(msg + "\n");
        _textField.scrollV = textField.maxScrollV;
        
    }
}
class SCKeyBoard
{
    private var _stage:Stage;
    private var object:Object;
    public var keyAndFunction:Object;
    public function SCKeyBoard(stageArg:Stage) 
    {
        _stage = stageArg;
        _stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
    }
    
    private function keyDownHandler(e:KeyboardEvent):void 
    {
        if (!keyAndFunction) 
        {
            throw new Error("keyAndFunction should be defined");
        }
        var callBack:Function;
        if (keyAndFunction[String.fromCharCode(e.keyCode)]) 
        {
            callBack = keyAndFunction[String.fromCharCode(e.keyCode)]
            callBack();
        }
    }
    
    private function cTrace(arg1:String):void 
    {
        Tiling.traceIt(arg1);
    }
    
}





















