/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yNlQ
 */

// forked from kihon's flash on 2011-1-9
package
{
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite
    {
        public static var canvas:BitmapData;
        private var ants:Vector.<Ant> = new Vector.<Ant>();
        private var scale:Number = 4.0;
        private var step:int = 0;
        private var stepLabel:Label;
        
        private var antsNumber:uint = 5;
        
        public function Main()
        {
            stage.frameRate = 120;
            canvas = new BitmapData(stage.stageWidth / scale, stage.stageHeight / scale, false, CANVASCOLOR);
            var bitmap:Bitmap = new Bitmap(canvas);
            bitmap.scaleX = bitmap.scaleY = scale;
            addChild(bitmap);
            
            for (var i:uint = 0; i < antsNumber; ++i)
            {
                var x:int = Math.random() * stage.stageWidth;
                var y:int = Math.random() * stage.stageHeight;
                var dir:int = Math.random() * 4 >> 0;
                var color:uint = Math.random() * 0xffffff;
                ants.push(new Ant(x, y, dir, color));
            }
            stepLabel = new Label(this, 350, 400);
            stepLabel.scaleX = stepLabel.scaleY = 2;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            for each (var ant:Ant in ants) ant.move();
            stepLabel.text = "Step " + ++step;
        }
    }
}

const CANVASCOLOR:uint = 0xB1C880;

class Ant
{
    public static const DIRECTION:Array = [{x:0, y:-1}, {x:1, y:0}, {x:0, y:1}, {x:-1, y:0}];
    public var x:int;
    public var y:int;
    public var dir:int;
    private var _color:uint;
    
    public function Ant(x:int, y:int, dir:int, color:uint)
    {
        this.x = x;
        this.y = y;
        this.dir = dir;
        _color = color;
    }
    
    public function move():void
    {
        if (Main.canvas.getPixel(x, y) == this._color/*0x5E6F3B*/)
        {
            Main.canvas.setPixel(x, y, CANVASCOLOR);
            dir++;
        }
        else
        {
            Main.canvas.setPixel(x, y, this._color/*0x5E6F3B*/);
            dir--;
        }
        
        if (dir < 0) dir += DIRECTION.length;
        dir %= DIRECTION.length;
        
        var o:Object = DIRECTION[dir];
        x += o.x;
        y += o.y;
        
        if (x < 0) x += Main.canvas.width;
        if (y < 0) y += Main.canvas.height;
        x %= Main.canvas.width;
        y %= Main.canvas.height;
    }
}