/**
 * Copyright robertsonchisholm ( http://wonderfl.net/user/robertsonchisholm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yN8c
 */

package
{
    import flash.display.*;
    import flash.text.*;

    public class SimpleTextButton extends Sprite{
        
            
        public function SimpleTextButton():void{
            
        }
        
        
        public function makeButton(stbText:String="Button",
                                         stbFont:String="Arial",
                                         stbFontSize:int=16,
                                         stbFontBold:Boolean=false,
                                         stbColourUp:uint=0x0000FF,
                                         stbColourOver:uint=0x00FF00,
                                         stbColourDown:uint=0xFF0000,
                                         stbAlign:String = "left",
                                         stbWidth:Number = 400,
                                         stbLeading:int = 0
                                         ):SimpleButton{
            var simpleTextButton:SimpleButton = new SimpleButton();
            simpleTextButton.upState = drawTextButtonState(stbText, stbFont, stbFontSize, stbFontBold, stbColourUp, stbAlign, stbWidth, stbLeading);
            simpleTextButton.overState = drawTextButtonState(stbText, stbFont, stbFontSize, stbFontBold, stbColourOver, stbAlign, stbWidth, stbLeading);
            simpleTextButton.downState = drawTextButtonState(stbText, stbFont, stbFontSize, stbFontBold, stbColourDown, stbAlign, stbWidth, stbLeading);
            simpleTextButton.hitTestState = drawTextButtonState(stbText, stbFont, stbFontSize, stbFontBold, 0xAAAAAA, stbAlign, stbWidth, stbLeading);
            simpleTextButton.useHandCursor = true;
            return simpleTextButton;
        }
        
    
        private function drawTextButtonState(t:String, f:String, s:int, b:Boolean, rgb:uint, a:String, w:Number, ld:int):Sprite {
            
            var thisTextFormat:TextFormat = new TextFormat();
            thisTextFormat.font = f;
            thisTextFormat.size = s;
            thisTextFormat.bold = b;
            thisTextFormat.color = rgb;
            thisTextFormat.align = a;
            thisTextFormat.leading = ld;
            var thisButtonText:TextField = new TextField();
            
            switch (a){
                case "center":
                    thisButtonText.autoSize = TextFieldAutoSize.CENTER;
                    break;
                case "left":
                    thisButtonText.autoSize = TextFieldAutoSize.LEFT;
                    break;
                case "right":
                    thisButtonText.autoSize = TextFieldAutoSize.RIGHT;
                    break;
            }
            
            //thisButtonText.height = s;
            thisButtonText.wordWrap = true;
            thisButtonText.selectable = false;
            thisButtonText.appendText(t);
            thisButtonText.setTextFormat(thisTextFormat);
            thisButtonText.width = w;
            //thisButtonText.border = true;
            thisButtonText.width = thisButtonText.textWidth*1.1;
            var sprite:Sprite = new Sprite();
            sprite.addChild(thisButtonText);
            return sprite;
        }
    }
}