/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yMeO
 */

package {
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

    public class Main extends Sprite 
	{
		public function Main() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}

                private function blend(first:uint, second:uint, percent:Number):uint
		{
		    var r:int = ((first & 0xff0000) >> 16) * (1 - percent) + ((second & 0xff0000) >> 16) * percent;
		    var g:int = ((first & 0x00ff00) >> 8) * (1 - percent) + ((second & 0x00ff00) >> 8) * percent;
		    var b:int = ((first & 0x0000ff) ) * (1 - percent) + ((second & 0x0000ff) ) * percent;
		    return r << 16 | g << 8 | b;
		}

                private function HSV2HEX( h:Number, s:Number, v:Number ):Number 
                {
                    // HSV TO RGB
		    var r:Number = 0;
			var g:Number = 0;
			var b:Number = 0;
			var rgb:Array = [];
			 
			var tempS:Number = s / 100;
			var tempV:Number = v / 100;
			 
			var hi:int = Math.floor(h/60) % 6;
			var f:Number = h/60 - Math.floor(h/60);
			var p:Number = (tempV * (1 - tempS));
			var q:Number = (tempV * (1 - f * tempS));
			var t:Number = (tempV * (1 - (1 - f) * tempS));
			 
			switch(hi)
			{
				case 0: r = tempV; g = t; b = p; break;
				case 1: r = q; g = tempV; b = p; break;
				case 2: r = p; g = tempV; b = t; break;
				case 3: r = p; g = q; b = tempV; break;
				case 4: r = t; g = p; b = tempV; break;
				case 5: r = tempV; g = p; b = q; break;
			}
			 
			
			// RGB to HEX
			
			return (Math.round(r * 255) << 16 | Math.round(g * 255) << 8 | Math.round(b * 255));
                }

		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			stage.scaleMode = 'noScale';
			stage.align = 'tl';
			
			var color:uint = 0xFF0000;
			
		        var step:int = 4;
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:*=null):void
			{
				var mx:Number = stage.mouseX;
				var my:Number = stage.mouseY;
				
				var sw:int = stage.stageWidth;
				var sh:int = stage.stageHeight;
				var sh2:int = (sh >> 1);
				
				mx /= 6; 
				
				color = HSV2HEX( mouseX % sw, 100*240/255, 100*250/255 );
				
				var y:int = 0;
				var p:Number = 0;
				var g:Graphics = graphics;
				var colorY:uint;
				
				g.clear();
				
				
				for ( y = 0; y < sh; y += step)
				{
					if ( y < sh >> 1 ) 
					{
						p = 1 - ( y == 0 ? 1 : ( y / (sh >> 1) ) );
						
						colorY = blend( color, 0xFFFFFF, p );
						
						g.beginFill( colorY );
						g.drawRect( 0, y, sw, step );
						g.endFill();
					
					} else {
						
						p = ( y == (sh >> 1) ? 1 : ( y / (sh >> 1) ) ) - 1;
						
						colorY = blend( color, 0x000000, p );
							
						g.beginFill( colorY );
						g.drawRect( 0, y, sw, step );
						g.endFill();
						
					}
				}
			});
		}

	}
}