/**
 * Copyright _shimabox ( http://wonderfl.net/user/_shimabox )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yMb9
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ボールを転がしてみました
	 * @author s
	 */
	[SWF(width="465", height="465", frameRate="40")]
	public class Main extends Sprite 
	{
		private var s_rect:Sprite;
		private var s_trapezium:Sprite;
		private var s_ball:Sprite;
		private var b:Boolean = false;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			this.drowRect();
			this.drowTrapezium();
			this.drowBall();
			this.stage.addEventListener(Event.ENTER_FRAME, this.onEnterFlame);
		        Wonderfl.capture_delay( 6 );
                }
		
		private function onEnterFlame(e:Event):void
		{
			if (!this.b) {
				this.s_ball.scaleX -= 0.01;
				this.s_ball.scaleY -= 0.01;
				if (this.s_ball.scaleX < 0 || this.s_ball.scaleY < 0) 
					this.b = true;
			}else {
				this.s_ball.scaleX += 0.01;
				this.s_ball.scaleY += 0.01;
				if (this.s_ball.scaleX >= 1 || this.s_ball.scaleY >= 1) 
					this.b = false;
			}
		}
		
		private function drowRect():void
		{
			var w:Number = this.stage.stageWidth / 13;
			var h:Number = this.stage.stageHeight / 15;
			this.s_rect = new Sprite();
			this.s_rect.graphics.beginFill(0x000, 1);
			this.s_rect.graphics.drawRect(w * 6, 0, w, h);
			this.s_rect.graphics.endFill();
			this.stage.addChild(this.s_rect);
		}
		
		private function drowTrapezium():void
		{
			var w:Number = this.stage.stageWidth / 13;
			var h:Number = this.stage.stageHeight / 15;
			var sh:Number = this.stage.stageHeight;
			this.s_trapezium = new Sprite();
			this.s_trapezium.graphics.beginFill(0x000, 0.2);
			this.s_trapezium.graphics.moveTo(w * 6 , h);
			this.s_trapezium.graphics.lineTo(w, sh);
			this.s_trapezium.graphics.lineTo(w * 12, sh);
			this.s_trapezium.graphics.lineTo(w * 7, this.s_rect.height);
			this.s_trapezium.graphics.endFill();
			this.stage.addChild(this.s_trapezium);
		}
		
		private function drowBall():void
		{
			var sw:Number = this.stage.stageWidth;
			var sh:Number = this.stage.stageHeight;
			var s:Sprite = new Sprite();
			s.x = sw / 2;
			this.s_ball = new Sprite();
			this.s_ball.graphics.beginFill(0x000, 0.9);
			this.s_ball.graphics.drawCircle(0, sh + sw/4, sw/4);
			this.s_ball.graphics.endFill();
			this.stage.addChild(s);
			s.addChild(this.s_ball);
		}
	}
}