/**
 * Copyright Antoan ( http://wonderfl.net/user/Antoan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yMb2
 */

// forked from shapevent's Box2D Magnet
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import com.actionsnippet.qbox.*;
    import Box2D.Common.Math.*;
    
    public class FlashTest extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var lab:TextField, out:TextField;
        private var big:QuickObject, little:QuickObject;
        private var dir:b2Vec2, currVel:b2Vec2;
        private var ang:Number, intensity:Number = 1; 
        // give 'intensity' a positive value if you want the magnet to attract objects and a negative if you want it to reject them 
        
        public function FlashTest() 
        {
            sim = new QuickBox2D(this);
            sim.createStageWalls();
            big = sim.addCircle({x: 7, y: 7, radius: 3, density: 0});
            little = sim.addCircle({x : 3, y: 12, radius: 1, friction:5});
            
            sim.start();
            sim.mouseDrag();
            addEventListener(Event.ENTER_FRAME, onLoop);
            
            lab = new TextField();
            lab.x = 50;
            lab.y= 50;
            lab.autoSize = "left";
            lab.text = "set intensity:\n[enter positive values to attract, negative to reflect]";
            addChild(lab);
            
            out = new TextField();
            out.x = lab.x+70;
            out.y = 47;
            out.type = "input";
            out.border = true;
            out.autoSize = "left";
            out.text = String(intensity);
            addChild(out);
        }
        
        // this is where the magnet code happens:
        
        private function onLoop(e:Event):void
        {
            intensity = Number(out.text);
            ang = Math.atan2(big.y-little.y, big.x-little.x);            
            currVel = little.body.GetLinearVelocity();
            dir = new b2Vec2(currVel.x + intensity * Math.cos(ang), currVel.y + intensity * Math.sin(ang));
            little.body.SetLinearVelocity(dir);
        }
    }
}