/**
 * Copyright ChevyRay ( http://wonderfl.net/user/ChevyRay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yMNn
 */

package
{
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    
    //CLICK TO GENERATE A NEW MAZE!
    public class MazeGenerator extends Sprite
    {
        //Maze should always be an odd-number of tiles! (eg. 9x9, 33x15, etc.)
        public const MAZE_WIDTH:int = 21;
        public const MAZE_HEIGHT:int = 21;
        public const MAZE_SCALE:Number = 20;
        
        //Directional constants
        public const RIGHT:uint = 0;
        public const LEFT:uint = 1;
        public const DOWN:uint = 2;
        public const UP:uint = 3;
        
        public var data:BitmapData = new BitmapData(MAZE_WIDTH, MAZE_HEIGHT, false, 0xFFFFFF);
        public var bitmap:Bitmap = new Bitmap(data);
        
        public function MazeGenerator()
        {
            bitmap.scaleX = bitmap.scaleY = MAZE_SCALE;
            addChild(bitmap);
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            generate();
        }
        
        public function onClick(e:MouseEvent):void
        {
            generate();
        }
        
        public function generate():void
        {
            var xStack:Array = [];
            var yStack:Array = [];
            var sides:Array = [];
            
            data.fillRect(data.rect, 0xFFFFFFFF);
            
            //Pick random start point
            var x:int = 1 + int(Math.random() * (MAZE_WIDTH / 2)) * 2;
            var y:int = 1 + int(Math.random() * (MAZE_HEIGHT / 2)) * 2;
            xStack.push(x);
            yStack.push(y);
            
            //Maze generation loop
            while (xStack.length > 0)
            {
                x = xStack[xStack.length - 1];
                y = yStack[yStack.length - 1];
                sides.length = 0;
                
                if (getTile(x + 2, y))
                    sides.push(RIGHT);
                if (getTile(x - 2, y))
                    sides.push(LEFT);
                if (getTile(x, y + 2))
                    sides.push(DOWN);
                if (getTile(x, y - 2))
                    sides.push(UP);
                
                if (sides.length > 0)
                {
                    var side:int = sides[int(Math.random() * sides.length)];
                    switch (side)
                    {
                        case RIGHT:
                            setTile(x + 1, y, false);
                            setTile(x + 2, y, false);
                            xStack.push(x + 2);
                            yStack.push(y);
                            break;
                        case LEFT:
                            setTile(x - 1, y, false);
                            setTile(x - 2, y, false);
                            xStack.push(x - 2);
                            yStack.push(y);
                            break;
                        case DOWN:
                            setTile(x, y + 1, false);
                            setTile(x, y + 2, false);
                            xStack.push(x);
                            yStack.push(y + 2);
                            break;
                        case UP:
                            setTile(x, y - 1, false);
                            setTile(x, y - 2, false);
                            xStack.push(x);
                            yStack.push(y - 2);
                            break;
                    }
                }
                else
                {
                    xStack.pop();
                    yStack.pop();
                }
            }
        }
        
        public function getTile(x:int, y:int):Boolean
        {
            if (x < 0 || y < 0 || x >= MAZE_WIDTH || y >= MAZE_HEIGHT)
                return false;
            return data.getPixel(x, y) > 0x000000;
        }
        
        public function setTile(x:int, y:int, solid:Boolean):void
        {
            data.setPixel(x, y, solid ? 0xFFFFFF : 0x000000);
        }
    }
}