/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yLqW
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.utils.Dictionary;
    /**
     * ...
     * @author Glenn Ko
     */
    public class EdgeLiner extends Sprite
    {
        private var gridSize:Number = 16;
        private var gridPointerPos:Point = new Point();
        private var gridPointer:Sprite = new Sprite();
        
        private var points:Array = [];
        private var adjustedPoints:Array = [];
        private var ptMap:Dictionary = new Dictionary();
        private var lineGraph:Sprite = new Sprite();
        
        public function EdgeLiner() 
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove, false, 0, true);
            stage.align = StageAlign.TOP_LEFT;
            gridPointer.graphics.beginFill(0xFF0000, 1);
            gridPointer.graphics.drawRect(0, 0, 4, 4);
            
            graphics.beginFill(0, 0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
            addChild(lineGraph);
            addChild(gridPointer);
            
            
        }
        
        private function onMouseClick(e:MouseEvent):void 
        {
            
            var x:int = Math.floor(mouseX / gridSize);
            var y:int = Math.floor(mouseY / gridSize);
            if (points.length == 0 || !checkAdjacient(x,y) ) {
                reset(x, y);
                drawPoints();
            }
            else {
                addPoint(x, y);
                drawPoints();
                
            }
        }
        
        private function drawPoints():void 
        {
            var pt:Point;
            var i:int
            var len:int = points.length;
            if (len <= 0) return;
            lineGraph.graphics.clear();
            
            lineGraph.graphics.lineStyle(0, 0xFF0000);
            lineGraph.graphics.moveTo( points[0].x, points[0].y);
            for (i = 1; i < len; i++) {
                pt = points[i];
                lineGraph.graphics.lineTo(pt.x, pt.y);
            }
            
        
            var lastPoints:Array;
            adjustedPoints = deepClone(points);
            
            for (var u:int = 0 ; u < 1; u++ ){
                lastPoints = deepClone(adjustedPoints); 
            
                //adjustedPoints[0] = points[0].clone();
                for (i = 1; i < len-1; i++) {
                    
                     pt = lastPoints[i];
                    // pt.x = lastPoints[i].x;
                //     pt.y = lastPoints[i].y;
                    pt.x += lastPoints[i-1].x;
                    pt.x += lastPoints[i + 1].x;
                    pt.x /=3;
                    
                    pt.y += lastPoints[i-1].y;
                    pt.y += lastPoints[i + 1].y;
                    pt.y /= 3;
                    
                    adjustedPoints[i].x  = pt.x;
                    adjustedPoints[i].y = pt.y;
                }
            }
            //adjustedPoints[points.length -1] = points[points.length-1].clone();
            
            
            lineGraph.graphics.lineStyle(0, 0x000000);
            lineGraph.graphics.moveTo( adjustedPoints[0].x, adjustedPoints[0].y);
            for (i = 1; i < len; i++) {
                pt = adjustedPoints[i];
                lineGraph.graphics.lineTo(pt.x, pt.y);
            }
        }
        
        private function deepClone(arr:Array):Array {
            arr = arr.concat();
            var len:int = arr.length;
            for (var i:int = 0; i < len ; i++) {
                arr[i]  = arr[i].clone();
            }
            return arr;
        }
        
        private function checkAdjacient(x:int, y:int):Boolean 
        {
            var lx:int = points[points.length - 1].x - gridSize*.5;
            var ly:int = points[points.length - 1].y - gridSize * .5;
            lx /= gridSize;
            ly /= gridSize;
            return Math.abs(lx - x) == 1 || Math.abs(ly - y) == 1;
        }
        
        private function reset(x:int, y:int):void {
            ptMap = new Dictionary();
            points = [];
            addPoint(x, y);
        }
        
        private function addPoint(x:int, y:int):void 
        {
            
            points.push( new Point(x*gridSize+gridSize*.5, y*gridSize+gridSize*.5) );
            ptMap[x+","+y] = true;
        }
        
        private function onMouseMove(e:MouseEvent):void 
        {
            gridPointerPos.x =  Math.floor(mouseX / gridSize);
            gridPointerPos.y = Math.floor(mouseY / gridSize);
            
            gridPointer.x=  gridPointerPos.x * gridSize + gridSize * .5;
            gridPointer.y= gridPointerPos.y * gridSize + gridSize * .5;
        }
        
    }

}