/**
 * Copyright primenumber ( http://wonderfl.net/user/primenumber )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yLhM
 */

// forked from primenumber's Barrage Shooting Game(弾幕シューティング)
package
{
	//いわゆる弾幕ゲーです。
	//デザインとかは一切考えてません。
	//システム自体は軽いので、数万発出しても大丈夫です。
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.getTimer;
	
	public class FlashTest extends Sprite 
	{
		private const stageRect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
		private const bulr:int = 3;//弾の半径
		private const bulRect:Rectangle = new Rectangle(0, 0, bulr*2, bulr*2);
		private const bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
		private const bmo:Bitmap = new Bitmap(bmd);
		private const bulbmp:BitmapData = new BitmapData(bulr*2, bulr*2, true, 0x00FFFFFF);
		private const ene:enemy = new enemy(stage.stageWidth/2);
		private const bulvec:Vector.<bullet> = new Vector.<bullet>();
		private const tf:TextField = new TextField();
		private const my:mine = new mine();
		private const point:Point = new Point();
		private const beamRect:Rectangle = new Rectangle(0,0,20,0);
		private const hp:int = 50;//自分のライフ
		private const eneHp:int = 1000;//敵のライフ
		private const maxnum:int = 6000;//弾幕の最高弾数
		private const pi:Number = Math.PI;
		
		private var num:int = 0;
		private var damage:int = 0;
		private var enemyDamage:int = 0;
		private var mouseState:Boolean = false;
		private var frames:int = 0;
		private var actBullet:uint = 0;
		
		public function FlashTest():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			stage.scaleMode = "noScale";
			stage.align = "T";
			//stage.quality = "low";//重くなったらコメントアウト
			var shape:Shape = new Shape();
			shape.graphics.beginFill(0x00BBBB);
			shape.graphics.drawCircle(bulr, bulr, bulr);
			bulbmp.draw(shape, new Matrix());
			addChild(bmo);
			addChild(ene);
			addChild(my);
			tf.width = stage.stageWidth;
			tf.text = "hp:" + (hp - damage) + "enemy-hp:" + (eneHp - enemyDamage);
			tf.textColor = 0xFFFFFF;
			addChild(tf);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseUp(e:MouseEvent):void 
		{
			mouseState = false;
			my.onShield();
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			mouseState = true;
			my.offShield();
		}
		
		private function onEnterFrame(e:Event):void
		{
			bmd.unlock(stageRect);
			bmd.lock();
			bmd.fillRect(stageRect, 0x000000);
			ene.move();
			my.move();
			if (mouseState)
			{
				beamRect.x = my.x - 10;
				beamRect.height = my.y - 10;
				bmd.fillRect(beamRect, 0xFFFF00);
			}
			var i:int;
			//弾幕生成部
			if(!(frames%2))for (i = 0; i < 8; i++)
			{
				bulvec[num] = new bullet(
					ene.x+20,
					ene.y,
					pi * i / 4 + (frames&0x3F) / 256 * pi,
					2,
					0.03,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
				bulvec[num] = new bullet(
					ene.x-20,
					ene.y,
					pi * i / 4 - (frames&0x3F) / 256 * pi,
					2,
					0.03,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
			}
			if(!(frames%2))for (i = 0; i < 4; i++)
			{
				bulvec[num] = new bullet(
					ene.x+20,
					ene.y,
					pi * i / 2 + (frames&0x1F) / 64 * pi,
					3,
					0.01,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
				bulvec[num] = new bullet(
					ene.x-20,
					ene.y,
					pi * i / 2 - (frames&0x1F) / 64 * pi,
					3,
					0.01,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
			}
			if(!(frames%6))for (i = 0; i < 8; i++)
			{
				bulvec[num] = new bullet(
					ene.x+50,
					ene.y,
					pi * i / 4 - (frames&0x7) / 32 * pi,
					-5,
					0.03,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
				bulvec[num] = new bullet(
					ene.x-50,
					ene.y,
					pi * i / 4 + (frames&0x7) / 32 * pi,
					-5,
					0.03,
					0x00FFFF
				);
				(num < maxnum)?num++:num = 0;
			}
			frames++;
			//ここまで
			var nums:int = bulvec.length;
			actBullet = 0;
			for (i = 0; i < nums; i++ )
			{
				const bul:bullet = bulvec[i];
				bulvec[i].move();
				point.x = bul.x;
				point.y = bul.y;
				if (bul.x >= -2 && bul.x < stageRect.width+2 && bul.y >= -2 && bul.y < stageRect.height+2)
				{
					bmd.copyPixels(bulbmp, bulRect, point);
					actBullet++;
				}
			}
			if (mouseState)
			{
				if (bmd.getPixel(my.x, my.y))
				{
					damage++;
					if (damage >= hp) restart();
				}
				if (Math.abs(ene.x - my.x) <= 10)
				{
					enemyDamage++;
					if (enemyDamage >= eneHp) gameClear();
				}
			}
			tf.text = "Shield:" + (hp-damage) + "/Enemy's Shield:" + (eneHp - enemyDamage) + "/Bullets num on display:" + actBullet;
		}
		
		private function restart():void
		{
			bulvec.splice(0, bulvec.length-1);
			num = 0;
			damage = 0;
			enemyDamage = 0;
		}
		
		private function gameClear():void
		{
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			var txfo:TextFormat = new TextFormat();
			txfo.align = "center";
			txfo.size = 40;
			var cl:TextField = new TextField();
			cl.textColor = 0xFFFFFF;
			cl.width = 450;
			cl.defaultTextFormat = txfo;
			cl.text = "GAME CLEAR";
			cl.y = 250;
			addChild(cl);
		}
	}
	
}
class bullet
{
	public var x:Number;
	public var y:Number;
	private var vx:Number;
	private var vy:Number;
	private var dx:Number;
	private var dy:Number;
	
	private var _rotation:Number;
	private var _speed:int;
	private var _accele:Number;
	public var color:uint
	
	public function bullet(_x:uint,_y:uint,rota:Number,speed:int,accele:Number,_color:uint) 
	{
		x = _x;
		y = _y;
		_rotation = rota;
		_speed = speed;
		_accele = accele;
		vx = -Math.sin(rota)*speed;
		vy = -Math.cos(rota)*speed;
		dx = -Math.sin(rota)*accele;
		dy = -Math.cos(rota)*accele;
		color = _color;
	}
	
	public function move():void
	{
		x += vx += dx;
		y += vy += dy;
	}
	
	public function get rotation():Number
	{
		return _rotation;
	}
	
	public function set rotation(rota:Number):void
	{
		_rotation = rota;
		vx = -Math.sin(rota)*_speed;
		vy = -Math.cos(rota)*_speed;
	}
	
	public function get speed():int { return _speed; }
	
	public function set speed(value:int):void 
	{
		_speed = value;
	}
}
import flash.display.Sprite;
import flash.events.Event;
class enemy extends Sprite
{
	private var flg:Boolean = false;
	private var frame:int = 0;
	
	public function enemy(X:int) 
	{
		x = X;
		y = 150;
		graphics.beginFill(0x00FF00);
		graphics.drawRect(-10, -10, 20 ,20);
	}
	
	public function move():void
	{
		x = Math.sin(frame/50)*100+stage.stageWidth/2;
		y = Math.cos(frame/25)*20+150;
		frame++;
	}
}
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
class mine extends Sprite
{
	private const shield:Shape = new Shape();
	
	public function mine() 
	{
		graphics.beginFill(0xFF0000);
		graphics.moveTo(0, -10);
		graphics.lineTo( -10, 10);
		graphics.lineTo(10, 10);
		
		shield.graphics.lineStyle(5, 0xFFFFFF, 0.5);
		shield.graphics.drawCircle(0, 0, 20);
		addChild(shield);
	}
	
	public function move():void
	{
		x = (stage.mouseX + x) / 2;
		y = (stage.mouseY + y) / 2;
		x = (x < 0)?0:(x>=450)?449:x;
		y = (y < 0)?0:(y>=600)?599:y;
	}
	
	public function onShield():void
	{
		addChild(shield);
	}
	
	public function offShield():void
	{
		removeChild(shield);
	}
}