/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yLVZ
 */

package
{	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import com.bit101.components.HUISlider;
	
	public class Main extends Sprite
	{
		private var sizeSlider:HUISlider;
		private var vertexSlider:HUISlider;
		
		public function Main()
		{
			vertexSlider = new HUISlider(this, 0, 400, "vertex", sliderHandler);
			sizeSlider = new HUISlider(this, 0, 420, "size", sliderHandler);
			
			vertexSlider.x = (465 - vertexSlider.width) / 2;
			sizeSlider.x = (465 - sizeSlider.width) / 2;
			
			vertexSlider.value = 3;
			vertexSlider.minimum = 3;
			vertexSlider.maximum = 20;
			
			sizeSlider.value = 100;
			sizeSlider.minimum = 10;
			sizeSlider.maximum = 232;
		}
		
		private function sliderHandler(event:Event):void
		{
			createPolygon(vertexSlider.value, 232, 232, sizeSlider.value, false);
		}
		
		private function createPolygon(vertex:int, x:int, y:int, size:int, star:Boolean = false):void
		{
			if (vertex < 3) vertex = 3;
			
			var points:Array = new Array();
			for (var degree:Number = 0; degree < 360; degree += 360 / vertex)
			{
				var tx:Number = x + Math.cos(degree * Math.PI / 180) * size;
				var ty:Number = y + Math.sin(degree * Math.PI / 180) * size;
				points.push(new Point(tx, ty));
				
				if (star)
				{
					tx = x + Math.cos((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
					ty = y + Math.sin((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
					points.push(new Point(tx, ty));
				}
			}
			
			graphics.clear();
			graphics.lineStyle(8.0, 0x0);
			graphics.moveTo(points[0].x, points[0].y);
			for (var i:int = 1; i < points.length; i++)
			{
				graphics.lineTo(points[i].x, points[i].y);
			}
			graphics.lineTo(points[0].x, points[0].y);
		}
	}
}