/**
 * Copyright kennypu ( http://wonderfl.net/user/kennypu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yL5h
 */

//via http://pierrickpluchon.fr/blog/as3-how-to-plug-your-microphone-with-a-soundspectrum-in-flash-player-10-1/
/*
    TODO
    base the code on tweening rather than redrawing everytime
*/
package {
    import flash.events.SampleDataEvent;
    import flash.media.Microphone;
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    import flash.text.*;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    
    public class barVisualizer extends MovieClip 
    {
        public var _soundBytes:ByteArray = new ByteArray();
        public var _micBytes:ByteArray;
        public var sound:Sound;
        public var sc:SoundChannel;
        public var pow:int = 0;
        public var myBar:Sprite;
        
        public var text1:TextField;
        
        public var sampleArray:Array = new Array(16);
        
        public function barVisualizer() 
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            // write as3 code here..
            myBar = new Sprite();
            
            text1 = new TextField();
            text1.text = "Beat is Visualizer";
            text1.textColor = 0xFFFFFF;
            text1.x = 4; text1.y = 4;
            
            initMic();
            text1.text = "mic initialized";
            initSound();
            text1.text = "sound initialized";
            addEventListener(Event.ENTER_FRAME,drawLines);
        }
        private function initMic():void
        {
            //Security.showSettings(SecurityPanel.MICROPHONE);
            trace('mic initializing');
            var mic:Microphone = Microphone.getMicrophone();
            
            if(mic){
                mic.setLoopBack(false);
                mic.setUseEchoSuppression(true);
                mic.rate = 44;
                mic.gain = 60;
                mic.addEventListener(SampleDataEvent.SAMPLE_DATA,micSampleDataHandler);
            }
            else { text1.text = "can't access microphone. Please close anything that is using flash."; }

        }
        
        private function micSampleDataHandler(e:SampleDataEvent):void
        {
            _micBytes = e.data;
            sc = sound.play();
            sc.soundTransform = new SoundTransform(.3,0);
        }
        
        private function initSound():void
        {
            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA,soundSampleDataHandler);
            
            
        }
        
        private function soundSampleDataHandler(e:SampleDataEvent):void
        {
            for(var i:uint = 0; i < 8192 && _micBytes.bytesAvailable > 0; i++)
            {
                var sample:Number = _micBytes.readFloat();
                e.data.writeFloat(sample);
                e.data.writeFloat(sample);
            }

        }
        
        private function drawLines(e:Event):void
        {
              SoundMixer.computeSpectrum(_soundBytes,true);
               
            myBar.graphics.clear();
            myBar.graphics.beginFill(0x000000);
            myBar.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            myBar.graphics.endFill();
            
            myBar.graphics.lineStyle(2,0x00FFFF);
            var offset:int = stage.stageWidth/32;
            var offsetTotal:int = stage.stageWidth/32;
            for(var i:int=0; i < 256; i+=8)
            {
                if(_soundBytes.bytesAvailable) 
                    pow = _soundBytes.readFloat() * 600;
                pow = Math.abs(pow);
                //myBar.graphics.drawRect(i*2,0,2,pow);
                sampleArray[256%i] = pow;
                myBar.graphics.drawRect((i*2) + offsetTotal,stage.stageHeight,stage.stageWidth/32,-pow);
                offsetTotal += offset;
                
                
                var t:String = "";
                for(var j:int = 0; j < sampleArray.length;j++)
                    t += "Sample" + j + ": " + sampleArray[j]+ "\n";
                    
                //text1.text = t;             
                
                addChild(myBar);
                addChild(text1);
            }

        }


    }
}