/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yKtq
 */

/*
下記のblogにてもう少し詳しく説明しています。
http://umehara.net/blog/?p=32


Matrix3Dの一部の値が、1/20になったり、20倍になる。
バグだと思うんだけど、良くわかんない。

Matrix3D.transformVectorは解決されているようだけど
http://www.dango-itimi.com/blog/archives/2008/000967.html
Matrix3D.transpose()のほうは10,0,12,36でも解決されていない。

英語版のhelpで指摘されてるけど、関係ないレスが帰って来ている。 
http://help.adobe.com/en_US/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#transpose()

＊追記
10,0,22,87では解決された模様。



*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			var m:Matrix3D = new Matrix3D();
			var v:Vector3D=new Vector3D(500,1000,0);
			var c:Vector3D=m.transformVector(v);

			var txt:String="◆同機能関数Mtrx3D.transformVector　"+Capabilities.version+"での実行結果\n\n";

			txt+="10,0,12,36未満（10,0,2,54？）では\n↓がVector3D(25,50,0)になる\n"+String(c);
			//
			var m0:Matrix3D=new Matrix3D(Vector.<Number>([1,2,3,4,11,12,13,14,21,22,23,24,31,32,33,34]));
			var m1:Matrix3D=m0.clone();
			var m2:Matrix3D=m0.clone();
			txt+="\n\n\nまた、\n";
			txt+=m0.rawData;
			txt+="\nはtranspose()を使うとhelp通りだと";
			txt+="\n1,11,21,31,2,12,22,32,3,13,23,33,4,14,24,34";
			txt+="\n\nになるはずだけど実際は10.0.12.36でも以下のようになる。";

			m1.transpose();
			_transpose(m2);
			
			
			txt+="\n"+m1.rawData;
			txt+="\n\n同じ値を返す関数を作るとすると以下になる。\n"+m2.rawData;

			var tf1:TextField = new TextField();
			tf1.width=stage.stageWidth;
			tf1.height=stage.stageHeight;
			tf1.wordWrap=true;
			stage.addChild(tf1);
			tf1.text=txt;

			function _transpose(mt:Matrix3D):void {
				var m:Vector.<Number>=mt.rawData;
				var v:Vector.<Number>=new Vector.<Number>(16,true);
				v[0]=m[0];
				v[1]=m[4];
				v[2]=m[8];
				v[3]=m[12]*20;
				v[4]=m[1];
				v[5]=m[5];
				v[6]=m[9];
				v[7]=m[13]*20;
				v[8]=m[2];
				v[9]=m[6];
				v[10]=m[10];
				v[11]=m[14]*20;
				v[12]=m[3]/20;
				v[13]=m[7]/20;
				v[14]=m[11]/20;
				v[15]=m[15];
				mt.rawData=v;
			}
		}
	}
}