/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yKiq
 */

package  
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;

    public class Ring extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var segmentWidth:Number;
        private var segmentHeight:Number;
        private var deltaAngle:Number;
        private var segmentAmount:Number;
        private var manageGroupIndex:Boolean;
        private var limitAngle:Number;
        
        public function Ring() 
        {
            
            limitAngle = Math.PI*0.5;
            
            var wallWidth:Number = 1;
            var wallWidthHalves:Number = wallWidth*0.5;
            var cx:Number = wallWidthHalves;
            var cy:Number = wallWidthHalves;
            var stageWidth:Number = stage.stageWidth / 30-wallWidth;
            var stageHeight:Number = stage.stageHeight / 30-wallWidth;
            segmentWidth = 0.5;
            var ringsAmount:Number = 2;
            var ringsColumns:Number = 2;
            var cellSize:Number = stageWidth / ringsColumns;
            var radius:Number = (cellSize) * 0.5-segmentWidth;
            segmentAmount = 14;
            deltaAngle = Math.PI * 2 / segmentAmount;
            var ringHeight:Number = radius * Math.cos(deltaAngle * 0.5);
            sim = new QuickBox2D(this, { debug:false } );
            sim.gravity = new b2Vec2;
            sim.grid(30,0x666666);
            sim.createStageWalls();
            manageGroupIndex = false;
            for (var i:int = 0; i < ringsAmount; i++) 
            {
                addRing(cx+cellSize*((i % ringsColumns)+0.5),cy+cellSize*(Math.floor(i / ringsColumns)+0.5),ringHeight,i==1);
                
            }
            // start simulation
            sim.start();
            sim.mouseDrag();            
        }
        
        private function addRing(cx:Number, cy:Number,h:Number,doBrake:Boolean=false):void 
        {
            var extraWidthFactor:Number = 1.2;
            segmentHeight = 2 * h * Math.sin(deltaAngle * 0.5)*extraWidthFactor;
            var angle:Number = 0;
            var box:Object = 
            { 
                x:cx + h * Math.cos(angle), 
                y:cy + h * Math.sin(angle), 
                width:segmentWidth, 
                height:segmentHeight, 
                fixedRotation:false,
                angularDamping:1,
                linearDamping:2,
                density:1,
                fillAlpha:0.5
                };
           if(manageGroupIndex) box["groupIndex"] = -1;
            var pre:QuickObject = sim.addBox( box );
            if(manageGroupIndex) box["groupIndex"] = 1;
            box["fillAlpha"] = 0;
            var first:QuickObject = pre;
            for (var i:int = 0; i <segmentAmount-1; i++) 
            {
                angle += deltaAngle;
                box["angle"] = angle;
                box["x"] = cx + h * Math.cos(angle);
                box["y"] = cy + h * Math.sin(angle);
                if (i == segmentAmount - 2)
                {
                    if(manageGroupIndex) box["groupIndex"] = -1;
                    box["fillAlpha"] = 0.5;
                }
                var curr:QuickObject = sim.addBox(box);
                addJoint( pre.body, curr.body );
                pre = curr;
            }
            curr = first;
            /**
             * Detail about the reference angle for revolute joints whose angle is limited.
             * I didn't expect to search for "referenceAngle" within wonderfl.net and having no results 
             * except for the codes posted by me
             * The difference among the two rings is that in the one at the right side,
             * the reference angle has not been corrected
             */
            var localReferenceAngle:Number =doBrake?0: curr.body.GetAngle()-pre.body.GetAngle();
            addJoint(pre.body,curr.body,localReferenceAngle);
        }
        
        private function addJoint(aArg:b2Body, bArg:b2Body,referenceAngleArg:Number=0):QuickObject 
        {
            var radius:Number = 1;
            var getAngle:Number = aArg.GetAngle()+Math.PI*0.5;
            var output:QuickObject = sim.addJoint( { a:aArg, b:bArg, type:QuickBox2D.REVOLUTE 
            ,lowerAngle: -limitAngle, upperAngle:limitAngle, enableLimit:true, referenceAngle:referenceAngleArg,
            vecA:new b2Vec2(
                aArg.GetPosition().x + segmentHeight * 0.5 * Math.cos(getAngle), 
                aArg.GetPosition().y + segmentHeight * 0.5 * Math.sin(getAngle)
                ),
                collideConnected:false
            } );
            return output
        }
        
        
        
    }

}

