/**
 * Copyright hacker_w2kqj15r ( http://wonderfl.net/user/hacker_w2kqj15r )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yJqh
 */

// forked from sake's リンゴもどき
/*
	ワンダフル本のイベント見て、物凄くテンション上がってしまって。
    自分も何かリンゴ作りたくなりました。
	で、カージオイドを回転させればリンゴに見えるかなーって思って。
	
	・・・あんまリンゴに見えませんね。
	もっとリンゴっぽくしたい！
*/
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.geom.Matrix;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
	public class main extends BasicView
	{
		private var pixels:Pixels;
		private var canvas:BitmapData;
		private var mtx:Matrix;
		private var rotateX:Number;
		private var rotateY:Number;

		public function main()
		{
			super(0, 0, true, true);

			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, "clear_pre", true);
			layer.clearBeforeRender=true;
			viewport.containerSprite.addLayer(layer);

			camera.z=-22;
			pixels=new Pixels(layer);
			scene.addChild(pixels);

			rotateX=rotateY=0;

			// りんごの実の部分（カージオイドの回転体）
			for (var i:uint=0; i <= 7000; i++)
			{
				var theta01:Number=i * Math.PI / 180;
				var theta02:Number=Math.random() * 2 * Math.PI;

				var r:Number=(-Math.cos(theta01) - Math.sin(theta01) * Math.cos(theta01)) * 7;

				var yy:Number=(-Math.sin(theta01) - Math.sin(theta01) * Math.sin(theta01)) * 7 + 4;
				var xx:Number=r * Math.cos(theta02);
				var zz:Number=r * Math.sin(theta02);

				var color:uint=(0xff << 24 | 0xff * Math.random() << 16 | 0xff << 8 | 0xff * Math.random());

				var px:Pixel3D=new Pixel3D(color, xx, yy, zz);
				pixels.addPixel3D(px);
			}

			// へたの部分（適当な曲線のグラフを散らしてみる）
			for (var j:Number=0; j <= 2; j+=0.02)
			{
				yy=4 * Math.sqrt(j) + 5;
				color=(0xff << 24 | 0x90 << 16 | 0x98 * Math.random() << 8 | 0x00);

				var n:int=0;
				while (n < 10)
				{
					px=new Pixel3D(color, j * (0.2 * Math.random() + 0.9), yy * (0.2 * Math.random() + 0.9), 0.6 * Math.random() - 0.3);
					pixels.addPixel3D(px);
					n++;
				}
			}

			// キラキラー
			canvas=new BitmapData(465 >> 2, 465 >> 2, false, 0x000000);
			var bmp:Bitmap=new Bitmap(canvas, "never", true);
			bmp.scaleX=bmp.scaleY=4;
			bmp.smoothing=true;
			bmp.blendMode="add";
			addChild(bmp);
			mtx=new Matrix(0.25, 0, 0, 0.25);

			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		private function onFrame(e:Event):void
		{
			canvas.fillRect(canvas.rect, 0x000000);
			canvas.draw(viewport, mtx);

			// ローテーション
			rotateX+=(-viewport.containerSprite.mouseX - rotateX) * 0.05;
			rotateY+=(-viewport.containerSprite.mouseY - rotateY) * 0.05;
			pixels.rotationY=rotateX;
			pixels.rotationX=rotateY;
		}
	}
}